/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
 **  THIS FILE IS INCLUDED BY ians_core.o. HENCE, IT SHOULD NOT BE         **
 **  MODIFIED!                                                             **
 **                                                                        **
 **  Module Name:                                                          **
 **    incg_types.h                                                        **
 **                                                                        **
 **  Abstract:                                                             **
 **    iANS definitions for networking structures such as sk_buff,         **
 **    network device, ioctl, socket address etc.                          **
 **    iANS definitions of pointers to other structures neede by iANS      **
 **    such as timer etc.                                                  **
 **                                                                        **
 **  Environment:                                                          **
 **    Kernel Mode (linux 2.2.x)                                           **
 **                                                                        **
 ***************************************************************************/




#ifndef _INCG_TYPES_H_
#define _INCG_TYPES_H_

#include "incg_net.h"

typedef struct timer_list *pTimer_t;
typedef unsigned char *messageData_t;
typedef struct sk_buff *pOsMessage_t;
typedef struct device *pOsDevice_t;
typedef struct net_device_stats *pstats_t;
typedef struct ifreq *preq_t;
typedef struct packet_type *pPacket_t;
typedef struct pci_dev *pOsPciDev_t;


typedef struct {
  unsigned short family;
  char           saData[14];
} sockAddr_t;



typedef struct {
  pOsMessage_t pOsMessage;
  MAC_ADDR *pSrc;             //points to mac addrsses in the buffer pointed 
  MAC_ADDR *pDest;            //   by skb->head. (the actual ethernet packet).
  unsigned short *pProtocol;  //points to skb->protocol..
  char *Head;                 //points to skb->head.
  char *Data;                 //points to skb->data.
  int Len;                    //equals skb->len.
} message_t;


// The attribute header is kept at the beginning of the allocated buffer. 
#define getAttributeHeader(skb)  ( (char*)((skb)->Head) ) 


typedef struct _device_t {

  pOsDevice_t pOsDev;
  char        *name;
  void        *pAnsObj;
  BOOLEAN     tbusy;
  MAC_ADDR   mac;
  int (*open) (struct _device_t *dev);
  int (*close) (struct _device_t *dev);
  int (*send) (void *msg,void *dev);
  void (*IfReceive) (void *msg);
  int (*doIoctl) ( struct _device_t *ansDev, preq_t req, int cmd);
  int (*setMacAddr) (struct _device_t *ansDev, sockAddr_t *addr);
  pstats_t (*getStats) (struct _device_t *ansDev);
  int (*setMulticastList) (struct _device_t *ansDev,
			   MULTICAST_LIST *multicastList,
			   PACKET_FILTER packetFilter);  
} device_t;

#define GET_OS_DEV(dev)   ((dev)->pOsDev)
#define GET_OS_MSG(msg)   ((msg)->pOsMessage)

#define GET_ANS_OBJ(dev) ((dev)->pAnsObj)


typedef enum { IOCTL_GET_STATS , IOCTL_SET_MAC_ADDR , IOCTL_SET_MULTICAST_LIST , IOCTL_DO_IOCTL , IOCTL_OPEN , IOCTL_STOP, IOCTL_INDICATION } ioctlType_t;

typedef struct {
    ioctlType_t             ioctlType;
    int                     cmd;
    int                     retVal;
    preq_t                  req;
    pstats_t                stats; 
    sockAddr_t              sktAddr;
    MULTICAST_LIST          multicastList;
    PACKET_FILTER           packetFilter;
} genericIoctl_t;


typedef struct {
    unsigned int pci_reg[16];
} pciConfigSpace_t;

#endif
