/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
 **  Module Name:                                                          **
 **    incg_timer.c                                                        **
 **                                                                        **
 **  Abstract:                                                             **
 **    This module implements a timer for iANS.                            **
 **                                                                        **
 **  Environment:                                                          **
 **    Kernel Mode (linux 2.2.x)                                           **
 **                                                                        **
 ****************************************************************************/





//////////////////////////////////////////////////////////
//must allways stay the first lines in the file!
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif MODVERSIONS
//////////////////////////////////////////////////////////
#include <linux/malloc.h>
#include <linux/timer.h>

#include "incg_types.h"
#include "incg_gp_mem.h"

void timerDelete(pTimer_t pTimer) {

  del_timer((struct timer_list *)pTimer);

}


void timerAdd(pTimer_t pTimer) {

  add_timer((struct timer_list *)pTimer);
}



void timerInit(pTimer_t pTimer) {

  init_timer(pTimer);
}

pTimer_t timerGet(void) {
  struct timer_list *pTimer;

  pTimer =  kmalloc( sizeof(struct timer_list) , GFP_KERNEL);

  return pTimer;

}


void timerSet(pTimer_t pTimer, double invFreq,
	      unsigned long data, void (*function)(unsigned long)){

  //  Assert(pTimer);
  
  pTimer->expires = jiffies + (unsigned long)(invFreq * HZ);
  pTimer->data = data;
  pTimer->function = function;
  
}


void timerFree(pTimer_t *ppTimer) {

  if (*ppTimer != NULL)
    kfree ( (void *)(*(ppTimer)));
}
