/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
 **  THIS FILE IS INCLUDED BY ians_core.o. HENCE, IT SHOULD NOT BE         **
 **  MODIFIED!                                                             **
 **                                                                        **
 **  Module Name:                                                          ** 
 **    incg_net.h                                                          **
 **                                                                        **
 **  Abstract:                                                             **
 **    This module defines iANS networking (mac address, multicast list,   **
 **    packet filter etc.).                                                **
 **                                                                        **
 **  Environment:                                                          **
 **    Kernel Mode (linux 2.2.x)                                           **
 **                                                                        **
 ****************************************************************************/




#ifndef _INCG_NET_H_
#define _INCG_NET_H_
/* This file should be split to ethernet and general networking.
 * We did not do it yet necause it is too small to justify the
 * split */


#include "incg_defs.h"

#define MAC_ADDR_LEN 6

#pragma pack(1) 
typedef struct _MACADDR {
	UCHAR	MacAddr[MAC_ADDR_LEN];

} MAC_ADDR, *PMAC_ADDR;
#pragma pack() 

#define DUMMY_MAC_ADDR  { 0, 0, 0, 0, 0, 0 }

#define iNCGMacAddrCopy(ToAddr, FromAddr) iAnsMemCpy( ((void*)ToAddr), ((void*)FromAddr), MAC_ADDR_LEN );

/*-------------------------------------------------------------------------
   PACKET_FILTER
  -------------------------------------------------------------------------*/											
typedef ULONG	 PACKET_FILTER, *PPACKET_FILTER;

#define PF_PROMISCUOUS_BIT 0x00000001  /*  If this bit is set in the packet 
										   filter, set promisuous mode ON */

#define PF_ALLMCA_BIT  0x00000002 /*  If this bit is set in the packet 
										   filter, send MACIOC_SETALLMCA.
										   else send MACIOC_DELALLMCA */
#define DUMMY_PACKET_FILTER 0 

/*-------------------------------------------------------------------------
   MULTICAST_LIST
  -------------------------------------------------------------------------*/ 
 
typedef struct _MULTICAST_ENTRY 
{
	struct _MULTICAST_ENTRY    *pNextEntry;
	MAC_ADDR            MacAddr;
    USHORT              dmiAddrLen;
    USHORT              dmiUsers;
} MULTICAST_ENTRY, *PMULTICAST_ENTRY;
	
typedef struct _MULTICAST_LIST 
{
	PMULTICAST_ENTRY    pAddressesList;				
	UINT                NumAddresses;   /* List size */
} MULTICAST_LIST, *PMULTICAST_LIST;

#define DUMMY_MULTICAST_LIST { NULL,/* AddressesList */ 0     /* NumAddresses */ }

extern MULTICAST_LIST dummyMulticastLIst;

#endif /*_INCG_NET_H_ */


