/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
  **  Module Name:                                                          **
 **    incg_message.c                                                      **
 **                                                                        **
 **  Abstract:                                                             **
 **    This module implements library functions for handling frames.       **
 **                                                                        **
 **  Environment:                                                          **
 **    Kernel Mode (linux 2.2.x)                                           **
 **                                                                        **
 ****************************************************************************/

								
//////////////////////////////////////////////////////////
//must allways stay the first lines in the file!
#ifdef MODVERSIONS 
#include <linux/modversions.h>
#endif MODVERSIONS
//////////////////////////////////////////////////////////
#include <linux/skbuff.h>

#include "incg_message.h"
#include "incg_debug.h"
#include "incg_types.h"
#include "incg_utils.h"
#include "incg_log.h"

/* Allocates one message  */
pOsMessage_t iNCGMessageAllocate (UINT size)
{
	pOsMessage_t skb;

	debugConfigFine(("start"));
	skb = dev_alloc_skb(size);
	debugConfigFine(("end"));
	
	return skb;
}

/* Frees one message block */

VOID iNCGMessageFree (pOsMessage_t pMessage) 
{
        ASSERT(pMessage);
	dev_kfree_skb (pMessage);
}



UINT iNCGMessageWrite (pOsMessage_t pMessage,UINT length,UCHAR *pBuffer)
{
    
  ASSERT (pMessage && pBuffer);
      
  if ( length > skb_tailroom(pMessage))
    {
      iNCGLogPrint (( messageHandlingMsg2) );
      return -1;
    }


  iAnsMemCpy(skb_put(pMessage, length), pBuffer, length);
  

  return 0;

}



UCHAR *iNCGMessageRead (pOsMessage_t pMessage, 
		    UINT offset, 
		    UINT length)
{

  UINT pMaxLength;

  ASSERT(pMessage);
     
  
  pMaxLength = pMessage->tail - pMessage->data;
  
  if ( (length + offset) > pMaxLength) 
    return NULL;
  
  return (pMessage->data + offset);

}

UINT iNCGMessageGetMessageLength (pOsMessage_t pMessage)
{
  ASSERT(pMessage);
  
  return (pMessage->tail - pMessage->data);

}


messageData_t iNCGMessageGetMessageData(pOsMessage_t messagePtr) {

  return ((messageData_t)(messagePtr->data));

}
