/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
 **  Module Name:                                                          **
 **    incg_log.c                                                          **
 **                                                                        **
 **  Abstract:                                                             **
 **    This module prints log messages for iANS.                           **
 **                                                                        **
 **  Environment:                                                          **
 **    Kernel Mode (linux 2.2.x)                                           **
 **                                                                        **
 ***************************************************************************/



//////////////////////////////////////////////////////////
//must allways stay the first lines in the file!
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif MODVERSIONS
//////////////////////////////////////////////////////////

#include <stdarg.h>
#include "incg_log.h"
//#include "incg_misc.h"
#include "incg_utils.h"


void iNCGPrintArgs (const char * fmt,  ...)
{

	va_list ap;
	const char *p;
	char *sval;
	int ival, i;
	unsigned long ulval;
	UINT32 uival;
	char arg_buffer[MAX_ARG_LENGTH];
	char message_buffer[MAX_LINE_LENGTH+5]; 
	                                     /* add 5 for CR and LF and stuff */
	/* char *fmt; @@@ */

	int msg_buf_idx=0;
	int rem;

	message_buffer[msg_buf_idx++]=' ';	 /* set the first WORD to be '  ' so that */
	message_buffer[msg_buf_idx++]=' ';	 /* LINUX print will put this as the number */
                                                 /* for ALL C++ errors. Else it will just  */
        message_buffer[msg_buf_idx++]='A';
        message_buffer[msg_buf_idx++]='N';        
        message_buffer[msg_buf_idx++]='S';
        message_buffer[msg_buf_idx++]=':';
        message_buffer[msg_buf_idx++]=' ';        

										 /* put some random value which is not  */
	                                     /* uniform in look. */
	/* first parameter is format */
	/* @@@ va_start(ap, level); @@@ */
	va_start(ap, fmt);
	/* fmt = va_arg (ap, char*); @@@ */
	for (p=fmt; *p; p++)
	{
		if (*p != '%')
		{

			/* check there's enough room for one char and a null terminator */
			if (msg_buf_idx > MAX_LINE_LENGTH-2)
				break;

			message_buffer[msg_buf_idx++]=(*p);
			message_buffer[msg_buf_idx]='\0';
		
			continue;
		}
		
		switch(*++p)
		{
			case 'd':
				ival=va_arg(ap, int);
				iAnsItoa(ival, (char*)arg_buffer);
				arg_buffer[iAnsStrLen(arg_buffer)]='\0';
				
				for (i=0;i<iAnsStrLen(arg_buffer);i++)
				{
					/* check there's enough room for one char and a null terminator */
					if (msg_buf_idx > MAX_LINE_LENGTH-2)
						break;
					message_buffer[msg_buf_idx++]=arg_buffer[i];
					message_buffer[msg_buf_idx]='\0';
				}
				
				break;

			case 'l':
				ulval=va_arg(ap, unsigned long);
				iAnsUltoa(ulval, (char*)arg_buffer, 10);
				arg_buffer[iAnsStrLen(arg_buffer)]='\0';
				
				for (i=0;i<iAnsStrLen(arg_buffer);i++)
				{
					/* check there's enough room for one char and a null terminator */
					if (msg_buf_idx > MAX_LINE_LENGTH-2)
						break;
					message_buffer[msg_buf_idx++]=arg_buffer[i];
					message_buffer[msg_buf_idx]='\0';
				}
				
				break;

			case 's':
				for (sval=va_arg(ap, char*);*sval;sval++)
				{
					/* check there's enough room for one char and a null terminator */
					if (msg_buf_idx > MAX_LINE_LENGTH-2)
						break;
					message_buffer[msg_buf_idx++]=(*sval);
					message_buffer[msg_buf_idx]='\0';
				}
					
				break;


			case 'x':
			case 'X':
			case 'W':	/* prints DWORDS */
				/* check there's enough room for the DWORD and a null terminator */
				if (msg_buf_idx + 8 > MAX_LINE_LENGTH-1)
					break;

				/* zero the string space for the DWORD */
				for (i=0;i<8;i++)
					message_buffer[msg_buf_idx + i]='0';

				msg_buf_idx +=7;
				
				uival=va_arg(ap, UINT32);
				
				/* Starting from the end of the DWORD, print every character */
				for (i=0;i<8;i++)
				{
					rem = (int) (uival % 16);

					if (rem < 10)
						message_buffer[msg_buf_idx] = rem + '0';
					else
						message_buffer[msg_buf_idx] = (rem - 10) + 'a';
												
					msg_buf_idx--;
					uival = (int)(uival/16);
				}
				/* msg_buf_idx now points to one location before the location we started at, and we checked
					already that we have enough room */
				msg_buf_idx +=9;
				message_buffer[msg_buf_idx]='\0';

				break;

			default:
				return;

		}

	}
	
	va_end(ap);

	/* there's enough room for the CR/LF because we allocated MAX_LINE_LENGTH+5 and we checked that we didn't
		put more than MAX_LINE_LENGTH characters in the string */
	message_buffer[msg_buf_idx++]=10; /* @@@ Temporary @@@ */
	message_buffer[msg_buf_idx]='\0';	
	iAnsKernelPrint (INGC_INFO_LEVEL, message_buffer); /* Cont to prevent extra \n */

}





