/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
 **  THIS FILE IS INCLUDED BY ians_core.o. HENCE, IT SHOULD NOT BE         **
 **  MODIFIED!                                                             **
 **                                                                        **
 **  Module Name:                                                          ** 
 **    incg_flow.h                                                         **
 **                                                                        **
 **  Abstract:                                                             **
 **    This module translates Kernel control / status to                   **
 **    iANS control /status.                                               **
 **                                                                        **
 **  Environment:                                                          **
 **    Kernel Mode (linux 2.2.x)                                           **
 **                                                                        **
 ***************************************************************************/


#ifndef _FLOW_H_
#define _FLOW_H_


#include "incg_defs.h"

typedef enum _IANS_FLOW_STATUS 
{

	/* -----  Continue to next layer(s)  ----- */

	FLOW_CONTINUE,		/* Tell Flow to pass to next layers */


	/* -----  Healthy stop at this layer -----  */

	FLOW_OK,			/* Tell Flow to free or return positive reply
						 * to owner. Actual action depends on type of
						 * request and OS.
						 * (replaces FLOW_FREE_OK and FLOW_REPLY_OK) */

	FLOW_TRANSFERED,	/* Ownership transfered. Don't touch any more.
						 * New owner responsible for handling asyncly.
						 * Async handling may have already been
						 * completed by the time we return this status.
						 * (replaces FLOW_PENDIDNG) */


	/* -----  Error statuses  ----- */

	FLOW_MIN_ERROR,		/* Higher values indicates error conditions */

	/* Object related errors */
	FLOW_BUSY,			/* Exclusive object is already in use (EBUSY).
						 * Returned when it is inproper to busy-wait. */
	FLOW_DOESNT_EXIST,	/* Requested object not found (ENXIO) */
	FLOW_ALREADY_EXIST,	/* An object with the specified key already
						 * exists. Key must be unique. Can't create
						 * another object with same key. (EEXIST) */

	/* Operation related errors */
	FLOW_UNKNOWN_OPCODE, /* Unknown op-code (EOPNOTSUPP) */
	FLOW_WRONG_OBJECT,	/* Inappropriate request for object (ENODEV) */
	FLOW_WRONG_STATE,	/* Object is in wrong state ESTATE=EINVAL */
	FLOW_BAD_PARAMETER,	/* Invalid parameter (EINVAL).
						 * Relates to parameters other than the object
						 * and op-code. */

	/* Resources */
	FLOW_DB_FULL,		/* Internal DB is full. (ENOSPC)
						 * Used when request was to add an item to
						 * a limited table. */
	FLOW_COMM_RESOURCES,/* No more pre-allocated communications
						 * resources available or failed to allocate
						 * dynamically.
						 * Relates to resources such as frames and
						 * buffers (ENOBUFS)
						 * Used in cases that don't defer. */
	FLOW_GP_RESOURCES,	/* General purpose rsource allocation failed
						 * (ENOMEM). */

	FLOW_PROTOCOL_ERR ,    /* Proto/Ioctls were nacked by base driver or reply
				  from base driver implies it is working with a wrong
				  protocol. For example does not support ans extended
				  features */
	 
	/* Internal error */
	FLOW_INTERNAL_ERROR	/* An error has occured inside the module */

} IANS_FLOW_STATUS, *PIANS_FLOW_STATUS;


#define iANSFlowStatusIsProblem(FlowStatus)\
	( (FlowStatus) >= FLOW_MIN_ERROR )


IANS_FLOW_STATUS iANSOSToFlowStatus
(
	OS_STATUS			OSStatus
);



OS_STATUS iANSFlowToOSStatus
(
	IANS_FLOW_STATUS	FlowStatus
);



#ifdef NOT_DEFINED
MAC_STATUS iANSFlowToMACStatus
(
	IANS_FLOW_STATUS	FlowStatus
);
#endif


#endif /* _FLOW_H_ */





