/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
 **  Module Name:                                                          **
 **    incg_flow.c                                                         **
 **                                                                        **
 **  Abstract:                                                             **
 **    This module translates Kernel control / status to                   **
 **    iANS control /status.                                               **
 **                                                                        **
 **  Environment:                                                          **
 **    Kernel Mode (linux 2.2.x)                                           **
 **                                                                        **
 ***************************************************************************/

//////////////////////////////////////////////////////////
//must allways stay the first lines in the file!
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif MODVERSIONS
//////////////////////////////////////////////////////////
#include "incg_flow.h"
#include "incg_utils.h"

#include <linux/errno.h>




/*--------------------------------------------------------------------*
 | iANSOSToFlowStatus()
 *--------------------------------------------------------------------*/

// noam. to check the function. are the input value are fit to linux ?
IANS_FLOW_STATUS iANSOSToFlowStatus
(
	OS_STATUS			OSStatus
)
{
	IANS_FLOW_STATUS	FlowStatus;

	switch ( OSStatus )
	{
		case OS_STATUS_OK:	FlowStatus = FLOW_OK;				break;
		case EBUSY:			FlowStatus = FLOW_BUSY;				break;
		case ENXIO:			FlowStatus = FLOW_DOESNT_EXIST;		break;
		case EEXIST:		FlowStatus = FLOW_ALREADY_EXIST;	break;
		case EOPNOTSUPP:	FlowStatus = FLOW_UNKNOWN_OPCODE;	break;
		case ENODEV:		FlowStatus = FLOW_WRONG_OBJECT;		break;
	 // ESTATE is defined to be =  EINVAL !
  //	case ESTATE:		FlowStatus = FLOW_WRONG_STATE;		break;
		case EINVAL:		FlowStatus = FLOW_BAD_PARAMETER;	break;
		case ENOSPC:		FlowStatus = FLOW_DB_FULL;			break;
		case ENOBUFS:		FlowStatus = FLOW_COMM_RESOURCES;	break;
		case ENOMEM:		FlowStatus = FLOW_GP_RESOURCES;		break;
        case EPROTO:        FlowStatus = FLOW_PROTOCOL_ERR;     break;
		default:
#ifdef INCG_DEBUG
			/* @@@ Should think of a better way @@@ */
			FlowStatus = FLOW_INTERNAL_ERROR;
			iAnsPanic ("Can't convert OSStatus=%d to Flow",
				(int)OSStatus );
#else
			FlowStatus = FLOW_INTERNAL_ERROR;
#endif

	} /* switch OSStatus */
	return ( FlowStatus );
} /* iANSOSToFlowStatus() */



/*--------------------------------------------------------------------*
 | iANSFlowToOSStatus()
 *--------------------------------------------------------------------*/

OS_STATUS iANSFlowToOSStatus
(
	IANS_FLOW_STATUS	FlowStatus
)
{
	OS_STATUS	OSStatus;

	switch ( FlowStatus )
	{
		case FLOW_OK:				OSStatus = OS_STATUS_OK;	break;
		case FLOW_BUSY:				OSStatus = EBUSY;			break;
		case FLOW_DOESNT_EXIST:		OSStatus = ENXIO;			break;
		case FLOW_ALREADY_EXIST:	OSStatus = EEXIST;			break;
		case FLOW_UNKNOWN_OPCODE:	OSStatus = EOPNOTSUPP;		break;
		case FLOW_WRONG_OBJECT:		OSStatus = ENODEV;			break;
		case FLOW_WRONG_STATE:		OSStatus = ESTATE;			break;
		case FLOW_BAD_PARAMETER:	OSStatus = EINVAL;			break;
		case FLOW_DB_FULL:			OSStatus = ENOSPC;			break;
		case FLOW_COMM_RESOURCES:	OSStatus = ENOBUFS;			break;
		case FLOW_GP_RESOURCES:		OSStatus = ENOMEM;			break;
        case FLOW_PROTOCOL_ERR:     OSStatus = EPROTO;          break;
		case FLOW_CONTINUE:
		case FLOW_TRANSFERED:
		case FLOW_MIN_ERROR:
		case FLOW_INTERNAL_ERROR:
		default:
#ifdef INCG_DEBUG
			/* @@@ Should think of a better way @@@ */
			OSStatus = ENXIO; /* need some non-zero value...*/
			iAnsPanic ("Can't convert FlowStatus=%d to OS",
				(int)FlowStatus );
#else
			/* @@ add a log message ? */
			OSStatus = ENXIO; /* need some non-zero value...*/
#endif

	} /* switch FlowStatus */
	return ( OSStatus );
} /* iANSFlowToOSStatus() */


/*--------------------------------------------------------------------*
 | iANSFlowToMACStatus()
 *--------------------------------------------------------------------*/

#ifdef NOT_DEFINED
MAC_STATUS iANSFlowToMACStatus
(
	IANS_FLOW_STATUS	FlowStatus
)
{
	MAC_STATUS	MACStatus;

	switch ( FlowStatus )
	{

		case FLOW_OK:
			MACStatus = MAC_STATUS_OK;
			break;

		case FLOW_BUSY:
		case FLOW_DOESNT_EXIST:
		case FLOW_ALREADY_EXIST:
		case FLOW_WRONG_OBJECT:
		case FLOW_WRONG_STATE:

			MACStatus = MAC_OUTSTATE;
			break;

		case FLOW_UNKNOWN_OPCODE:
		case FLOW_BAD_PARAMETER:
			MACStatus = MAC_BADPRIM;
			break;

		case FLOW_DB_FULL:
		case FLOW_COMM_RESOURCES:
		case FLOW_GP_RESOURCES:
		case FLOW_CONTINUE:
		case FLOW_TRANSFERED:
		case FLOW_MIN_ERROR:
		case FLOW_INTERNAL_ERROR:
	    default:
			MACStatus = MAC_INITFAILED;

	} /* switch FlowStatus */
	return ( MACStatus );
} /* iANSFlowToMACStatus() */

#endif
