/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
 **  THIS FILE IS INCLUDED BY ians_core.o. HENCE, IT SHOULD NOT BE         **
 **  MODIFIED!                                                             **
 **                                                                        **
 **  Module Name:                                                          **
 **    incg_defs.h                                                         **
 **                                                                        **
 **  Abstract:                                                             **
 **    This file contains all the iANS defined variable types.             **
 **                                                                        **
 **  Environment:                                                          **
 **    Kernel Mode (linux 2.2.x)                                           **
 **                                                                        **
 ***************************************************************************/

#ifndef __INCG_DEFS_H__
#define __INCG_DEFS_H__

#include "linux_defs.h"

#define CONST const


typedef unsigned int SIZE_T;

typedef void           VOID;
typedef void           *PVOID;

typedef unsigned char  UINT8;
typedef unsigned char   *PUINT8;
#ifdef UINT16
  #undef UINT16
#endif 
typedef USHORT UINT16;
typedef USHORT *PUINT16;
#ifdef UINT32
  #undef UINT32
#endif
typedef ULONG  UINT32;
typedef ULONG  *PUINT32;
typedef signed long INT32;
typedef signed long *PINT32;

typedef UINT32 UINT;
typedef UINT32  *PUINT;

#define MAXUINT UINT_MAX
#define MAXUINT16 USHRT_MAX

typedef enum _INCG_BOOLEAN {
	INCG_FALSE=0,
	INCG_TRUE
} INCG_BOOLEAN;

#ifndef NULL
	#define  NULL 0
#endif


/* Error (!=0) values taken from errno.h */


typedef int OS_STATUS;
#define OS_STATUS_OK 0
#define ESTATE EINVAL


/* Error (!=0) values taken from sys/mdi.h */

typedef int MAC_STATUS;
#define MAC_STATUS_OK	0

#define ETHERNET_MAX_FRAME_SIZE 1514
#define ETHERNET_MIN_FRAME_SIZE 14

/* for library functions */


#define MAX_ARG_LENGTH	20
#define MAX_LINE_LENGTH	150


// Introduced for readability.
// Mark parameter is input to function.
#define IN


#endif /* __INCG_DEFS_H__  */

//#endif


