/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
 **  THIS FILE IS INCLUDED BY ians_core.o. HENCE, IT SHOULD NOT BE         **
 **  MODIFIED!                                                             **
 **                                                                        **
 **  Module Name:                                                          **
 **    incg_debug.h                                                        **
 **                                                                        **
 **  Abstract:                                                             **
 **    This module contains all the functions and macros needed for debug  **
 **    prints and assertions.                                              **
 **                                                                        **
 **  Environment:                                                          **
 **    Kernel Mode  (linux 2.2.x)                                          **
 **                                                                        **
 ***************************************************************************/


#ifndef _INCG_DEBUG_H_
#define _INCG_DEBUG_H_

#include "incg_defs.h"
#include "incg_log.h"
#include "incg_utils.h"


/*
 | Debug mode
 | ==========
 | In the future one may choose to distinguish between the
 | standard DEBUG and the proprietary INCG_DEBUG.
 | For now, whenever only one is defined, we define both.
 | if DEBUG or INCG_DEBUG are defined, ANS_DBG is also used in some of the files.
 */


extern unsigned long GlobalDebugLevel;

#ifdef INCG_DEBUG

       #ifndef DEBUG
               #define DEBUG
       #endif /* ifndef DEBUG */
    
       #ifndef ANS_DBG
               #define ANS_DBG
       #endif /* ifndef ANS_DBG */

#endif /* ifdef INCG_DEBUG */

#ifdef DEBUG

        #ifndef INCG_DEBUG
		#define INCG_DEBUG
	#endif /* ifndef INCG_DEBUG */
    
        #ifndef ANS_DBG
		#define ANS_DBG
	#endif /* ifndef ANS_DBG */

#endif /* DEBUG */

#ifdef DEBUG
         #define ASSERT(x) {\
          if (!(x)) (iAnsPanic("assertion %s failed: file %s line %d\n", #x , __FILE__,__LINE__));}
#else
         #define ASSERT(x)
#endif

#define Assert(x) ASSERT(x)
#undef  assert



#ifdef INCG_DEBUG


	/*----------------------------------------------------------------*
	 | Debug Filtering Definitions
	 | ===========================
	 | Messages with debug level less or equal to the current system-
	 | wide debug level and appearing in the debug topic mask will be
	 | printed. 
	 *----------------------------------------------------------------*/

	/* Debug level (4 bits ordinal = 16 debug levels) */
//#define DEBUG_LEVEL_ALWAYS		0x0000000F     /* Wildcard */
#define DEBUG_LEVEL_ERROR		0x00000001	/* Print only errors */
#define DEBUG_LEVEL_WARNING		0x00000002	/* Print warnings too */
#define DEBUG_LEVEL_INFO		0x00000003	/* Print FYIs */
#define DEBUG_LEVEL_ROUGH		0x00000004	/* High level trace */
#define DEBUG_LEVEL_MEDIUM		0x00000005	/* Medium trace */
#define DEBUG_LEVEL_FINE		0x00000006	/* Fine details */
#define DEBUG_LEVEL_MASK		0x0000000F

	/* Debug topic - Should move to application specific header */
#define DEBUG_TOPIC_ALL			0x7FFFFFF0	/* Wildcard (can't exceed 7FFFFFFF = LONG_MAX)*/
#define DEBUG_TOPIC_CONFIG		0x00000010	/* Topology config */
#define DEBUG_TOPIC_TX			0x00000020	/* Transmit */
#define DEBUG_TOPIC_RX			0x00000040	/* Receive */
#define DEBUG_TOPIC_IOCTL		0x00000080	/* Standard IOCTLs */
#define DEBUG_TOPIC_INDICATE	0x00000100	/* Upwards indication */
#define DEBUG_TOPIC_FT			0x00010000	/* Fault Tolerance */
#define DEBUG_TOPIC_LB			0x00020000	/* Load Balancing */
#define DEBUG_TOPIC_FEC                 0x00030000     /* FEC */
#define DEBUG_TOPIC_GEC                 0x00040000
#define DEBUG_TOPIC_AD                  0x00050000
#define DEBUG_TOPIC_IBVLANID	0x00100000	/* Binding Based VLan ID */
#define DEBUG_TOPIC_DEFERRED	0x80000000	/* Deferred coding */
#define DEBUG_TOPIC_MASK		0xFFFFFFF0

	/* Make most structures begin with a string viewable by debuggers */
#define STRUCT_DEBUG_STRING
#define DEBUG_PATTERN_LENGTH	8

typedef char			DEBUG_PATTERN[DEBUG_PATTERN_LENGTH];

	/* Make private symbols public so that they are visible to the
	 * debugger */
#define STATIC 
 
#define debugIndicateFine( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_INDICATE,ParanthesizedPrintParams  );

#define debugIndicateErr( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_ERROR|DEBUG_TOPIC_INDICATE,ParanthesizedPrintParams  );

#define debugIndicateInfo( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_INFO|DEBUG_TOPIC_INDICATE,ParanthesizedPrintParams  );

#define debugIoctlFine( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_IOCTL,ParanthesizedPrintParams  );   

#define debugIoctlErr( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_ERROR|DEBUG_TOPIC_IOCTL,ParanthesizedPrintParams  );  


#define debugRxFine( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_RX,ParanthesizedPrintParams  );   

#define debugRxErr( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_ERROR|DEBUG_TOPIC_RX,ParanthesizedPrintParams  );   

#define debugTxFine( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_TX,ParanthesizedPrintParams  );   

#define debugTxErr( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_ERROR|DEBUG_TOPIC_TX,ParanthesizedPrintParams  ); 

#define debugFtRough( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_ROUGH|DEBUG_TOPIC_FT,ParanthesizedPrintParams  );   

#define debugFtFine( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_FT,ParanthesizedPrintParams  );

#define debugFtErr( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_ERROR|DEBUG_TOPIC_FT,ParanthesizedPrintParams  );   

#define debugFECFine( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_FEC,ParanthesizedPrintParams  );

#define debugFECErr( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_ERROR|DEBUG_TOPIC_FEC,ParanthesizedPrintParams  );

#define debugGECFine( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_GEC,ParanthesizedPrintParams  );

#define debugGECErr( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_ERROR|DEBUG_TOPIC_GEC,ParanthesizedPrintParams  );

#define debugADFine( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_AD,ParanthesizedPrintParams  ); 

#define debugADErr( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_ERROR|DEBUG_TOPIC_AD,ParanthesizedPrintParams  );

#define debugConfigFine( ParanthesizedPrintParams ) \
      iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_CONFIG,ParanthesizedPrintParams  );   

#define debugConfigErr( ParanthesizedPrintParams ) \
      iNCGDebugPrint ( DEBUG_LEVEL_ERROR|DEBUG_TOPIC_CONFIG,ParanthesizedPrintParams  );   

#define debugConfigWarning( ParanthesizedPrintParams ) \
      iNCGDebugPrint ( DEBUG_LEVEL_WARNING|DEBUG_TOPIC_CONFIG,ParanthesizedPrintParams  );

#define debugWrapperFine( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_IOCTL, ParanthesizedPrintParams  );   

#define debugVlanFine( ParanthesizedPrintParams ) \
      iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_IBVLANID,ParanthesizedPrintParams  );

#define debugLBError( ParanthesizedPrintParams ) \
      iNCGDebugPrint ( DEBUG_LEVEL_ERROR|DEBUG_TOPIC_LB,ParanthesizedPrintParams  );

#define debugLBRough( ParanthesizedPrintParams ) \
      iNCGDebugPrint ( DEBUG_LEVEL_ROUGH|DEBUG_TOPIC_LB,ParanthesizedPrintParams  );

#define debugLBMedium( ParanthesizedPrintParams ) \
      iNCGDebugPrint ( DEBUG_LEVEL_MEDIUM|DEBUG_TOPIC_LB,ParanthesizedPrintParams  );

#define debugLBFine( ParanthesizedPrintParams ) \
      iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_LB,ParanthesizedPrintParams  );



#define debugAll( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_ALL,ParanthesizedPrintParams  );   

#define debugInfoAll( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_INFO|DEBUG_TOPIC_ALL,ParanthesizedPrintParams  );   



    // translation for the Shared code ANS_DBGPRINT to iNCGDebugPrintArgs
#define ANS_DBGPRINT(ParanthesizedPrintParams)    iNCGPrintArgs ParanthesizedPrintParams;

// Debug print formatting
#define IANS_MEMBER_ID_FMT		"%d"
#define IANS_MEMBER_ID_FIELD	TeamMember.MemberID

//#define IANS_MUX_ID_FMT			"%d"
//#define IANS_MUX_ID_FIELD		TeamMember.Oss.pWrapperHandle->...


#define iNCGDTOPIC(mode) ( ((mode) & DEBUG_TOPIC_MASK & GlobalDebugLevel) || (((mode) & DEBUG_TOPIC_MASK)==0) )

#define iNCGDLEVEL(mode) (((mode) & DEBUG_LEVEL_MASK) && ((mode) & DEBUG_LEVEL_MASK) <= (GlobalDebugLevel & DEBUG_LEVEL_MASK))

#define iNCGDCHK(flags)  ((iNCGDTOPIC(flags) && iNCGDLEVEL(flags)))



#define iNCGDebugPrint( TopicAndLevel, ParanthesizedPrintParams ) \
	{ \
		if(iNCGDCHK(TopicAndLevel)) \
		{ \
		iAnsKernelPrint(INGC_NO_LEVEL,"%s %d :",__PRETTY_FUNCTION__,__LINE__); \
			iNCGPrintArgs ParanthesizedPrintParams; \
		} \
	} 





#define iNCGDebugConditionPrint( Condition, TopicAndLevel, ParanthesizedPrintParams )\
		  { \
            if (Condition) \
				iNCGDebugPrint (TopicAndLevel, ParanthesizedPrintParams ); \
		  }
         

void iNCGDebugBreakpoint ( UINT32 TopicAndLevel );

/////////////////////////////////////////////////////////////////////////////
#else /* Meaning not INCG_DEBUG */
/////////////////////////////////////////////////////////////////////////////

/* Hide private symbols */
#define STATIC	static

#define ANS_DBGPRINT(ParanthesizedPrintParams)
#define iNCGDTOPIC(mode) 
#define iNCGDLEVEL(mode) 
#define iNCGDCHK(flags)  
    
#define iNCGDebugPrint( TopicAndLevel, ParantesizedPrintParams )
#define iNCGDebugConditionPrint( Condition, TopicAndLevel, ParanthesizedPrintParams ) 
#define iNCGDebugBreakpoint( TopicAndLevel )

#define debugIndicateFine( ParanthesizedPrintParams ) 

#define debugIndicateErr( ParanthesizedPrintParams )

#define debugIndicateInfo( ParanthesizedPrintParams ) 

#define debugIoctlFine( ParanthesizedPrintParams ) 

#define debugIoctlErr( ParanthesizedPrintParams ) 

#define debugRxFine( ParanthesizedPrintParams ) 

#define debugRxErr( ParanthesizedPrintParams ) 

#define debugTxFine( ParanthesizedPrintParams )

#define debugTxErr( ParanthesizedPrintParams )

#define debugFtRough( ParanthesizedPrintParams ) 

#define debugFtFine( ParanthesizedPrintParams )

#define debugFtErr( ParanthesizedPrintParams ) 

#define debugFECFine( ParanthesizedPrintParams ) 

#define debugFECErr( ParanthesizedPrintParams ) 

#define debugGECFine( ParanthesizedPrintParams ) 

#define debugGECErr( ParanthesizedPrintParams ) 

#define debugADFine( ParanthesizedPrintParams ) 

#define debugADErr( ParanthesizedPrintParams )

#define debugConfigFine( ParanthesizedPrintParams ) 

#define debugConfigErr( ParanthesizedPrintParams )

#define debugConfigWarning( ParanthesizedPrintParams ) 

#define debugWrapperFine( ParanthesizedPrintParams ) 

#define debugVlanFine( ParanthesizedPrintParams ) 

#define debugLBError( ParanthesizedPrintParams ) 

#define debugLBRough( ParanthesizedPrintParams ) 

#define debugLBMedium( ParanthesizedPrintParams ) 

#define debugLBFine( ParanthesizedPrintParams ) 

#define debugAll( ParanthesizedPrintParams ) \
     iNCGDebugPrint ( DEBUG_LEVEL_FINE|DEBUG_TOPIC_ALL,ParanthesizedPrintParams  );   

#define debugInfoAll( ParanthesizedPrintParams ) 

  


#endif /*  INCG_DEBUG */


/* @@@ need to distinguish CE_NOTE, CE_WARN, CE_PANIC @@@ */


#endif /* _INCG_DEBUG_H_ */





