/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
 **  THIS FILE IS INCLUDED BY ians_core.o. HENCE, IT SHOULD NOT BE         **
 **  MODIFIED!                                                             **
 **                                                                        **
 **  Module Name:                                                          **
 **   ians_base.h                                                          **
 **                                                                        **
 **  Abstract:                                                             **
 **    This module contains all the functions needed for the interface of  **
 **    the iANS module with the base driver.                               **
 **                                                                        **
 **  Environment:                                                          **
 **    Kernel Mode  (linux 2.2.x)                                          **
 **                                                                        **
 ***************************************************************************/

#ifndef _IANS_BASE_H
#define _IANS_BASE_H

#include "incg_net.h"
#include "base_comm.h"
#include "incg_types.h"
#include "incg_utils.h"

int baseOpenDevice(device_t *dev);
int baseCloseDevice(device_t  *dev);
int baseSend(device_t *ansDev, message_t *msg);
int baseDoIoctl(device_t *dev, preq_t ifr, int cmd); 
int baseSetMacAddr(device_t *dev, sockAddr_t *addr);
pstats_t baseGetStats(device_t *dev);

     
int baseIdentify (device_t *base );
int baseSetExtMode (device_t *base );
int baseGetExtendedCapability ( device_t *base, IANS_BD_PARAM_EXT_CAP *cap);
int baseGetStatusInfo ( device_t *base, IANS_BD_IOC_PARAM_STATUS *stat);

#ifdef IANS_TAGGING
int baseSetTaggingMode (device_t *base, IANS_BD_TAGGING_MODE TagMode);
int baseGetTaggingCapability (device_t *base, IANS_BD_PARAM_ITAG_CAP *cap);
#endif

#ifdef IANS_BINDING_BASED_VLAN
int baseSetVlanMode (device_t *base, IANS_BD_MODE  mode);
int baseSetVlanIdTable(device_t *base, UINT16 *vlanIdTable, UINT32 vlanNum);
int baseGetVlanCapability (device_t *base, IANS_BD_PARAM_IVLAN_CAP *cap);
#endif

int baseUndoSettings (device_t *base);

int baseSetMulticastList(device_t *dev, MULTICAST_LIST *multicastList, PACKET_FILTER packetFilter);

int baseSetNotifyCB(device_t *base);



//Used by iAnsNotify
typedef struct _IANS_INDICATION_HEADER
{
  int  IndType;

} IANS_INDICATION_HEADER, *PIANS_INDICATION_HEADER;


//Used by iAnsNotify to send indication up the flow
//using a generic ioctl.
typedef struct _IANS_BD_IND_PARAM_STATUS
{
	IANS_INDICATION_HEADER   Header;
	IANS_BD_PARAM_STATUS     Status;
} IANS_BD_IND_PARAM_STATUS, *PIANS_BD_IND_PARAM_STATUS;


extern inline UINT32 convertSpeedToMBPS(UINT32 speed) {
    
    UINT32 NumZeroes = iAnsLog2(speed);
    UINT32 MBPSSpeed = 1;
    UINT32 i;

    if (speed == 0)
		return 0;
    
    for (i=0; i<NumZeroes; i++)
       MBPSSpeed *= 10;

    return MBPSSpeed;
}


#endif _IANS_BASE_H
 


