#!/usr/bin/perl
#--------------------------------------------------------------------------------
#--------------------------------------------------------------------------------
# Copyright (c) 1999 - 2000, Intel Corporation 
#
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without 
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice, 
#    this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation 
#    and/or other materials provided with the distribution.
#
# 3. Neither the name of Intel Corporation nor the names of its contributors 
#    may be used to endorse or promote products derived from this software 
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
# NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
# EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
#
#--------------------------------------------------------------------------------
#--------------------------------------------------------------------------------

#   /***************************************************************************
#   **                                                                        **
#   ** INTEL CORPORATION                                                      **
#   **                                                                        **
#   ** This software is supplied under the terms of the license included      **
#   ** above.  All use of this software must be in accordance with the terms  **
#   ** of that license.                                                       **
#   **                                                                        **
#   **  Abstract:                                                             **
#   **    Configuration script for ANS - General Definitions (SuSE)           **
#   **                                                                        **
#   ***************************************************************************/
$PROCDIR="/proc/net/PRO_LAN_Adapters";
$APP="/usr/sbin/ianscfg";
$CONF="/etc/conf.modules";
$CONF="/etc/modules.conf" unless (-e $CONF);
$VERSION=`uname -r`;
chomp $VERSION;
$MODULEDIR="/lib/modules/$VERSION/net";
$IFCFGDIR="/etc/sysconfig/network-scripts";
$SCRIPTDIR="/sbin/init.d";
$LINKSDIR="/sbin/init.d";
$STARTLEVEL="04";
$KILLLEVEL="41";
$MAXADAPTERS=4;
@MODES=("none", "AFT", "ALB", "FEC", "GEC");
@PRIORITIES=("none", "primary", "secondary");
@MODS100=("e100", "eepro", "eepro100", "eexpress");
@MODS1000=("e1000");
%BOOTPROTOS=("n", "none", "b", "bootp", "d", "dhcp", "o", "other");

sub options
{
	 my($def, $others) = @_;
	 $disp_def = $def;
	 $disp_others =  $others;
	 $disp_others =~ s/(.)/\1\//g;
	 $disp_def =~ tr/[a-z]/[A-Z]/;
	 chop ($disp_others);

	 $_ = "";
	 while (!/$\ *[$def$others]/)
	 {
		  print "([$disp_def]/$disp_others): ";
		  $_ = <STDIN>;
		  chomp;
		  tr/[A-Z]/[a-z]/;
		  $_ = $def unless ($_);
	 }
	 s/^\ *(.)*/\1/;
	 return $_;
}

sub setonboot
{
	 my($adapter, $onboot) = @_;
	 my(@lines);
	 return if ($onboot eq "yes");
	 $index = `cat /etc/rc.config | grep NETDEV | grep $adapter`;
	 return unless ($index =~ /NETDEV(_.)/);
	 $index = $1;
	 foreach $line (`cat /etc/rc.config`)
	 {
	     if ($line =~ /^IFCONFIG$index/)
	     {
				push @lines, "#$line";
				push @lines, "IFCONFIG$index=\"\"\n";
	     }
	     else
	     {
				push @lines, $line;
	     }
	 }
	 open (OUT, ">/etc/rc.config");
	 print OUT @lines;
	 close (OUT);
}
