/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
 **  THIS FILE IS INCLUDED BY ians_core.o. HENCE, IT SHOULD NOT BE         **
 **  MODIFIED!                                                             **
 **                                                                        **
 **  Module Name:                                                          **
 **    status.h                                                            **
 **                                                                        **
 **  Abstract:                                                             **
 **    Definitions for reporting the ANS configuration and activity status.**
 **                                                                        **
  **  Environment:                                                         **
 **    Kernel Mode  (Linux 2.2.x)                                          **
 **                                                                        **
 ***************************************************************************/


#ifndef _API_STATUS_H
#define _API_STATUS_H

#include "pubDefs.h"

/*****************
 *    entities   * 
 *****************/



typedef enum _iansEntities {

	IANS_NONE,
	IANS_ALL,
	IANS_MODULE_VERSION,
	IANS_MODULE_DESCRIPTION,
	IANS_MODULE_MANUFACTURE,
	
	// ---- mux ----
	IANS_MUX,
	IANS_MUX_STATUS,
	IANS_VLAN_ENABLED,
	IANS_TAGGING_MODE,
	IANS_MUX_SPEED,
	
	// ---- teaming ----
	IANS_TEAMING_MODE,
	IANS_CURRENT_PRIMARY,

	// ---- probes ----
	IANS_PROBE_ENABLE,  
	IANS_PROBE_ADDR_MODE,
	IANS_PROBE_CHECK_TIMEOUT,  
	IANS_PROBE_SEND_TIME,
	IANS_PROBE_MAX_RETRY_COUNT,
	IANS_PROBE_RECEIVE_TIMEOUT,
	IANS_PROBE_RX_BACK_CYCLES,
	IANS_PROBE_BURST_SIZE,

	// ---- member ----
	IANS_MEMBER,
	IANS_MEMBER_IS_SERVER_ADAPTER,
	IANS_MEMBER_SPEED,
	IANS_MEMBER_PRIORITY,
	IANS_MEMBER_LINK_STATUS,
	IANS_MEMBER_PROBE_STATUS,

	// ---- vadapter ----
	IANS_VADAPTER,
	IANS_VLAN_ID,
	
	// ----- max entity ----
	IANS_MAX_ENTITIES

} iansEntities_t;



typedef struct _statusLine {

	iansEntities_t entity;
	char parent[NAME_LEN];
	char value[NAME_LEN];
	int intValue;
	struct _statusLine *next; 

} statusLine;


iansStatus_t statusGetAndAllocate(iansEntities_t feature,const char* entity_name, statusLine** res_list);

iansStatus_t statusGet(iansEntities_t feature,const char* entity_name, statusLine* res_list);

iansStatus_t statusFreeList(statusLine *ians_list);

char* statusGetEntityDescription(iansEntities_t feature);

char* statusGetErrorDescription(iansStatus_t error);

#endif //_API_STATUS_H






