/*****************************************************************************
 *****************************************************************************
 Copyright (c) 1999 - 2000, Intel Corporation 

 All rights reserved.

 Redistribution and use in source and binary forms, with or without 
 modification, are permitted provided that the following conditions are met:

 1. Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer.

 2. Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation 
    and/or other materials provided with the distribution.

 3. Neither the name of Intel Corporation nor the names of its contributors 
    may be used to endorse or promote products derived from this software 
    without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
 AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 DISCLAIMED. IN NO EVENT SHALL CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 

 *****************************************************************************
 ****************************************************************************/

 /***************************************************************************
 **                                                                        **
 ** INTEL CORPORATION                                                      **
 **                                                                        **
 ** This software is supplied under the terms of the license included      **
 ** above.  All use of this software must be in accordance with the terms  **
 ** of that license.                                                       **
 **                                                                        **
 **  THIS FILE IS INCLUDED BY ians_core.o. HENCE, IT SHOULD NOT BE         **
 **  MODIFIED!                                                             **
 **                                                                        **
 **  Module Name:                                                          **
 **    pubDefs.h                                                           **
 **                                                                        **
 **  Abstract:                                                             **
 **    Public definitions for the ianscfg and the ANS module (Error codes  **
 **    etc.).                                                              **
 **                                                                        **
 **  Environment:                                                          **
 **    Kernel Mode  (Linux 2.2.x)                                          **
 **                                                                        **
 ***************************************************************************/


#ifndef __ANS_CONFIG_H__
#define __ANS_CONFIG_H__

/*****************************
 *    forward declerations   * 
 *****************************/

typedef struct _CONF_CONFIG_OBJ CONF_CONFIG_OBJ;
typedef CONF_CONFIG_OBJ* CONF_HANDLER;
 
typedef struct _CONF_ADAPTER CONF_ADAPTER;
typedef CONF_ADAPTER* ADAPTER_HANDLER;

typedef struct _CONF_MEMBER CONF_MEMBER;
typedef CONF_MEMBER* MEMBER_HANDLER;

typedef struct _CONF_VADAPTER CONF_VADAPTER;
typedef CONF_VADAPTER* VADAPTER_HANDLER;

typedef struct _CONF_TEAM CONF_TEAM;
typedef CONF_TEAM* TEAM_HANDLER;

#define FILENAME_DEFAULT "/etc/ians/ians.conf"

/*****************
 *    ERRORS     * 
 *****************/
	
typedef enum _iansStatus {

	// ----- General -----
	IANS_OK,
	IANS_STAM,
	IANS_ILEGAL_OPERATION,
	IANS_NOT_SUPPORTED_YET,
	IANS_MEM_ERROR,
	IANS_MUX_NOT_FOUND,
	IANS_MEMBER_NOT_FOUND,
	IANS_ADAPTER_NOT_FOUND,
   IANS_ADAPTER_NOT_SUPPORTED,
	IANS_VADAPTER_NOT_FOUND,
	IANS_MEMBER_NAME_WRONG,

	// ---- Mux -----
	IANS_TOO_MANY_MUXS,
	IANS_MUX_NOT_EMPTY,
	IANS_MUX_EXIST,

	// ---- Teaming ----
	IANS_AFTER_COMMIT,
	IANS_TOO_MANY_MEMBERS_PER_TEAM,
	IANS_TEAMING_MODE_NOT_SUPPORTED,


	// ---- Commit -----

	IANS_MUX_WITHOUT_MEMBERS,
	IANS_MUX_WITHOUT_VADAPTERS,
	IANS_NO_SERVER_ADAPTER,
	IANS_TOO_MANY_VADAPTERS,
	IANS_TOO_MANY_MEMBERS,
	IANS_MEMBER_HANDSHAKE_FAIL,
	IANS_VADAPTER_REGISTER_FAIL,
	IANS_VLAN_ID_UNDEFINED,
	IANS_MEMBER_OPEN_FAILED,
	IANS_INCOMPATIBLE_TAGGING_MODE,
	IANS_ALREADY_COMMITED,
	IANS_SPEED_ERROR,
	IANS_ALB_SPEED_ERROR,
	IANS_FEC_SPEED_ERROR,
	IANS_GEC_SPEED_ERROR,

	// ---- Member ----
	IANS_DEVICE_IS_BUSY,
	IANS_UNSET_BASE_FAILED,
	IANS_MEMBER_CLOSE_FAILED,
	IANS_MUX_ALREADY_HAS_PRIMARY,
	IANS_REMOVE_LAST_MEMBER,
	IANS_MEMBER_EXIST,

	// ---- vadapter ----
	IANS_VADAPTER_EXIST,

	// ---- Tagging ---
	IANS_ILEGAL_TAGGING_MODE,
	
	// ---- Vlan Id ----
	IANS_VLAN_ID_OUT_OF_RANGE,
	IANS_VLAN_ID_NOT_UNIQUE,
	IANS_MAX_VADAPTERS_EXCEEDED,

	// ---- OS errors ----
	IANS_MODULE_NOT_LOADED,
   IANS_BASE_NOT_LOADED,
	IANS_OS_ERROR,

	// --- File errors ---
	IANS_OPEN_FILE_ERROR,
	IANS_FILE_WRITING_ERROR,
	IANS_CLOSE_FILE_ERROR,
   IANS_PARSE_ERROR,
   IANS_TOPOLOGY_NOT_EMPTY,

	// --- PCI errors ---
    IANS_PCI_ERROR,

	// ---- max error ----
	IANS_MAX_ERROR

	
} iansStatus_t;



	/*----------------------------------------------------------------*
	 | Teaming related basic types
	 *----------------------------------------------------------------*/

	typedef enum _IANS_TEAM_MODE {
		IANS_TEAM_NONE,
		IANS_TEAM_AFT,
		IANS_TEAM_ALB,
		IANS_TEAM_FEC,
		IANS_TEAM_GEC,
		IANS_TEAM_802_3AD,
		IANS_TEAM_NUM_OF_MODES
	}IANS_TEAM_MODE;

	/*----------------------------------------------------------------*
	 | (Lower) member attributes
	 *----------------------------------------------------------------*/

	typedef enum _IANS_MEMBER_ATTR
	{
		IANS_MEMBER_PRIMARY,
		IANS_MEMBER_SECONDARY,
		IANS_MEMBER_NO_PRIORITY
	} IANS_MEMBER_ATTR;

	typedef enum _IANS_PROBE_ADDR_MODES
	{
		IANS_PROBE_MULTICAST,
		IANS_PROBE_BROADCAST
	} IANS_PROBE_ADDR_MODES;



#define NAME_LEN                 32 
#define NUM_OF_FRAME_TYPES			4
#define		NUM_OF_CARDS			64

typedef enum 
{
	// Type of cards:
	NIC_ID_UNKNOWN		=0,
	NIC_ID_KODIAK		=1,
	NIC_ID_KODIAK2		=2,
	NIC_ID_NITRO		=3,
	NIC_ID_CATALINA		=4,
	NIC_ID_D100			=5,
	NIC_ID_D101S		=6,
	// should remain last
	NUM_OF_CARD_TYPES	=7
} CONF_CARD_TYPE;


#ifdef IANS_TAGGING
	/*----------------------------------------------------------------*
	 | Tagging related basic types
	 *----------------------------------------------------------------*/

	typedef enum _IANS_TAG_MODE {
		IANS_TAG_NONE,
		IANS_TAG_802_3AC,
		IANS_TAG_ISL		
	} IANS_TAG_MODE;
#endif /* IANS_TAGGING */ 

#ifdef IANS_BINDING_BASED_VLAN
	/*----------------------------------------------------------------*
	 | Vlan related basic types
	 *----------------------------------------------------------------*/

	typedef enum _IANS_VLAN_MODE {		
		IANS_VLAN_OFF,
		IANS_VLAN_IEEE,
		IANS_VLAN_ISL,
		IANS_VLAN_NUM_OF_MODES
	} IANS_VLAN_MODE;
#endif /* IANS_BINDING_BASED_VLAN */

	/*----------------------------------------------------------------*
	 | NOVELL - protocols
	 *----------------------------------------------------------------*/
typedef enum _SUPPORTED_PROTOCOLS
{
	PROT_NONE,
	PROT_IP,
	PROT_IPX
} SUPPORTED_PROTOCOLS;

typedef struct _PROTOCOL_PARAMETERS
{
	SUPPORTED_PROTOCOLS		ProtocolType;
	union
	{
		struct 
		{
			unsigned long	Addr[4];
			unsigned long	Mask[4];
		} IPparam;

		struct 
		{
			unsigned long	Net;
		} IPXparam;

	} Pr;

} PROTOCOL_PARAMETERS;

#endif








