--- linux-2.2.14-pristine/drivers/block/Config.in	Tue Mar  7 20:24:43 2000
+++ linux/drivers/block/Config.in	Thu Jul  6 00:01:00 2000
@@ -44,6 +44,7 @@
             bool '     NS87415 chipset support (EXPERIMENTAL)' CONFIG_BLK_DEV_NS87415
             bool '     VIA82C586 chipset support (EXPERIMENTAL)' CONFIG_BLK_DEV_VIA82C586
             bool '     CMD646 chipset support (EXPERIMENTAL)' CONFIG_BLK_DEV_CMD646
+            bool '     PROMISE PDC202xx chipset support' CONFIG_BLK_DEV_PDC202XX
           fi
         fi
       fi
--- linux-2.2.14-pristine/drivers/block/Makefile	Tue Mar  7 20:24:43 2000
+++ linux/drivers/block/Makefile	Thu Jul  6 00:01:00 2000
@@ -158,6 +158,10 @@
 IDE_OBJS += via82c586.o
 endif
 
+ifeq ($(CONFIG_BLK_DEV_PDC202XX),y)
+IDE_OBJS += pdc202xx.o
+endif
+
 ifeq ($(CONFIG_BLK_DEV_CMD646),y)
 IDE_OBJS += cmd646.o
 endif
--- linux-2.2.14-pristine/drivers/block/ide-pci.c	Mon Jan 25 00:54:35 1999
+++ linux/drivers/block/ide-pci.c	Thu Jul  6 00:01:00 2000
@@ -30,6 +30,9 @@
 #define DEVID_PIIX4	((ide_pci_devid_t){PCI_VENDOR_ID_INTEL,   PCI_DEVICE_ID_INTEL_82371AB})
 #define DEVID_VP_IDE	((ide_pci_devid_t){PCI_VENDOR_ID_VIA,     PCI_DEVICE_ID_VIA_82C586_1})
 #define DEVID_PDC20246	((ide_pci_devid_t){PCI_VENDOR_ID_PROMISE, PCI_DEVICE_ID_PROMISE_20246})
+#define DEVID_PDC20262	((ide_pci_devid_t){PCI_VENDOR_ID_PROMISE, PCI_DEVICE_ID_PROMISE_20262})
+#define DEVID_PDC20265	((ide_pci_devid_t){PCI_VENDOR_ID_PROMISE, PCI_DEVICE_ID_PROMISE_20265})
+#define DEVID_PDC20267	((ide_pci_devid_t){PCI_VENDOR_ID_PROMISE, PCI_DEVICE_ID_PROMISE_20267})
 #define DEVID_RZ1000	((ide_pci_devid_t){PCI_VENDOR_ID_PCTECH,  PCI_DEVICE_ID_PCTECH_RZ1000})
 #define DEVID_RZ1001	((ide_pci_devid_t){PCI_VENDOR_ID_PCTECH,  PCI_DEVICE_ID_PCTECH_RZ1001})
 #define DEVID_CMD640	((ide_pci_devid_t){PCI_VENDOR_ID_CMD,     PCI_DEVICE_ID_CMD_640})
@@ -50,6 +53,16 @@
 
 #define IDE_IGNORE	((void *)-1)
 
+#ifdef CONFIG_BLK_DEV_PDC202XX
+extern unsigned int pci_init_pdc202xx(struct pci_dev *, const char *);
+extern void ide_init_pdc202xx(ide_hwif_t *);
+#define PCI_PDC202XX	&pci_init_pdc202xx
+#define	INIT_PDC202XX	&ide_init_pdc202xx
+#else
+#define PCI_PDC202XX	NULL
+#define	INIT_PDC202XX	NULL
+#endif
+
 #ifdef CONFIG_BLK_DEV_TRM290
 extern void ide_init_trm290(ide_hwif_t *);
 #define INIT_TRM290	&ide_init_trm290
@@ -112,37 +125,34 @@
 typedef struct ide_pci_device_s {
 	ide_pci_devid_t		devid;
 	const char		*name;
+	unsigned int		(*init_chipset)(struct pci_dev *dev, const char *name);
 	void 			(*init_hwif)(ide_hwif_t *hwif);
+	void			(*dma_init)(ide_hwif_t *hwif, unsigned long dmabase);
 	ide_pci_enablebit_t	enablebits[2];
 	byte			bootable;
 	unsigned int		extra;
 } ide_pci_device_t;
 
 static ide_pci_device_t ide_pci_chipsets[] __initdata = {
-	{DEVID_PIIXa,	"PIIX",		NULL,		{{0x41,0x80,0x80}, {0x43,0x80,0x80}}, 	ON_BOARD,	0 },
-	{DEVID_PIIXb,	"PIIX",		NULL,		{{0x41,0x80,0x80}, {0x43,0x80,0x80}}, 	ON_BOARD,	0 },
-	{DEVID_PIIX3,	"PIIX3",	NULL,		{{0x41,0x80,0x80}, {0x43,0x80,0x80}}, 	ON_BOARD,	0 },
-	{DEVID_PIIX4,	"PIIX4",	NULL,		{{0x41,0x80,0x80}, {0x43,0x80,0x80}}, 	ON_BOARD,	0 },
-	{DEVID_VP_IDE,	"VP_IDE",	INIT_VIA82C586,	{{0x40,0x02,0x02}, {0x40,0x01,0x01}}, 	ON_BOARD,	0 },
-	{DEVID_PDC20246,"PDC20246",	NULL,		{{0x50,0x02,0x02}, {0x50,0x04,0x04}}, 	OFF_BOARD,	16 },
-	{DEVID_RZ1000,	"RZ1000",	INIT_RZ1000,	{{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0 },
-	{DEVID_RZ1001,	"RZ1001",	INIT_RZ1000,	{{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0 },
-	{DEVID_CMD640,	"CMD640",	IDE_IGNORE,	{{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0 },
-	{DEVID_NS87410,	"NS87410",	NULL,		{{0x43,0x08,0x08}, {0x47,0x08,0x08}}, 	ON_BOARD,	0 },
-	{DEVID_SIS5513,	"SIS5513",	NULL,		{{0x4a,0x02,0x02}, {0x4a,0x04,0x04}}, 	ON_BOARD,	0 },
-	{DEVID_CMD646,	"CMD646",	INIT_CMD646,	{{0x00,0x00,0x00}, {0x51,0x80,0x80}}, 	ON_BOARD,	0 },
-	{DEVID_HT6565,	"HT6565",	NULL,		{{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0 },
-	{DEVID_OPTI621,	"OPTI621",	INIT_OPTI621,	{{0x45,0x80,0x00}, {0x40,0x08,0x00}}, 	ON_BOARD,	0 },
-	{DEVID_OPTI621X,"OPTI621X",	INIT_OPTI621,	{{0x45,0x80,0x00}, {0x40,0x08,0x00}}, 	ON_BOARD,	0 },
-	{DEVID_TRM290,	"TRM290",	INIT_TRM290,	{{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0 },
-	{DEVID_NS87415,	"NS87415",	INIT_NS87415,	{{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0 },
-	{DEVID_AEC6210,	"AEC6210",	NULL,		{{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	OFF_BOARD,	0 },
-	{DEVID_W82C105,	"W82C105",	INIT_W82C105,	{{0x40,0x01,0x01}, {0x40,0x10,0x10}}, 	ON_BOARD,	0 },
-	{DEVID_UM8886A,	"UM8886A",	NULL,		{{0x00,0x00,0x00}, {0x00,0x00,0x00}},	ON_BOARD,	0 },
-	{DEVID_UM8886BF,"UM8886BF",	NULL,		{{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0 },
-	{DEVID_HPT343,	"HPT343",	NULL,		{{0x00,0x00,0x00}, {0x00,0x00,0x00}},	NEVER_BOARD,	16 },
-	{IDE_PCI_DEVID_NULL, "PCI_IDE",	NULL,		{{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0 }};
-
+	{DEVID_PDC20246,"PDC20246",	PCI_PDC202XX,	INIT_PDC202XX, NULL,		{{0x50,0x02,0x02}, {0x50,0x04,0x04}}, 	ON_BOARD,	16},
+	{DEVID_PDC20262,"PDC20262",	PCI_PDC202XX,	INIT_PDC202XX, NULL,		{{0x50,0x02,0x02}, {0x50,0x04,0x04}},	ON_BOARD,	48 },
+	{DEVID_PDC20265,"PDC20265",	PCI_PDC202XX,	INIT_PDC202XX, NULL,		{{0x50,0x02,0x02}, {0x50,0x04,0x04}},	ON_BOARD,	48 },
+	{DEVID_PDC20267,"PDC20267",	PCI_PDC202XX,	INIT_PDC202XX, NULL,		{{0x50,0x02,0x02}, {0x50,0x04,0x04}},	ON_BOARD,	48 },
+	{DEVID_RZ1000,	"RZ1000",	NULL,		INIT_RZ1000,NULL,		{{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0},
+	{DEVID_RZ1001,	"RZ1001",	NULL,		INIT_RZ1000, NULL, {{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0},
+	{DEVID_CMD640,	"CMD640",	NULL,		IDE_IGNORE, NULL, {{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0},
+	{DEVID_NS87410,	"NS87410",	NULL,		NULL, NULL, {{0x43,0x08,0x08}, {0x47,0x08,0x08}}, 	ON_BOARD,	0},
+	{DEVID_SIS5513,	"SIS5513",	NULL,		NULL, NULL, {{0x4a,0x02,0x02}, {0x4a,0x04,0x04}}, 	ON_BOARD,	0},
+	{DEVID_CMD646,	"CMD646",	NULL,		INIT_CMD646, NULL, {{0x00,0x00,0x00}, {0x51,0x80,0x80}}, 	ON_BOARD,	0},
+	{DEVID_HT6565,	"HT6565",	NULL,		NULL, NULL, {{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0},
+	{DEVID_OPTI621,	"OPTI621",	NULL,		INIT_OPTI621, NULL,		{{0x45,0x80,0x00}, {0x40,0x08,0x00}}, 	ON_BOARD,	0},
+	{DEVID_OPTI621X,"OPTI621X",	NULL,		INIT_OPTI621, NULL,		{{0x45,0x80,0x00}, {0x40,0x08,0x00}}, 	ON_BOARD,	0},
+	{DEVID_TRM290,	"TRM290",	NULL,		INIT_TRM290, NULL, {{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0},
+	{DEVID_NS87415,	"NS87415",	NULL,		INIT_NS87415, NULL,		{{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0},
+	{DEVID_W82C105,	"W82C105",	NULL,		INIT_W82C105, NULL,		{{0x40,0x01,0x01}, {0x40,0x10,0x10}}, 	ON_BOARD,	0},
+	{DEVID_UM8886A,	"UM8886A",	NULL,		NULL, NULL, {{0x00,0x00,0x00}, {0x00,0x00,0x00}},	ON_BOARD,	0},
+	{DEVID_UM8886BF,"UM8886BF",	NULL,		NULL, NULL, {{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0},
+	{IDE_PCI_DEVID_NULL, "PCI_IDE",	NULL,		NULL,NULL,		{{0x00,0x00,0x00}, {0x00,0x00,0x00}}, 	ON_BOARD,	0}}; 
 /*
  * This allows offboard ide-pci cards the enable a BIOS, verify interrupt
  * settings of split-mirror pci-config space, place chipset into init-mode,
@@ -151,27 +161,29 @@
 __initfunc(static unsigned int ide_special_settings (struct pci_dev *dev, const char *name))
 {
 	switch(dev->device) {
-		case PCI_DEVICE_ID_ARTOP_ATP850UF:
-		case PCI_DEVICE_ID_PROMISE_20246:
-			if (dev->rom_address) {
-				pci_write_config_byte(dev, PCI_ROM_ADDRESS,
-					dev->rom_address | PCI_ROM_ADDRESS_ENABLE);
-				printk(KERN_INFO "%s: ROM enabled at 0x%08lx\n", name, dev->rom_address);
-			}
-			
-			if ((dev->class >> 8) == PCI_CLASS_STORAGE_RAID) {
-				unsigned char irq1 = 0, irq2 = 0;
-
-				pci_read_config_byte(dev, PCI_INTERRUPT_LINE, &irq1);
-				pci_read_config_byte(dev, (PCI_INTERRUPT_LINE)|0x80, &irq2);	/* 0xbc */
-				if (irq1 != irq2) {
-					printk("%s: IRQ1 %d IRQ2 %d\n",
-						name, irq1, irq2);
-					pci_write_config_byte(dev, (PCI_INTERRUPT_LINE)|0x80, irq1);	/* 0xbc */
-				}
-			}
-			return dev->irq;
 		case PCI_DEVICE_ID_TTI_HPT343:
+			{
+				int i;
+				unsigned short pcicmd = 0;
+				unsigned long hpt343IoBase = dev->base_address[4] & PCI_BASE_ADDRESS_IO_MASK;
+
+				pci_write_config_byte(dev, 0x80, 0x00);
+				dev->base_address[0] = (hpt343IoBase + 0x20);
+				dev->base_address[1] = (hpt343IoBase + 0x34);
+				dev->base_address[2] = (hpt343IoBase + 0x28);
+				dev->base_address[3] = (hpt343IoBase + 0x3c);
+				for(i=0; i<4; i++)
+					dev->base_address[i] |= PCI_BASE_ADDRESS_SPACE_IO;
+
+				pci_read_config_word(dev, PCI_COMMAND, &pcicmd);
+				if (!(pcicmd & PCI_COMMAND_MEMORY))
+					pci_write_config_byte(dev, PCI_LATENCY_TIMER, 0x20);
+			}
+		case PCI_DEVICE_ID_PROMISE_20246:
+		case PCI_DEVICE_ID_PROMISE_20262:
+		case PCI_DEVICE_ID_PROMISE_20265:
+		case PCI_DEVICE_ID_PROMISE_20267:
+		case PCI_DEVICE_ID_ARTOP_ATP850UF:
 			return dev->irq;
 		default:
 			break;
@@ -325,7 +337,13 @@
 	pciirq = dev->irq;
 	if ((dev->class & ~(0xfa)) != ((PCI_CLASS_STORAGE_IDE << 8) | 5)) {
 		printk("%s: not 100%% native mode: will probe irqs later\n", d->name);
-		pciirq = ide_special_settings(dev, d->name);
+		/*
+		 * This allows offboard ide-pci cards the enable a BIOS,
+		 * verify interrupt settings of split-mirror pci-config
+		 * space, place chipset into init-mode, and/or preserve
+		 * an interrupt if the card is not native ide support.
+		 */
+		pciirq = (d->init_chipset) ? d->init_chipset(dev, d->name) : ide_special_settings(dev, d->name);
 	} else if (tried_config) {
 		printk("%s: will probe irqs later\n", d->name);
 		pciirq = 0;
@@ -391,6 +409,9 @@
 		if (autodma)
 			hwif->autodma = 1;
 		if (IDE_PCI_DEVID_EQ(d->devid, DEVID_PDC20246) ||
+		    IDE_PCI_DEVID_EQ(d->devid, DEVID_PDC20262) ||
+		    IDE_PCI_DEVID_EQ(d->devid, DEVID_PDC20265) ||
+		    IDE_PCI_DEVID_EQ(d->devid, DEVID_PDC20267) ||
 		    IDE_PCI_DEVID_EQ(d->devid, DEVID_AEC6210) ||
 		    IDE_PCI_DEVID_EQ(d->devid, DEVID_HPT343) ||
 		    ((dev->class >> 8) == PCI_CLASS_STORAGE_IDE && (dev->class & 0x80))) {
@@ -406,12 +427,18 @@
 					dma_base = 0;
 				}
 			}
-			if (dma_base)
-				ide_setup_dma(hwif, dma_base, 8);
-			else
+			if (dma_base) {
+				if (d->dma_init) {
+					d->dma_init(hwif, dma_base);
+				} else {
+					ide_setup_dma(hwif, dma_base, 8);
+				}
+			} else {
 				printk("%s: %s Bus-Master DMA disabled (BIOS)\n", hwif->name, d->name);
+                       }
 		}
 #endif	/* CONFIG_BLK_DEV_IDEDMA */
+bypass_umc_dma:
 		if (d->init_hwif)  /* Call chipset-specific routine for each enabled hwif */
 			d->init_hwif(hwif);
 		mate = hwif;
@@ -433,9 +460,37 @@
 
 	if (!pci_present())
 		return;
+#ifdef CONFIG_BLK_DEV_PDC202XX
+	for(dev = pci_devices; dev; dev=dev->next) {
+	   static char	Pcards = 0;
+	   devid.vid = dev->vendor;
+	   devid.did = dev->device;
+	   if( devid.vid == PCI_VENDOR_ID_PROMISE ) {
+		d = ide_pci_chipsets; 
+		do {
+		   if (IDE_PCI_DEVID_EQ(d->devid, devid)) {
+			ide_hwif_t *hwif0 ;
+			ide_hwif_t *hwif1 ;
+			printk("%s: IDE controller on PCI bus %02x dev %02x\n", d->name, dev->bus->number, dev->devfn);
+			ide_setup_pci_device(dev, d);
+			Pcards++;
+			hwif0 = &ide_hwifs[Pcards*2];
+			hwif1 = &ide_hwifs[Pcards*2+1];
+			ide_init_hwif_ports(hwif0->io_ports,0x1F0,&hwif0->irq);
+			ide_init_hwif_ports(hwif1->io_ports,0x170,&hwif1->irq);
+			break;
+		   }
+		} while ( d++ ); 
+	   }
+	}
+#endif
 	for(dev = pci_devices; dev; dev=dev->next) {
 		devid.vid = dev->vendor;
 		devid.did = dev->device;
+#ifdef CONFIG_BLK_DEV_PDC202XX
+		if( devid.vid == PCI_VENDOR_ID_PROMISE )
+			continue; 
+#endif
 		for (d = ide_pci_chipsets; d->devid.vid && !IDE_PCI_DEVID_EQ(d->devid, devid); ++d);
 		if (d->init_hwif == IDE_IGNORE)
 			printk("%s: ignored by ide_scan_pci_device() (uses own driver)\n", d->name);
--- linux-2.2.14-pristine/drivers/block/ide.h	Fri May 19 15:56:18 2000
+++ linux/drivers/block/ide.h	Thu Jul  6 00:01:00 2000
@@ -262,20 +262,22 @@
 	} ide_drive_t;
 
 /*
- * An ide_dmaproc_t() initiates/aborts DMA read/write operations on a drive.
+ * An ide_dmaproc_t() initiates/aborts DMA read/write operations on adrive.
  *
  * The caller is assumed to have selected the drive and programmed the drive's
- * sector address using CHS or LBA.  All that remains is to prepare for DMA
+ * sector address using CHS or LBA.  All that remains is to prepare forDMA
  * and then issue the actual read/write DMA/PIO command to the drive.
  *
  * Returns 0 if all went well.
  * Returns 1 if DMA read/write could not be started, in which case the caller
  * should either try again later, or revert to PIO for the current request.
  */
-typedef enum {	ide_dma_read,	ide_dma_write,	ide_dma_begin,	ide_dma_end,
-		ide_dma_check,	ide_dma_on,	ide_dma_off,	ide_dma_off_quietly,
-		ide_dma_test_irq
+typedef enum {	ide_dma_read,	ide_dma_write,		ide_dma_begin,
+		ide_dma_end,	ide_dma_check,		ide_dma_on,
+		ide_dma_off,	ide_dma_off_quietly,	ide_dma_test_irq,
+		ide_dma_bad_drive,			ide_dma_good_drive
 	} ide_dma_action_t;
+
 
 typedef int (ide_dmaproc_t)(ide_dma_action_t, ide_drive_t *);
 
--- linux-2.2.14-pristine/drivers/block/pdc202xx.c	Thu Jul  6 00:01:00 2000
+++ linux/drivers/block/pdc202xx.c	Thu Jul  6 00:01:00 2000
@@ -0,0 +1,573 @@
+/*
+ *  linux/drivers/block/pdc202xx.c	Version 0.26	May 12, 1999
+ *                                     Version 1.00    July 7, 2000
+ *  Copyright (C) 1998-99	Andre Hedrick
+ *					(hedrick@astro.dyer.vanderbilt.edu)
+ *
+ *  Promise Ultra33 cards with BIOS v1.20 through 1.28 will need this
+ *  compiled into the kernel if you have more than one card installed.
+ *  Note that BIOS v1.29 is reported to fix the problem.  Since this is
+ *  safe chipset tuning, including this support is harmless
+ *
+ *  The latest chipset code will support the following ::
+ *  Three Ultra33 controllers and 12 drives.
+ *  8 are UDMA supported and 4 are limited to DMA mode 2 multi-word.
+ *  The 8/4 ratio is a BIOS code limit by promise.
+ *
+ *  UNLESS you enable "PDC202XX_FORCE_BURST_BIT"
+ *
+ *  There is only one BIOS in the three contollers.
+ *
+ *  May  8 20:56:17 Orion kernel:
+ *  Uniform Multi-Platform E-IDE driver Revision: 6.19
+ *  PDC20246: IDE controller on PCI bus 00 dev a0
+ *  PDC20246: not 100% native mode: will probe irqs later
+ *  PDC20246: ROM enabled at 0xfebd0000
+ *  PDC20246: (U)DMA Burst Bit ENABLED Primary PCI Mode Secondary PCI Mode.
+ *      ide0: BM-DMA at 0xef80-0xef87, BIOS settings: hda:DMA, hdb:DMA
+ *      ide1: BM-DMA at 0xef88-0xef8f, BIOS settings: hdc:pio, hdd:pio
+ *  PDC20246: IDE controller on PCI bus 00 dev 98
+ *  PDC20246: not 100% native mode: will probe irqs later
+ *  PDC20246: ROM enabled at 0xfebc0000
+ *  PDC20246: (U)DMA Burst Bit ENABLED Primary PCI Mode Secondary PCI Mode.
+ *      ide2: BM-DMA at 0xef40-0xef47, BIOS settings: hde:DMA, hdf:DMA
+ *      ide3: BM-DMA at 0xef48-0xef4f, BIOS settings: hdg:DMA, hdh:DMA
+ *  PDC20246: IDE controller on PCI bus 00 dev 90
+ *  PDC20246: not 100% native mode: will probe irqs later
+ *  PDC20246: ROM enabled at 0xfebb0000
+ *  PDC20246: (U)DMA Burst Bit DISABLED Primary PCI Mode Secondary PCI Mode.
+ *  PDC20246: FORCING BURST BIT 0x00 -> 0x01 ACTIVE
+ *      ide4: BM-DMA at 0xef00-0xef07, BIOS settings: hdi:DMA, hdj:pio
+ *      ide5: BM-DMA at 0xef08-0xef0f, BIOS settings: hdk:pio, hdl:pio
+ *  PIIX3: IDE controller on PCI bus 00 dev 39
+ *  PIIX3: device not capable of full native PCI mode
+ *
+ *  ide0 at 0xeff0-0xeff7,0xefe6 on irq 19
+ *  ide1 at 0xefa8-0xefaf,0xebe6 on irq 19
+ *  ide2 at 0xefa0-0xefa7,0xef7e on irq 18
+ *  ide3 at 0xef68-0xef6f,0xef66 on irq 18
+ *  ide4 at 0xef38-0xef3f,0xef62 on irq 17
+ *  hda: QUANTUM FIREBALL ST6.4A, 6149MB w/81kB Cache, CHS=13328/15/63, UDMA(33)
+ *  hdb: QUANTUM FIREBALL ST3.2A, 3079MB w/81kB Cache, CHS=6256/16/63, UDMA(33)
+ *  hde: Maxtor 72004 AP, 1916MB w/128kB Cache, CHS=3893/16/63, DMA
+ *  hdf: Maxtor 71626 A, 1554MB w/64kB Cache, CHS=3158/16/63, DMA
+ *  hdi: Maxtor 90680D4, 6485MB w/256kB Cache, CHS=13176/16/63, UDMA(33)
+ *  hdj: Maxtor 90680D4, 6485MB w/256kB Cache, CHS=13176/16/63, UDMA(33)
+ *
+ *  Promise Ultra66 cards with BIOS v1.11 this
+ *  compiled into the kernel if you have more than one card installed.
+ *
+ *  PDC20262: IDE controller on PCI bus 00 dev a0
+ *  PDC20262: not 100% native mode: will probe irqs later
+ *  PDC20262: ROM enabled at 0xfebb0000
+ *  PDC20262: (U)DMA Burst Bit ENABLED Primary PCI Mode Secondary PCI Mode.
+ *      ide0: BM-DMA at 0xef00-0xef07, BIOS settings: hda:pio, hdb:pio
+ *      ide1: BM-DMA at 0xef08-0xef0f, BIOS settings: hdc:pio, hdd:pio
+ *
+ *  UDMA 4/2 and UDMA 3/1 only differ by the testing bit 13 in word93.
+ *  Chipset timing speeds must be identical
+ *
+ *  drive_number
+ *      = ((HWIF(drive)->channel ? 2 : 0) + (drive->select.b.unit & 0x01));
+ *      = ((hwif->channel ? 2 : 0) + (drive->select.b.unit & 0x01));
+ *  
+ *  Upgrade: Promise Ultra100 (05.JUL.2000)
+ *	Support IDE controllers PDC20265 and PDC20267  
+ *	One Promise UltraXX card :
+ *  	    hwif sequence : UltraXX(IDE0,IDE1) M/B(IDE2,IDE3)
+ *	Two Promise UltraXX cards :
+ *  	    hwif sequence : UltraXX(IDE0,IDE1) UltraXX(IDE2,IDE3) M/B(IDE4,IDE5)
+ */
+
+#include <linux/config.h>	/* for CONFIG_BLK_DEV_IDEPCI */
+#include <linux/types.h>
+#include <linux/kernel.h>
+#include <linux/delay.h>
+#include <linux/timer.h>
+#include <linux/mm.h>
+#include <linux/ioport.h>
+#include <linux/blkdev.h>
+#include <linux/hdreg.h>
+#include <linux/interrupt.h>
+#include <linux/pci.h>
+#include <linux/init.h>
+
+#include <asm/io.h>
+#include <asm/irq.h>
+
+#include "ide.h"
+
+#define PDC202XX_DEBUG_DRIVE_INFO		0
+#define PDC202XX_DECODE_REGISTER_INFO		0
+#define PDC202XX_FORCE_BURST_BIT		0
+#define PDC202XX_FORCE_MASTER_MODE		0
+
+extern char *ide_xfer_verbose (byte xfer_rate);
+
+/* A Register */
+#define	SYNC_ERRDY_EN	0xC0
+
+#define	SYNC_IN		0x80	/* control bit, different for master vs. slave drives */
+#define	ERRDY_EN	0x40	/* control bit, different for master vs. slave drives */
+#define	IORDY_EN	0x20	/* PIO: IOREADY */
+#define	PREFETCH_EN	0x10	/* PIO: PREFETCH */
+
+#define	PA3		0x08	/* PIO"A" timing */
+#define	PA2		0x04	/* PIO"A" timing */
+#define	PA1		0x02	/* PIO"A" timing */
+#define	PA0		0x01	/* PIO"A" timing */
+
+/* B Register */
+
+#define	MB2		0x80	/* DMA"B" timing */
+#define	MB1		0x40	/* DMA"B" timing */
+#define	MB0		0x20	/* DMA"B" timing */
+
+#define	PB4		0x10	/* PIO_FORCE 1:0 */
+
+#define	PB3		0x08	/* PIO"B" timing */	/* PIO flow Control mode */
+#define	PB2		0x04	/* PIO"B" timing */	/* PIO 4 */
+#define	PB1		0x02	/* PIO"B" timing */	/* PIO 3 half */
+#define	PB0		0x01	/* PIO"B" timing */	/* PIO 3 other half */
+
+/* C Register */
+#define	IORDYp_NO_SPEED	0x4F
+#define	SPEED_DIS	0x0F
+
+#define	DMARQp		0x80
+#define	IORDYp		0x40
+#define	DMAR_EN		0x20
+#define	DMAW_EN		0x10
+
+#define	MC3		0x08	/* DMA"C" timing */
+#define	MC2		0x04	/* DMA"C" timing */
+#define	MC1		0x02	/* DMA"C" timing */
+#define	MC0		0x01	/* DMA"C" timing */
+
+#if PDC202XX_DECODE_REGISTER_INFO
+
+#define REG_A		0x01
+#define REG_B		0x02
+#define REG_C		0x04
+#define REG_D		0x08
+
+static void decode_registers (byte registers, byte value)
+{
+	byte	bit = 0, bit1 = 0, bit2 = 0;
+
+	switch(registers) {
+		case REG_A:
+			bit2 = 0;
+			printk("A Register ");
+			if (value & 0x80) printk("SYNC_IN ");
+			if (value & 0x40) printk("ERRDY_EN ");
+			if (value & 0x20) printk("IORDY_EN ");
+			if (value & 0x10) printk("PREFETCH_EN ");
+			if (value & 0x08) { printk("PA3 ");bit2 |= 0x08; }
+			if (value & 0x04) { printk("PA2 ");bit2 |= 0x04; }
+			if (value & 0x02) { printk("PA1 ");bit2 |= 0x02; }
+			if (value & 0x01) { printk("PA0 ");bit2 |= 0x01; }
+			printk("PIO(A) = %d ", bit2);
+			break;
+		case REG_B:
+			bit1 = 0;bit2 = 0;
+			printk("B Register ");
+			if (value & 0x80) { printk("MB2 ");bit1 |= 0x80; }
+			if (value & 0x40) { printk("MB1 ");bit1 |= 0x40; }
+			if (value & 0x20) { printk("MB0 ");bit1 |= 0x20; }
+			printk("DMA(B) = %d ", bit1 >> 5);
+			if (value & 0x10) printk("PIO_FORCED/PB4 ");
+			if (value & 0x08) { printk("PB3 ");bit2 |= 0x08; }
+			if (value & 0x04) { printk("PB2 ");bit2 |= 0x04; }
+			if (value & 0x02) { printk("PB1 ");bit2 |= 0x02; }
+			if (value & 0x01) { printk("PB0 ");bit2 |= 0x01; }
+			printk("PIO(B) = %d ", bit2);
+			break;
+		case REG_C:
+			bit2 = 0;
+			printk("C Register ");
+			if (value & 0x80) printk("DMARQp ");
+			if (value & 0x40) printk("IORDYp ");
+			if (value & 0x20) printk("DMAR_EN ");
+			if (value & 0x10) printk("DMAW_EN ");
+
+			if (value & 0x08) { printk("MC3 ");bit2 |= 0x08; }
+			if (value & 0x04) { printk("MC2 ");bit2 |= 0x04; }
+			if (value & 0x02) { printk("MC1 ");bit2 |= 0x02; }
+			if (value & 0x01) { printk("MC0 ");bit2 |= 0x01; }
+			printk("DMA(C) = %d ", bit2);
+			break;
+		case REG_D:
+			printk("D Register ");
+			break;
+		default:
+			return;
+	}
+	printk("\n        %s ", (registers & REG_D) ? "DP" :
+				(registers & REG_C) ? "CP" :
+				(registers & REG_B) ? "BP" :
+				(registers & REG_A) ? "AP" : "ERROR");
+	for (bit=128;bit>0;bit/=2)
+		printk("%s", (value & bit) ? "1" : "0");
+	printk("\n");
+}
+
+#endif /* PDC202XX_DECODE_REGISTER_INFO */
+
+static int config_chipset_for_dma (ide_drive_t *drive, byte ultra)
+{
+	struct hd_driveid *id	= drive->id;
+	ide_hwif_t *hwif	= HWIF(drive);
+	struct pci_dev *dev	= hwif->pci_dev;
+
+	int			err;
+	unsigned int		drive_conf;
+	byte			drive_pci;
+	byte			test1, test2, speed;
+	byte			AP, BP, CP, DP, EP;
+	int drive_number	= ((hwif->channel ? 2 : 0) + (drive->select.b.unit & 0x01));
+	byte udma_100	= ((id->word93 & 0x2000) && ((dev->device == PCI_DEVICE_ID_PROMISE_20265) || (dev->device == PCI_DEVICE_ID_PROMISE_20267))) ? 1 : 0;
+	byte udma_66	= (udma_100 || ((id->word93 & 0x2000) && (dev->device == PCI_DEVICE_ID_PROMISE_20262))) ? 1 : 0;
+	byte udma_33	= ultra ? (inb((dev->base_address[4] & PCI_BASE_ADDRESS_IO_MASK) + 0x001f) & 1) : 0;
+
+	pci_read_config_byte(dev, 0x50, &EP);
+
+	switch(drive_number) {
+		case 0:	drive_pci = 0x60;
+			pci_read_config_dword(dev, drive_pci, &drive_conf);
+			if ((drive_conf != 0x004ff304) && (drive_conf != 0x004ff3c4))
+				goto chipset_is_set;
+			pci_read_config_byte(dev, (drive_pci), &test1);
+			if (!(test1 & SYNC_ERRDY_EN))
+				pci_write_config_byte(dev, (drive_pci), test1|SYNC_ERRDY_EN);
+			break;
+		case 1:	drive_pci = 0x64;
+			pci_read_config_dword(dev, drive_pci, &drive_conf);
+			if ((drive_conf != 0x004ff304) && (drive_conf != 0x004ff3c4))
+				goto chipset_is_set;
+			pci_read_config_byte(dev, 0x60, &test1);
+			pci_read_config_byte(dev, (drive_pci), &test2);
+			if ((test1 & SYNC_ERRDY_EN) && !(test2 & SYNC_ERRDY_EN))
+				pci_write_config_byte(dev, (drive_pci), test2|SYNC_ERRDY_EN);
+			break;
+		case 2:	drive_pci = 0x68;
+			pci_read_config_dword(dev, drive_pci, &drive_conf);
+			if ((drive_conf != 0x004ff304) && (drive_conf != 0x004ff3c4))
+				goto chipset_is_set;
+			pci_read_config_byte(dev, (drive_pci), &test1);
+			if (!(test1 & SYNC_ERRDY_EN))
+				pci_write_config_byte(dev, (drive_pci), test1|SYNC_ERRDY_EN);
+			break;
+		case 3:	drive_pci = 0x6c;
+			pci_read_config_dword(dev, drive_pci, &drive_conf);
+			if ((drive_conf != 0x004ff304) && (drive_conf != 0x004ff3c4))
+				goto chipset_is_set;
+			pci_read_config_byte(dev, 0x68, &test1);
+			pci_read_config_byte(dev, (drive_pci), &test2);
+			if ((test1 & SYNC_ERRDY_EN) && !(test2 & SYNC_ERRDY_EN))
+				pci_write_config_byte(dev, (drive_pci), test2|SYNC_ERRDY_EN);
+			break;
+		default:
+			return ide_dma_off;
+	}
+
+	if (drive->media != ide_disk)
+		return ide_dma_off_quietly;
+
+	pci_read_config_byte(dev, (drive_pci), &AP);
+	pci_read_config_byte(dev, (drive_pci)|0x01, &BP);
+	pci_read_config_byte(dev, (drive_pci)|0x02, &CP);
+	pci_read_config_byte(dev, (drive_pci)|0x03, &DP);
+
+	if (id->capability & 4) {		/* IORDY_EN */
+		pci_write_config_byte(dev, (drive_pci), AP|IORDY_EN);
+		pci_read_config_byte(dev, (drive_pci), &AP);
+	}
+
+	if (drive->media == ide_disk) {		/* PREFETCH_EN */
+		pci_write_config_byte(dev, (drive_pci), AP|PREFETCH_EN);
+		pci_read_config_byte(dev, (drive_pci), &AP);
+	}
+
+	if ((BP & 0xF0) && (CP & 0x0F)) {
+		/* clear DMA modes of upper 842 bits of B Register */
+		/* clear PIO forced mode upper 1 bit of B Register */
+		pci_write_config_byte(dev, (drive_pci)|0x01, BP & ~0xF0);
+		pci_read_config_byte(dev, (drive_pci)|0x01, &BP);
+
+		/* clear DMA modes of lower 8421 bits of C Register */
+		pci_write_config_byte(dev, (drive_pci)|0x02, CP & ~0x0F);
+		pci_read_config_byte(dev, (drive_pci)|0x02, &CP);
+	}
+
+	pci_read_config_byte(dev, (drive_pci), &AP);
+	pci_read_config_byte(dev, (drive_pci)|0x01, &BP);
+	pci_read_config_byte(dev, (drive_pci)|0x02, &CP);
+
+	if ((id->dma_ultra & 0x0020) && (udma_100) && (udma_33)) {
+		if (!((id->dma_ultra >> 8) & 0x20)) {
+			drive->id->dma_ultra &= ~0xFF00;
+			drive->id->dma_ultra |= 0x2020;
+			drive->id->dma_mword &= ~0x0F00;
+			drive->id->dma_1word &= ~0x0F00;
+		}
+		/* speed 9 == UDMA mode 5 == speed 7 plus cable */
+		pci_write_config_byte(dev, (drive_pci)|0x01, BP|0x20);
+		pci_write_config_byte(dev, (drive_pci)|0x02, CP|0x01);
+		speed = XFER_UDMA_5;
+	} else if ((id->dma_ultra & 0x0010) && (udma_66) && (udma_33)) {
+		if (!((id->dma_ultra >> 8) & 16)) {
+			drive->id->dma_ultra &= ~0xFF00;
+			drive->id->dma_ultra |= 0x1010;
+			drive->id->dma_mword &= ~0x0F00;
+			drive->id->dma_1word &= ~0x0F00;
+		}
+		/* speed 8 == UDMA mode 4 == speed 6 plus cable */
+		pci_write_config_byte(dev, (drive_pci)|0x01, BP|0x20);
+		pci_write_config_byte(dev, (drive_pci)|0x02, CP|0x01);
+		speed = XFER_UDMA_4;
+	} else if ((id->dma_ultra & 0x0008) && (udma_66) && (udma_33)) {
+		if (!((id->dma_ultra >> 8) & 8)) {
+			drive->id->dma_ultra &= ~0xFF00;
+			drive->id->dma_ultra |= 0x0808;
+			drive->id->dma_mword &= ~0x0F00;
+			drive->id->dma_1word &= ~0x0F00;
+		}
+		/* speed 7 == UDMA mode 3 == speed 5 plus cable */
+		pci_write_config_byte(dev, (drive_pci)|0x01, BP|0x40);
+		pci_write_config_byte(dev, (drive_pci)|0x02, CP|0x02);
+		speed = XFER_UDMA_3;
+	} else if ((id->dma_ultra & 0x0004) && (udma_33)) {
+		if (!((id->dma_ultra >> 8) & 4)) {
+			drive->id->dma_ultra &= ~0x0F00;
+			drive->id->dma_ultra |= 0x0404;
+			drive->id->dma_mword &= ~0x0F00;
+			drive->id->dma_1word &= ~0x0F00;
+		}
+		/* speed 6 == UDMA mode 2 */
+		pci_write_config_byte(dev, (drive_pci)|0x01, BP|0x20);
+		pci_write_config_byte(dev, (drive_pci)|0x02, CP|0x01);
+		speed = XFER_UDMA_2;
+	} else if ((id->dma_ultra & 0x0002) && (udma_33)) {
+		if (!((id->dma_ultra >> 8) & 2)) {
+			drive->id->dma_ultra &= ~0x0F00;
+			drive->id->dma_ultra |= 0x0202;
+			drive->id->dma_mword &= ~0x0F00;
+			drive->id->dma_1word &= ~0x0F00;
+		}
+		/* speed 5 == UDMA mode 1 */
+		pci_write_config_byte(dev, (drive_pci)|0x01, BP|0x40);
+		pci_write_config_byte(dev, (drive_pci)|0x02, CP|0x02);
+		speed = XFER_UDMA_1;
+	} else if ((id->dma_ultra & 0x0001) && (udma_33)) {
+		if (!((id->dma_ultra >> 8) & 1)) {
+			drive->id->dma_ultra &= ~0x0F00;
+			drive->id->dma_ultra |= 0x0101;
+			drive->id->dma_mword &= ~0x0F00;
+			drive->id->dma_1word &= ~0x0F00;
+		}
+		/* speed 4 == UDMA mode 0 */
+		pci_write_config_byte(dev, (drive_pci)|0x01, BP|0x60);
+		pci_write_config_byte(dev, (drive_pci)|0x02, CP|0x03);
+		speed = XFER_UDMA_0;
+	} else if (id->dma_mword & 0x0004) {
+		if (!((id->dma_mword >> 8) & 4)) {
+			drive->id->dma_mword &= ~0x0F00;
+			drive->id->dma_mword |= 0x0404;
+			drive->id->dma_1word &= ~0x0F00;
+		}
+		/* speed 4 == DMA mode 2 multi-word */
+		pci_write_config_byte(dev, (drive_pci)|0x01, BP|0x60);
+		pci_write_config_byte(dev, (drive_pci)|0x02, CP|0x03);
+		speed = XFER_MW_DMA_2;
+	} else if (id->dma_mword & 0x0002) {
+		if (!((id->dma_mword >> 8) & 2)) {
+			drive->id->dma_mword &= ~0x0F00;
+			drive->id->dma_mword |= 0x0202;
+			drive->id->dma_1word &= ~0x0F00;
+		}
+		/* speed 3 == DMA mode 1 multi-word */
+		pci_write_config_byte(dev, (drive_pci)|0x01, BP|0x60);
+		pci_write_config_byte(dev, (drive_pci)|0x02, CP|0x04);
+		speed = XFER_MW_DMA_1;
+	} else if (id->dma_mword & 0x0001) {
+		if (!((id->dma_mword >> 8) & 1)) {
+			drive->id->dma_mword &= ~0x0F00;
+			drive->id->dma_mword |= 0x0101;
+			drive->id->dma_1word &= ~0x0F00;
+		}
+		/* speed 2 == DMA mode 0 multi-word */
+		pci_write_config_byte(dev, (drive_pci)|0x01, BP|0x60);
+		pci_write_config_byte(dev, (drive_pci)|0x02, CP|0x05);
+		speed = XFER_MW_DMA_0;
+	} else if (id->dma_1word & 0x0004) {
+		if (!((id->dma_1word >> 8) & 4)) {
+			drive->id->dma_mword &= ~0x0F00;
+			drive->id->dma_1word &= ~0x0F00;
+			drive->id->dma_1word |= 0x0404;
+		}
+		/* speed 2 == DMA mode 2 single-word */
+		pci_write_config_byte(dev, (drive_pci)|0x01, BP|0x60);
+		pci_write_config_byte(dev, (drive_pci)|0x02, CP|0x05);
+		speed = XFER_SW_DMA_2;
+	} else if (id->dma_1word & 0x0002) {
+		if (!((id->dma_1word >> 8) & 2)) {
+			drive->id->dma_mword &= ~0x0F00;
+			drive->id->dma_1word &= ~0x0F00;
+			drive->id->dma_1word |= 0x0202;
+		}
+		/* speed 1 == DMA mode 1 single-word */
+		pci_write_config_byte(dev, (drive_pci)|0x01, BP|0x80);
+		pci_write_config_byte(dev, (drive_pci)|0x02, CP|0x06);
+		speed = XFER_SW_DMA_1;
+	} else if (id->dma_1word & 0x0001) {
+		if (!((id->dma_1word >> 8) & 1)) {
+			drive->id->dma_mword &= ~0x0F00;
+			drive->id->dma_1word &= ~0x0F00;
+			drive->id->dma_1word |= 0x0101;
+		}
+		/* speed 0 == DMA mode 0 single-word */
+		pci_write_config_byte(dev, (drive_pci)|0x01, BP|0xC0);
+		pci_write_config_byte(dev, (drive_pci)|0x02, CP|0x0B);
+		speed = XFER_SW_DMA_0;
+	} else {
+		/* restore original pci-config space */
+		pci_write_config_dword(dev, drive_pci, drive_conf);
+		return ide_dma_off_quietly;
+	}
+
+	err = ide_wait_cmd(drive, WIN_SETFEATURES, speed, SETFEATURES_XFER, 0, NULL);
+
+#if PDC202XX_DECODE_REGISTER_INFO
+	pci_read_config_byte(dev, (drive_pci), &AP);
+	pci_read_config_byte(dev, (drive_pci)|0x01, &BP);
+	pci_read_config_byte(dev, (drive_pci)|0x02, &CP);
+
+	decode_registers(REG_A, AP);
+	decode_registers(REG_B, BP);
+	decode_registers(REG_C, CP);
+	decode_registers(REG_D, DP);
+#endif /* PDC202XX_DECODE_REGISTER_INFO */
+
+#if PDC202XX_DEBUG_DRIVE_INFO
+	printk("%s: %s drive%d 0x%08x ",
+		drive->name, ide_xfer_verbose(speed),
+		drive_number, drive_conf);
+	pci_read_config_dword(dev, drive_pci, &drive_conf);
+	printk("0x%08x\n", drive_conf);
+#endif /* PDC202XX_DEBUG_DRIVE_INFO */
+
+chipset_is_set:
+
+	return ((int)	(id->dma_ultra >> 13)       ? ide_dma_on :
+	             	((id->dma_ultra >> 11) & 3) ? ide_dma_on :
+			((id->dma_ultra >> 8) & 7) ? ide_dma_on :
+			((id->dma_mword >> 8) & 7) ? ide_dma_on : 
+			((id->dma_1word >> 8) & 7) ? ide_dma_on :
+						     ide_dma_off_quietly);
+}
+
+/*   0    1    2    3    4    5    6   7   8
+ * 960, 480, 390, 300, 240, 180, 120, 90, 60
+ *           180, 150, 120,  90,  60
+ * DMA_Speed
+ * 180, 120,  90,  90,  90,  60,  30
+ *  11,   5,   4,   3,   2,   1,   0
+ */
+
+static int config_drive_xfer_rate (ide_drive_t *drive)
+{
+	struct hd_driveid *id = drive->id;
+	ide_dma_action_t dma_func = ide_dma_off_quietly;
+
+	if ( id && (id->capability & 1) ) {
+		if (id->field_valid & 4) {
+			if (id->dma_ultra & 0x00FF) {
+				/* Force if Capable UltraDMA */
+				dma_func = config_chipset_for_dma(drive, 1);
+				if ((id->field_valid & 2) &&
+				    (dma_func != ide_dma_on))
+					goto try_dma_modes;
+			}
+		} else if (id->field_valid & 2) {
+try_dma_modes:
+			if ((id->dma_mword & 0x0004) ||
+			    (id->dma_1word & 0x0004)) {
+				/* Force if Capable regular DMA modes */
+				dma_func = config_chipset_for_dma(drive, 0);
+			}
+		} else if ((ide_dmaproc(ide_dma_good_drive, drive)) &&
+			   (id->eide_dma_time > 150)) {
+			/* Consult the list of known "good" drives */
+			dma_func = config_chipset_for_dma(drive, 0);
+		}
+	}
+	return HWIF(drive)->dmaproc(dma_func, drive);
+}
+
+/*
+ * pdc202xx_dmaproc() initiates/aborts (U)DMA read/write operations on a drive.
+ */
+int pdc202xx_dmaproc (ide_dma_action_t func, ide_drive_t *drive)
+{
+	switch (func) {
+		case ide_dma_check:
+			return config_drive_xfer_rate(drive);
+		default:
+			break;
+	}
+	return ide_dmaproc(func, drive);	/* use standard DMA stuff */
+}
+
+__initfunc(unsigned int pci_init_pdc202xx (struct pci_dev *dev, const char *name))
+{
+	unsigned long high_16	= dev->base_address[4] & PCI_BASE_ADDRESS_IO_MASK;
+	byte udma_speed_flag	= inb(high_16 + 0x001f);
+	byte primary_mode	= inb(high_16 + 0x001a);
+	byte secondary_mode	= inb(high_16 + 0x001b);
+
+	if (dev->rom_address) {
+		pci_write_config_dword(dev, PCI_ROM_ADDRESS, dev->rom_address | PCI_ROM_ADDRESS_ENABLE);
+		printk("%s: ROM enabled at 0x%08lx\n", name, dev->rom_address);
+	}
+
+	printk("%s: (U)DMA Burst Bit %sABLED " \
+		"Primary %s Mode " \
+		"Secondary %s Mode.\n",
+		name,
+		(udma_speed_flag & 1) ? "EN" : "DIS",
+		(primary_mode & 1) ? "MASTER" : "PCI",
+		(secondary_mode & 1) ? "MASTER" : "PCI" );
+
+#if PDC202XX_FORCE_BURST_BIT
+	if (!(udma_speed_flag & 1)) {
+		printk("%s: FORCING BURST BIT 0x%02x -> 0x%02x ", name, udma_speed_flag, (udma_speed_flag|1));
+		outb(udma_speed_flag|1, high_16 + 0x001f);
+		printk("%sCTIVE\n", (inb(high_16 + 0x001f) & 1) ? "A" : "INA");
+	}
+#endif /* PDC202XX_FORCE_BURST_BIT */
+
+#if PDC202XX_FORCE_MASTER_MODE
+	if (!(primary_mode & 1)) {
+		printk("%s: FORCING PRIMARY MODE BIT 0x%02x -> 0x%02x ",
+			name, primary_mode, (primary_mode|1));
+		outb(primary_mode|1, high_16 + 0x001a);
+		printk("%s\n", (inb(high_16 + 0x001a) & 1) ? "MASTER" : "PCI");
+	}
+
+	if (!(secondary_mode & 1)) {
+		printk("%s: FORCING SECONDARY MODE BIT 0x%02x -> 0x%02x ",
+			name, secondary_mode, (secondary_mode|1));
+		outb(secondary_mode|1, high_16 + 0x001b);
+		printk("%s\n", (inb(high_16 + 0x001b) & 1) ? "MASTER" : "PCI");
+	}
+#endif /* PDC202XX_FORCE_MASTER_MODE */
+	return dev->irq;
+}
+
+__initfunc(void ide_init_pdc202xx (ide_hwif_t *hwif))
+{
+	if (hwif->dma_base) {
+		hwif->dmaproc = &pdc202xx_dmaproc;
+	}
+}
--- linux-2.2.14-pristine/include/linux/hdreg.h	Fri May 19 15:55:59 2000
+++ linux/include/linux/hdreg.h	Thu Jul  6 00:01:00 2000
@@ -93,6 +93,45 @@
 #define SMART_STATUS		0xda
 #define SMART_AUTO_OFFLINE	0xdb
 
+/* WIN_SETFEATURES sub-commands */
+
+#define SETFEATURES_EN_WCACHE	0x02	/* Enable write cache */
+#define SETFEATURES_XFER	0x03	/* Set transfer mode */
+#	define XFER_UDMA_5	0x45	/* 0100|0101 */
+#	define XFER_UDMA_4	0x44	/* 0100|0100 */
+#	define XFER_UDMA_3	0x43	/* 0100|0011 */
+#	define XFER_UDMA_2	0x42	/* 0100|0010 */
+#	define XFER_UDMA_1	0x41	/* 0100|0001 */
+#	define XFER_UDMA_0	0x40	/* 0100|0000 */
+#	define XFER_MW_DMA_2	0x22	/* 0010|0010 */
+#	define XFER_MW_DMA_1	0x21	/* 0010|0001 */
+#	define XFER_MW_DMA_0	0x20	/* 0010|0000 */
+#	define XFER_SW_DMA_2	0x12	/* 0001|0010 */
+#	define XFER_SW_DMA_1	0x11	/* 0001|0001 */
+#	define XFER_SW_DMA_0	0x10	/* 0001|0000 */
+#	define XFER_PIO_4	0x0C	/* 0000|1100 */
+#	define XFER_PIO_3	0x0B	/* 0000|1011 */
+#	define XFER_PIO_2	0x0A	/* 0000|1010 */
+#	define XFER_PIO_1	0x09	/* 0000|1001 */
+#	define XFER_PIO_0	0x08	/* 0000|1000 */
+#	define XFER_PIO_SLOW	0x00	/* 0000|0000 */
+#define SETFEATURES_EN_APM	0x05	/* Enable advanced power management */
+#define SETFEATURES_DIS_MSN	0x31	/* Disable Media Status Notification */
+#define SETFEATURES_DIS_RLA	0x55	/* Disable read look-ahead feature */
+#define SETFEATURES_EN_RI	0x5D	/* Enable release interrupt */
+#define SETFEATURES_EN_SI	0x5E	/* Enable SERVICE interrupt */
+#define SETFEATURES_DIS_RPOD	0x66	/* Disable reverting to power on defaults */
+#define SETFEATURES_DIS_WCACHE	0x82	/* Disable write cache */
+#define SETFEATURES_DIS_APM	0x85	/* Disable advanced power management */
+#define SETFEATURES_EN_MSN	0x95	/* Enable Media Status Notification */
+#define SETFEATURES_EN_RLA	0xAA	/* Enable read look-ahead feature */
+#define SETFEATURES_EN_RPOD	0xCC	/* Enable reverting to power on defaults */
+#define SETFEATURES_DIS_RI	0xDD	/* Disable release interrupt */
+#define SETFEATURES_DIS_SI	0xDE	/* Disable SERVICE interrupt */
+
+ /* WIN_SECURITY sub-commands */
+
+
 /* WIN_SECURITY sub-commands */
 #define SECURITY_SET_PASSWORD		0xBA	/* 0xF1 */
 #define SECURITY_UNLOCK			0xBB	/* 0xF2 */
--- linux-2.2.14-pristine/include/linux/pci.h	Fri May 19 15:56:18 2000
+++ linux/include/linux/pci.h	Thu Jul  6 00:01:00 2000
@@ -529,7 +529,12 @@
 
 #define PCI_VENDOR_ID_PROMISE		0x105a
 #define PCI_DEVICE_ID_PROMISE_20246	0x4d33
+#define PCI_DEVICE_ID_PROMISE_20262	0x4d38
+#define PCI_DEVICE_ID_PROMISE_20265	0x0d30
+#define PCI_DEVICE_ID_PROMISE_20267	0x4d30
 #define PCI_DEVICE_ID_PROMISE_5300	0x5300
+
+
 
 #define PCI_VENDOR_ID_N9		0x105d
 #define PCI_DEVICE_ID_N9_I128		0x2309
