/* Copyright (C) 1997-1998, Ghostgum Software Pty Ltd.  All rights reserved.
  
  This file is part of RedMon.
  
  This program is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the RedMon Free Public Licence 
  (the "Licence") for full details.
  
  Every copy of RedMon must include a copy of the Licence, normally in a 
  plain ASCII text file named LICENCE.  The Licence grants you the right 
  to copy, modify and redistribute RedMon, but only under certain conditions 
  described in the Licence.  Among other things, the Licence requires that 
  the copyright notice and this notice be preserved on all copies.
*/

/* redmon.h */
/* Win95 definitions for Port and Language Monitors */

/* These definitions were obtained from the Win95 DDK
 * available from the MSDN Online Library.
 *   http://premium.microsoft.com/msdn/library/
 */

#include "redmonrc.h"

#define MAXSTR 256
#define MAXSHORTSTR 64

#ifndef __BORLANDC__
#define _export
#endif

#define MONITORNAME TEXT("Redirected Port")
#define MONITORDLL95 TEXT("redmon95.dll")
#define MONITORDLLNT TEXT("redmonnt.dll")
#define MONITORDLL35 TEXT("redmon35.dll")
#define MONITORENV95 TEXT("Windows 4.0")
#define MONITORENVNT TEXT("Windows NT x86")
#define MONITORHLP TEXT("redmon.hlp")
#define MONITORKEY TEXT("Redirection Port Monitor")

#define UNINSTALLPROG TEXT("unredmon.exe")
#define UNINSTALLKEY TEXT("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall")
#define UNINSTALLSTRINGKEY TEXT("UninstallString")
#define DISPLAYNAMEKEY TEXT("DisplayName")

#ifndef PORT_TYPE_WRITE
/* PORT_INFO_2 isn't defined in BC++ 4.5 include files */

typedef struct _PORT_INFO_2A { 
    LPSTR     pPortName; 
    LPSTR     pMonitorName; 
    LPSTR     pDescription; 
    DWORD     fPortType; 
    DWORD     Reserved; 
} PORT_INFO_2A, *PPORT_INFO_2A, *LPPORT_INFO_2A; 
typedef struct _PORT_INFO_2W { 
    LPWSTR    pPortName; 
    LPWSTR    pMonitorName; 
    LPWSTR    pDescription; 
    DWORD     fPortType; 
    DWORD     Reserved; 
} PORT_INFO_2W, *PPORT_INFO_2W, *LPPORT_INFO_2W; 

#ifdef UNICODE 
typedef PORT_INFO_2W PORT_INFO_2; 
typedef PPORT_INFO_2W PPORT_INFO_2; 
typedef LPPORT_INFO_2W LPPORT_INFO_2; 
#else 
typedef PORT_INFO_2A PORT_INFO_2; 
typedef PPORT_INFO_2A PPORT_INFO_2; 
typedef LPPORT_INFO_2A LPPORT_INFO_2; 
#endif // UNICODE 
 
#define PORT_TYPE_WRITE         0x0001 
#define PORT_TYPE_READ          0x0002 
#define PORT_TYPE_REDIRECTED    0x0004 
#define PORT_TYPE_NET_ATTACHED  0x0008 
 
#endif

#ifndef DI_CHANNEL
/* DI_CHANNEL is used by DOC_INFO_2 */
typedef struct _DOC_INFO_2A {
    LPSTR     pDocName;
    LPSTR     pOutputFile;
    LPSTR     pDatatype;
    DWORD   dwMode;
    DWORD   JobId;
} DOC_INFO_2A, *PDOC_INFO_2A, *LPDOC_INFO_2A;
typedef struct _DOC_INFO_2W {
    LPWSTR    pDocName;
    LPWSTR    pOutputFile;
    LPWSTR    pDatatype;
    DWORD   dwMode;
    DWORD   JobId;
} DOC_INFO_2W, *PDOC_INFO_2W, *LPDOC_INFO_2W;
#ifdef UNICODE
typedef DOC_INFO_2W DOC_INFO_2;
typedef PDOC_INFO_2W PDOC_INFO_2;
typedef LPDOC_INFO_2W LPDOC_INFO_2;
#else
typedef DOC_INFO_2A DOC_INFO_2;
typedef PDOC_INFO_2A PDOC_INFO_2;
typedef LPDOC_INFO_2A LPDOC_INFO_2;
#endif // UNICODE

#define DI_CHANNEL              1    // start direct read/write channel,
#endif // !defined(DI_CHANNEL)

#ifdef UNICODE
/* The biggest difference between NT and 95 is that NT uses wide characters
 * (Unicode) for strings, while 95 uses ANSI characters (single byte).
 */
#ifdef NT35
/* Windows NT 3.51 exports separate procedures */
#define rAddPortEx	_export AddPortExW
#define rAddPort	_export AddPortW
#define rClosePort	_export ClosePort
#define rConfigurePort	_export ConfigurePortW
#define rDeletePort	_export DeletePortW
#define rEndDocPort	_export EndDocPort
#define rEnumPorts	_export EnumPortsW
#define rOpenPort	_export OpenPort
#define rReadPort	_export ReadPort
#define rStartDocPort	_export StartDocPort
#define rWritePort	_export WritePort
BOOL WINAPI _export InitializeMonitor(LPWSTR pRegistryRoot);
#else	/* !NT35 */
/* Windows NT4 structure */
/* The MONITOR structure has an extra member cf. Windows 95 */
typedef struct _MONITOR {
        BOOL (WINAPI *pfnEnumPorts)(LPWSTR pName, DWORD Level, LPBYTE pPorts,
                DWORD cbBuf, LPDWORD pcbNeeded, LPDWORD pcReturned);
        BOOL (WINAPI *pfnOpenPort)(LPWSTR pName, PHANDLE pHandle);
        BOOL (WINAPI *pfnOpenPortEx)(LPWSTR pPortName,LPWSTR pPrinterName,
                PHANDLE pHandle, struct _MONITOR FAR *pMonitor);
        BOOL (WINAPI *pfnStartDocPort)(HANDLE hPort,LPWSTR pPrinterName,
		DWORD JobId, DWORD Level,LPBYTE pDocInfo);
        BOOL (WINAPI *pfnWritePort)(HANDLE hPort,LPBYTE pBuffer,DWORD cbBuf,
                LPDWORD pcbWritten);
        BOOL (WINAPI *pfnReadPort)(HANDLE hPort,LPBYTE pBuffer,DWORD cbBuffer,
                LPDWORD pcbRead);
        BOOL (WINAPI *pfnEndDocPort)(HANDLE hPort);
        BOOL (WINAPI *pfnClosePort)(HANDLE hPort);
        BOOL (WINAPI *pfnAddPort)(LPWSTR pName, HWND hWnd, LPWSTR pMonitorName);
        BOOL (WINAPI *pfnAddPortEx)(LPWSTR pName, DWORD Level, LPBYTE lpBuffer,
                LPWSTR lpMonitorName);
        BOOL (WINAPI *pfnConfigurePort)(LPWSTR pName, HWND hWnd, 
		LPWSTR pPortName);
        BOOL (WINAPI *pfnDeletePort)(LPWSTR pName, HWND hWnd, LPWSTR pPortName);
        BOOL (WINAPI *pfnGetPrinterDataFromPort)(HANDLE hPort, DWORD ControlID,
                LPWSTR pValueName, LPWSTR lpInBuffer, DWORD cbInBuffer,
                LPWSTR lpOutBuffer, DWORD cbOutBuffer, LPDWORD lpcbReturned);
        BOOL (WINAPI *pfnSetPortTimeOuts)(HANDLE hPort,LPCOMMTIMEOUTS lpCTO,
                DWORD reserved /* must be set to 0 */);
} MONITOR, FAR *LPMONITOR;

typedef struct _MONITOREX {
        DWORD  dwMonitorSize;
        MONITOR  Monitor;
} MONITOREX, FAR *LPMONITOREX;

LPMONITOREX WINAPI _export InitializePrintMonitor(LPWSTR pRegistryRoot);
#endif	/* !NT35 */
#else   /* !UNICODE */
/* Windows 95 structure */
/* The MONITOR structure is returned by InitializeMonitorEx() */
typedef struct _MONITOR {
     BOOL (WINAPI *pfnEnumPorts)(LPTSTR pName,DWORD Level,LPBYTE  pPorts, 
         DWORD cbBuf, LPDWORD pcbNeeded, LPDWORD pcReturned);
    BOOL (WINAPI *pfnOpenPort)(LPTSTR  pName,PHANDLE pHandle);
    BOOL (WINAPI *pfnOpenPortEx)(LPTSTR  pPortName, 
        LPTSTR  pPrinterName, PHANDLE pHandle, struct _MONITOR 
        FAR *pMonitor);
    BOOL (WINAPI *pfnStartDocPort)(HANDLE  hPort, LPTSTR  pPrinterName, 
        DWORD   JobId, DWORD   Level, LPBYTE  pDocInfo);
    BOOL (WINAPI *pfnWritePort)(HANDLE  hPort, LPBYTE  pBuffer, 
        DWORD   cbBuf, LPDWORD pcbWritten);
    BOOL (WINAPI *pfnReadPort)(HANDLE hPort, LPBYTE pBuffer, 
        DWORD  cbBuffer, LPDWORD pcbRead);
    BOOL (WINAPI *pfnEndDocPort)(HANDLE   hPort);
    BOOL (WINAPI *pfnClosePort)(HANDLE  hPort);
    BOOL (WINAPI *pfnAddPort)(LPTSTR   pName, HWND    hWnd, 
        LPTSTR   pMonitorName);
    BOOL (WINAPI *pfnConfigurePort)(LPTSTR   pName, HWND  hWnd, 
        LPTSTR pPortName);
    BOOL (WINAPI *pfnDeletePort)(LPTSTR   pName, HWND    hWnd, 
        LPTSTR   pPortName);
    BOOL (WINAPI *pfnGetPrinterDataFromPort)(HANDLE hPort, 
        DWORD ControlID, LPTSTR  pValueName, LPTSTR  lpInBuffer, 
        DWORD   cbInBuffer, LPTSTR  lpOutBuffer, DWORD   cbOutBuffer, 
        LPDWORD lpcbReturned);
    BOOL (WINAPI *pfnSetPortTimeOuts)(HANDLE  hPort, 
        LPCOMMTIMEOUTS lpCTO, DWORD reserved); 
} MONITOR, FAR *LPMONITOR;

/* InitializeMonitorEx is exported by the Port or Language
 * Monitor DLL.
 */
BOOL WINAPI _export InitializeMonitorEx(
    LPTSTR     pRegisterRoot,
    LPMONITOR  pMonitor
);

#endif /* !UNICODE */


/* end of redmon.h */
