#
#   REMINDER.R
#   Sample programmable mail form for Pegasus Mail v3.0
#   Copright (c) 1993, David Harris, All Rights Reserved.
#
#   You are granted the right to modify and distribute this
#   form in any way you wish provided you do not sell it or
#   any derivative either on its own or as part of any other
#   package.
#
#   By using this form you agree to hold the author blameless
#   for all or any damages or losses resulting from its use.
#
#   This form provides an interface to an undocumented feature
#   in the Mercury Mail Transport System which can send reminder
#   notifications in response to a message.
#

include defines.rh
include forms.rh

string form_title     "Basic Message Editor";

window fwindow    # The window in which the form appears
   {
   45, 6, 32, 12, BBLUE | LIGHTGREY | wzip | wshadow,
   BBLUE | LIGHTGREY, ' ', BSINGLE,
   " Reminder request "
   };

box mbox
   {
   1, 8, 29, 2, BSINGLE, BBLUE | LIGHTGREY
   };

block field_text
   {
   3, 2, BBLUE | LIGHTGREY,
   "Year          :",
   "Month (1-12)  :",
   "Day (1-31)    :",
   "Hour (0-23)   :",
   "Minute (0-59) :",
   "",
   " Message "
   };

data year
   {
   21, 2, 2, 2, 0, 0, 0, GT_INTEGER, 0
   };

data month
   {
   21, 3, 2, 2, 0, 0, 0, GT_INTEGER, 0
   };

data day
   {
   21, 4, 2, 2, 0, 0, 0, GT_INTEGER, 0
   };

data hour
   {
   21, 5, 2, 2, 0, 0, 0, GT_INTEGER, 0
   };

data minute
   {
   21, 6, 2, 2, 0, 0, 0, GT_INTEGER, 0
   };

data message
   {
   3, 9, 25, 25, 0, 0, 0, GT_STRING, 0
   };

text fformat
   {
   "notify me {field 7}-{field 8}-{field 9} {field 10}:{field 11} {field 12}\n"
   };

text hlp_year
   {
   " Reminder interface: YEAR \n",
   "This form provides an interface to an undocumented feature\n",
   "of the Mercury Mail Transport System which allows you to\n",
   "schedule reminder messages to be sent at particular times.\n",
   "For this form to work correctly, you must be using the\n",
   "Mercury System with the Mail Server function enabled.\n",
   "\n",
   "The Year field: enter here the year when the notification\n",
   "should occur, expressed as two digits (eg \"93\"). The default\n",
   "value is the current year.\n",
   "\n",
   "You can move between fields using the arrow keys. Press\n",
   "<Ctrl-Enter> when you are ready to set the reminder.",
   }

text hlp_month
   {
   " Reminder interface: MONTH \n",
   "This form provides an interface to an undocumented feature\n",
   "of the Mercury Mail Transport System which allows you to\n",
   "schedule reminder messages to be sent at particular times.\n",
   "For this form to work correctly, you must be using the\n",
   "Mercury System with the Mail Server function enabled.\n",
   "\n",
   "The Month field: enter here the month when the reminder\n",
   "should occur, as digits (eg \"8\" or \"08\"). The default value\n",
   "is the current month.\n",
   "\n",
   "You can move between fields using the arrow keys. Press\n",
   "<Ctrl-Enter> when you are ready to set the reminder.",
   }

text hlp_day
   {
   " Reminder interface: DAY \n",
   "This form provides an interface to an undocumented feature\n",
   "of the Mercury Mail Transport System which allows you to\n",
   "schedule reminder messages to be sent at particular times.\n",
   "For this form to work correctly, you must be using the\n",
   "Mercury System with the Mail Server function enabled.\n",
   "\n",
   "The Day field: enter here the day when the reminder message\n",
   "should occur, as digits (eg \"3\" or \"03\"). The default value\n",
   "is the current day.\n",
   "\n",
   "You can move between fields using the arrow keys. Press\n",
   "<Ctrl-Enter> when you are ready to set the reminder.",
   }

text hlp_hour
   {
   " Reminder interface: HOUR \n",
   "This form provides an interface to an undocumented feature\n",
   "of the Mercury Mail Transport System which allows you to\n",
   "schedule reminder messages to be sent at particular times.\n",
   "For this form to work correctly, you must be using the\n",
   "Mercury System with the Mail Server function enabled.\n",
   "\n",
   "The Hour field: enter here the hour when the notification\n",
   "should occur, as digits (eg \"8\" or \"08\") using the 24-hour\n",
   "Clock. The default value for this field is 0 (midnight)\n",
   "\n",
   "You can move between fields using the arrow keys. Press\n",
   "<Ctrl-Enter> when you are ready to set the reminder.",
   }

text hlp_min
   {
   " Reminder interface: MINUTE \n",
   "This form provides an interface to an undocumented feature\n",
   "of the Mercury Mail Transport System which allows you to\n",
   "schedule reminder messages to be sent at particular times.\n",
   "For this form to work correctly, you must be using the\n",
   "Mercury System with the Mail Server function enabled.\n",
   "\n",
   "The Minute field: enter here the minute when the reminder\n",
   "should occur, as digits (eg \"8\" or \"08\") from 0 to 60. The\n",
   "default value for this field is 0 (top of the hour)\n",
   "\n",
   "You can move between fields using the arrow keys. Press\n",
   "<Ctrl-Enter> when you are ready to set the reminder.",
   }

text hlp_message
   {
   " Reminder interface: MESSAGE \n",
   "This form provides an interface to an undocumented feature\n",
   "of the Mercury Mail Transport System which allows you to\n",
   "schedule reminder messages to be sent at particular times.\n",
   "For this form to work correctly, you must be using the\n",
   "Mercury System with the Mail Server function enabled.\n",
   "\n",
   "The Message field: enter here the text which should appear\n",
   "in the broadcast message which is sent when the reminder\n",
   "falls due. You can enter any text you wish in this field -\n",
   "there is no default value.\n",
   "\n",
   "You can move between fields using the arrow keys. Press\n",
   "<Ctrl-Enter> when you are ready to set the reminder.",
   }

string maiser_dflt             "IN:MAISER";
string subject_dflt            "Notification request";
string year_dflt               "{year_2}";
string month_dflt              "{nmonth}";
string day_dflt                "{nday}";

formtable formdata
   {
#  Name........ Correlation. Help text.... Validation... Status...... Default
   fwindow,     F_WINDOW,    0,            0,            0,           0,
   0,           F_TO,        0,            0,            0,           maiser_dflt,
   0,           F_SUBJECT,   0,            0,            0,           subject_dflt,
   0,           F_NOSIG,     0,            0,            0,           1,
   fformat,     F_SMTP_TEMPLATE, 0         0,            0,           0,
   mbox,        0,           0,            0,            0,           0,
   field_text,  0,           0,            0,            0,           0,
   year,        F_INTEGER,   hlp_year,     0,            0,           year_dflt,
   month,       F_INTEGER,   hlp_month,    0,            0,           month_dflt,
   day,         F_INTEGER,   hlp_day,      0,            0,           day_dflt,
   hour,        F_INTEGER,   hlp_hour,     0,            0,           0,
   minute,      F_INTEGER,   hlp_min,      0,            0,           0,
   message,     F_STRING,    hlp_message,  0,            0,           0
   };

