//////////////////////////////////////////////////////////////////////////
//
//  IGATOR Copyright (C) 1997-98 RIT Research Labs
//
//  This programs is free for commercial and non-commercial use as long as
//  the following conditions are aheared to.
//
//  Copyright remains RIT Research Labs, and as such any Copyright notices
//  in the code are not to be removed. If this package is used in a
//  product, RIT Research Labs should be given attribution as the RIT Research
//  Labs of the parts of the library used. This can be in the form of a textual
//  message at program startup or in documentation (online or textual)
//  provided with the package.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//
//  1. Redistributions of source code must retain the copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. All advertising materials mentioning features or use of this software
//     must display the following acknowledgement:
//     "Based on IGATOR by RIT Research Labs."
//
//  THIS SOFTWARE IS PROVIDED BY RIT RESEARCH LABS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//  DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
//  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
//  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
//  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
//  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
//  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//  The licence and distribution terms for any publically available
//  version or derivative of this code cannot be changed. i.e. this code
//  cannot simply be copied and put under another distribution licence
//  (including the GNU Public Licence).
//
//////////////////////////////////////////////////////////////////////////

unit _Out;

interface

procedure ScanNetmail;

implementation

uses Windows, Classes, SysUtils, IniFiles, Utils, SendMail,
     Logger, Config, _UUE;

procedure DoConvert(var S: String);
  var I: Integer;
begin
  for I := 1 to Length(S) do
    if S[I] = '#' then S[I] := '@';
end;

function Get0(const A: Array of Char): String;
  var I, J: Integer;
begin
  J := High(A);
  for I := Low(A) to High(A) do
    if A[I] = #0 then begin J := I; Break; end;
  SetLength(Result, J-Low(A));
  if J > Low(A) then Move(A[Low(A)], Result[1], J-Low(A));
end;

procedure DoMsg(const Nm: String);
  label 1;
  var F: TDosStream;
      H: TMsgHdr;
      S: String;
      U: TUser;
      TNm, FNm: String;
      BytesToOut: LongInt;
      RRQ: Boolean;
      LF: Boolean;
      I: Integer;

  function SendMsg: Boolean;
    var SS: TDosStream;
        B, BT: Pointer;
        T, TT, A: Text;
        S, A1, A2: String;
        LN,I,J,K: Integer;
        ACount: Integer;
        Boundary: String[40];

    procedure CheckAttachments;
      var C: TMimeCoder;
          B: Boolean;
          I,J,K,L: Integer;
          SR: TSearchRec;
          F: TDosStream;
          A: Array[0..100] of Byte;
    begin
      B := False;
      J := 1;
      while (J <= Length(S)) and (S[J] = ' ') do Inc(J);
      S := S + ' ';
      for I := 1 to Length(S) do
        if S[I] = ' ' then
          begin
            B := (FindFirst(Copy(S, J, I-J), $3F, SR) = 0) and
                 (SR.Attr and faDirectory = 0);
            FindClose(SR);
            J := I;
            while (J <= Length(S)) and (S[J] = ' ') do Inc(J);
            if B then Break;
          end;
      if not B then Exit;
      if U.Encode = 0 then
        begin
          C.Create(bsBase64);
          Randomize;
          Boundary := '--------------'+Hex4(Random(65530))+Hex4(Random(65530));
          WriteLn(TT, 'MIME-Version: 1.0');
          WriteLn(TT, 'Content-Type: multipart/mixed; boundary="', Boundary, '"');
          WriteLn(TT);
          WriteLn(TT, 'This is a MIME-encoded message');
          WriteLn(TT);
          J := 1; F := nil;
          while (J <= Length(S)) and (S[J] = ' ') do Inc(J);
          for I := 1 to Length(S) do
            if S[I] = ' ' then
              try
                F := TDosStream.Create(Copy(S, J, I-J), stRead);
                if F.Status <> stOK then Exit;
                WriteLn(TT, '--', Boundary);
                WriteLn(TT, 'Content-Type: application/octet-stream; name="', ExtractFileName(Copy(S, J, I-J)), '"');
                WriteLn(TT, 'Content-Transfer-Encoding: base64');
                WriteLn(TT, 'Content-Disposition: attachment; filename="', ExtractFileName(Copy(S, J, I-J)), '"');
                WriteLn(TT);
                L := F.Size;
                while F.Position < L do
                  begin
                    if L-F.Position < 54 then K := L - F.Position else K := 54;
                    F.Read(A, K);
                    WriteLn(TT, C.Encode(A, K));
                  end;
              finally
                F.Free;
                J := I;
                while (J <= Length(S)) and (S[J] = ' ') do Inc(J);
              end;
        end else
        begin
          C.Create(bsUUE);
          WriteLn(TT);
          J := 1;
          while (J <= Length(S)) and (S[J] = ' ') do Inc(J);
          for I := 1 to Length(S) do
            if S[I] = ' ' then
              begin
                F := TDosStream.Create(Copy(S, J, I-J+1), stRead);
                if F.Status = 0 then
                  begin
                    WriteLn(TT, '==== Cut ==== UUEncoded file ==== ', ExtractFileName(Copy(S, J, I-J)), ' ====');
                    WriteLn(TT);
                    WriteLn(TT, 'begin 644 ', ExtractFileName(Copy(S, J, I-J)));
                    L := F.GetSize;
                    while F.GetPos < L do
                      begin
                        if L - F.GetPos < 45 then K := L - F.GetPos else K := 45;
                        F.Read(A, K);
                        Write(TT, C.Table[K+1]);
                        WriteLn(TT, C.Encode(A, K));
                      end;
                    WriteLn(TT, '`');
                    WriteLn(TT, 'end');
                    WriteLn(TT);
                  end;
                F.Free;
                J := I;
                while (J <= Length(S)) and (S[J] = ' ') do Inc(J);
              end;
          WriteLn(TT, '=========== Original message text ===============');
        end;
    end;

    procedure MakeDate;
      var I: Integer;
          Day, Month, Year, DW: Word;
    begin
      DecodeDate(Now, Year, Month, Day);
      Insert(ItoS(Year div 100), S, 8);
      while Pos('  ', S) > 0 do Delete(S, Pos('  ', S), 1);
    end;

  begin
    SendMsg := False; Boundary := '';
    SS := TDosStream.Create('IGATOR.$$$', stCreate);
    SS.CopyFrom(F, F.GetSize-1-F.GetPos);
    SS.Free;
    U.XoutFile('IGATOR.$$$');
    GetMem(B, 4096); GetMem(BT, 4096);
    Assign(T, 'IGATOR.$$$'); ClrIO;
    Reset(T); if IOResult <> 0 then Exit;
    Assign(TT, 'IGATOR.MSG'); Rewrite(TT);
    if IOResult <> 0 then begin Close(T); Exit; end;
    Assign(A, 'IGATOR.ADR'); Rewrite(A);
    if IOResult <> 0 then begin Close(T); Close(TT); Exit; end;
    SetTextBuf(T, B^, 4096);
    SetTextBuf(TT, BT^, 4096);
    WriteLn(TT, 'From: "', U.Name, '" <', U.eMail, '>');
    S := Get0(H.DateTime);
    MakeDate;
    WriteLn(TT, 'Date: ', S);
    WriteLn(TT, 'Reply-To: "', U.Name, '" <', U.eMail, '>');
    WriteLn(TT, 'X-Mailer: ', XTag);
    if RRQ then
       WriteLn(TT, 'Return-Receipt-To: ', U.eMail);
    if UpperCase(TNm) = '@REPORT' then
      begin
        WriteLn(A, U.eMail);
        ACount := 1;
        WriteLn(TT, 'Subject: Mail statistics report');
        WriteLn(TT);
        WriteLn(TT, '-------------------------------------------------------');
        WriteLn(TT, ' Messages received: ', U.MsgIn, ', total size: ', U.BytesIn, ' bytes');
        WriteLn(TT, ' Messages sent: ', U.MsgOut, ', total size: ', U.BytesOut, ' bytes');
        WriteLn(TT, '-------------------------------------------------------');
        WriteLn(TT);
        WriteLn(TT, '   IGATOR Report center');
        while not SeekEof(T) do ReadLn(T, S);
      end else
    if UpperCase(TNm) = '@HELP' then
      begin
        WriteLn(A, U.eMail);
        ACount := 1;
        WriteLn(TT, 'Subject: Help of IGATOR - Internet<->Fido gateway');
        WriteLn(TT);
        Assign(T, HelpFile);
        Reset(T);
        if IOResult = 0 then
          begin
            while not Eof(T) do
              begin
                ReadLn(T, S);
                WriteLn(TT, S);
              end;
          end else
          begin
            WriteLn(TT, 'Sorry, help file is not found, please contact your admitistrator');
          end;
      end else
      begin
        S := Get0(H.Subj);
        WriteLn(TT, 'Subject: ', U.XKludge(S));
        if H.Attr and $10 <> 0 then CheckAttachments else
          if U.XTable <> nil then
          begin
            WriteLn(TT, 'MIME-version: 1.0');
            WriteLn(TT, 'Content-type: text/plain; charset=', U.XTable.Cset);
            WriteLn(TT, 'Content-transfer-encoding: 8bit');
          end;
         WriteLn(TT);
      end;
    S := UpperCase(TNm);
    if S = '@BROADCAST' then
      begin
        for I := 0 to Users.Count-1 do
          if Users[I] <> U then WriteLn(A, TUser(Users[I]).eMail);
        ACount := Users.Count-1;
      end else
    if (TNm <> '@') and (S <> '@UUCP') and (S <> '@GATE') and (S <> 'UUCP') and (S <> '@REPORT') then
      begin
        WriteLn(A, TNm);
        ACount := 1;
      end else ACount := 0;

    LN := 0;
    if Boundary <> '' then
      begin
        WriteLn(TT, Boundary);
        if U.XTable <> nil then WriteLn(TT, 'Content-type: text/plain; charset=', U.XTable.Cset)
                           else WriteLn(TT, 'Content-type: text/plain');
        WriteLn(TT, 'Content-transfer-encoding: 8bit');
      end;
    while not Eof(T) do
      begin
        Read(T, S); LF := EOLN(T); if LF then ReadLn(T);
        if (S <> '') then
          case S[1] of
            #0: Break;
            #1: Continue;
            'T','t': if (LN=0) and (UpperCase(Copy(S, 1, 3)) = 'TO:') then
                       begin
                         Delete(S, 1, 3);
                         while S <> '' do
                           begin
                             I := Pos(',', S);
                             if I = 0 then I := Length(S)+1;
                             ExtractAddrInfo(Copy(S, 1, I-1), A2, A1);
                             if Pos('@', A1) > 0 then
                               begin
                                 WriteLn(A, A1);
                                 Inc(ACount);
                               end;
                             Delete(S, 1, I);
                           end;
                         Continue;
                       end;
            '@': if UpperCase(Copy(S, 2, 3)) = 'TO:' then
                   begin
                     Delete(S, 1, 4); while (S <> '') and (S[1] = ' ') do Delete(S, 1, 1);
                     I := PosChar('<', S);
                     if I > 0 then Delete(S, 1, I);
                     I := PosChar('>', S);
                     if I > 0 then SetLength(S, I-1);
                     if S <> '' then
                       begin
                         WriteLn(A, S);
                         Inc(ACount);
                       end;
                     Continue;
                   end else
                   if UpperCase(Copy(S, 2, 7)) = 'KLUDGES' then
                     begin
                       Delete(S,1,8); S := UpperCase(Trim(S));
                       U.WriteInfo := S <> 'OFF';
                       U.Modified := True;
                       Continue;
                     end;
          end;
        Write(TT, S); if LF then
                         begin
                           WriteLn(TT);
                           Inc(LN);
                         end;
      end;
    if Boundary <> '' then WriteLn(TT, Boundary+'--');
    Close(A); Close(TT); Close(T);
    FreeMem(B, 4096); FreeMem(BT, 4096);
    SendMsg := SendMessage(Smtp, U.Email, 'IGATOR.ADR', 'IGATOR.MSG');
    Assign(T, 'IGATOR.MSG'); Erase(T); ClrIO;
    Assign(T, 'IGATOR.ADR'); Erase(T); ClrIO;
    Assign(T, 'IGATOR.$$$'); Erase(T); ClrIO;
  end;

  procedure GetZonePoint;
    var S: String[250];
        I,J,O: Integer;
        Zone, Net, Node, Point: Word;
  begin
    I := 248;
    O := F.Position;
    if I > F.Size-O then I := F.Size-O;
    S := #13#10;
    F.Read(S[2], I);
    S[0] := Char(I+2);
    I := Pos(#1'INTL ', S);
    if I > 0 then
      begin
        while (I < Length(S)) and (S[I] <> ' ') do Inc(I); Inc(I);
        while (I < Length(S)) and (S[I] <> ' ') do Inc(I); Inc(I);
        J := 1;
        while (I+J < Length(S)) and not (S[I+J] in [' ',#13,#10]) do Inc(J);
        if ParseAddress(Copy(S, I, J), Zone, Net, Node, Point) then H.OrigZone := Zone;
      end else
      begin
        I := Pos(#1'MSGID: ', S);
        if I > 0 then
          begin
            while (I < Length(S)) and (S[I] <> ' ') do Inc(I); Inc(I);
            J := 1;
            while (I+J < Length(S)) and not (S[I+J] in [' ',#13,#10]) do Inc(J);
            if ParseAddress(Copy(S, I, J), Zone, Net, Node, Point) then
              begin H.OrigZone := Zone; H.OrigPoint := Point end;
          end;
      end;
     I := Pos(#1'FMPT ', S);
     if I > 0 then
       begin
         while (I < Length(S)) and (S[I] <> ' ') do Inc(I); Inc(I);
         J := 1;
         while (I+J < Length(S)) and not (S[I+J] in [' ',#13,#10]) do Inc(J);
         H.OrigPoint := StoI(Copy(S, I, J));
       end;
     F.Position := O;
  end;

begin
  F := TDosStream.Create(NetPath+Nm, stRead);
  if F.Status <> stOK then
    begin
  1:
      F.Free;
      Exit;
    end;
  F.Read(H, SizeOf(H)); if F.Status <> stOK then Goto 1;
  if H.Attr and 8 = 0 then TNm := Get0(H.T_Name)
                      else TNm := '';
  if ConvertAt then DoConvert(TNm);
  if (PosChar('@', TNm) > 0) or (UpperCase(TNm)='UUCP') then
    begin
      FNm := Get0(H.F_Name);
      if ConvertAt then DoConvert(FNm);
      RRQ := (H.Attr and 4096) <> 0;
      GetZonePoint;
      U := nil;
      for I := 0 to Users.Count-1 do
        begin
          U := Users[I];
          if (UpperCase(U.eMail) = UpperCase(FNm)) or
             (UpperCase(U.Name) = UpperCase(FNm)) and
             (U._Zone = H.OrigZone) and (U._Net = H.OrigNet) and
             (U._Node = H.OrigNode) and (U._Point = H.OrigPoint) then Break;
          U := nil;
        end;
        if U = nil then
        begin
          s := Format('%s (%d:%d/%d.%d) is not defined in the config', [FNm, H.OrigZone, H.OrigNet, H.OrigNode, H.OrigPoint]);
          WriteLn(s);
          Log(s, True);
        end else
        begin
          Log('Sending message from '+U.eMail+' to '+TNm, True);
          BytesToOut := (F.GetSize-2-F.GetPos);
          if SendMsg then
            begin
              Inc(U.BytesOut, BytesToOut);
              Inc(U.MsgOut);
              U.Modified := True;
              F.Free;
              DeleteFile(NetPath + Nm);
              Exit;
            end;
        end;
    end;
  F.Free;
end;


procedure ScanNetmail;
  var SR: TSearchRec;
      J, K: Integer;
      I: LongInt;
begin
  if NetPath[Length(NetPath)] <> '\' then AddStr(NetPath, '\');
  K := 1;
  if FindFirst(NetPath + '*.msg', $3F, SR) = 0 then
  repeat
    Write(#13, K, '  ');
    I := StoI(Copy(SR.Name, 1, Length(SR.Name)-4));
    if I > 0 then
      begin
        if MaxMsg < I then MaxMsg := I;
        DoMsg(SR.Name);
        Inc(K);
      end;
  until FindNext(SR) <> 0;
  FindClose(SR);
end;

end.
