//////////////////////////////////////////////////////////////////////////
//
//  IGATOR Copyright (C) 1997-98 RIT Research Labs
//
//  This programs is free for commercial and non-commercial use as long as
//  the following conditions are aheared to.
//
//  Copyright remains RIT Research Labs, and as such any Copyright notices
//  in the code are not to be removed. If this package is used in a
//  product, RIT Research Labs should be given attribution as the RIT Research
//  Labs of the parts of the library used. This can be in the form of a textual
//  message at program startup or in documentation (online or textual)
//  provided with the package.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//
//  1. Redistributions of source code must retain the copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. All advertising materials mentioning features or use of this software
//     must display the following acknowledgement:
//     "Based on IGATOR by RIT Research Labs."
//
//  THIS SOFTWARE IS PROVIDED BY RIT RESEARCH LABS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//  DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
//  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
//  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
//  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
//  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
//  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//  The licence and distribution terms for any publically available
//  version or derivative of this code cannot be changed. i.e. this code
//  cannot simply be copied and put under another distribution licence
//  (including the GNU Public Licence).
//
//////////////////////////////////////////////////////////////////////////

unit Logger;

interface

procedure Log(S: String; Screen: Boolean);

implementation
uses Windows, SysUtils, Utils, Config;


procedure Log;
  label 1;
  var F: Text;
      I: Integer;
      DW: Word;
begin
 1:
  if LogFile = '' then LogFile := 'IGator.Log';
  Assign(F, LogFile);
  I := IoResult;
  Append(F); if IOResult <> 0 then Rewrite(F);
  if (IOResult <> 0) then
   if (LogFile <> 'IGator.Log') then
    begin
      WriteLn(#7'WARNING: Could not use the Log file defined, using IGator.Log');
      LogFile := '';
      Goto 1;
    end else
    begin
      WriteLn(#7'ERROR: Could not open the Log file');
      Halt(1);
    end;
  while Pos(#13, S) > 0 do S[Pos(#13, S)] := ' ';
  while Pos(#10, S) > 0 do S[Pos(#10, S)] := ' ';
  while Pos('  ', S) > 0 do Delete(S, Pos('  ', S), 1);
  if S[1] = ' ' then Delete(S, 1, 1);
  if Screen then WriteLn(S);
  S := Format('%s  %s', [FormatDateTime('dd-mmm-yyyy, hh:mm:ss', Now), S]);
  WriteLn(F, S);
  Close(F);
end;

const
  CMonths = 'JanFebMarAprMayJunJulAugSepOctNovDec';
  Months: string[Length(CMonths)] = CMonths;

function MonthE(m: Integer): string;
begin
  Result := Copy(Months, 1+(m-1)*3, 3);
end;

procedure SetNormalMonths;
var
  i: Integer;
begin
  for i := 1 to 12 do ShortMonthNames[i] := MonthE(i);
end;

initialization
  SetNormalMonths;
end.

