//////////////////////////////////////////////////////////////////////////
//
//  IGATOR Copyright (C) 1997-98 RIT Research Labs
//
//  This programs is free for commercial and non-commercial use as long as
//  the following conditions are aheared to.
//
//  Copyright remains RIT Research Labs, and as such any Copyright notices
//  in the code are not to be removed. If this package is used in a
//  product, RIT Research Labs should be given attribution as the RIT Research
//  Labs of the parts of the library used. This can be in the form of a textual
//  message at program startup or in documentation (online or textual)
//  provided with the package.
//
//  Redistribution and use in source and binary forms, with or without
//  modification, are permitted provided that the following conditions are
//  met:
//
//  1. Redistributions of source code must retain the copyright
//     notice, this list of conditions and the following disclaimer.
//  2. Redistributions in binary form must reproduce the above copyright
//     notice, this list of conditions and the following disclaimer in the
//     documentation and/or other materials provided with the distribution.
//  3. All advertising materials mentioning features or use of this software
//     must display the following acknowledgement:
//     "Based on IGATOR by RIT Research Labs."
//
//  THIS SOFTWARE IS PROVIDED BY RIT RESEARCH LABS "AS IS" AND ANY EXPRESS
//  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
//  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//  DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
//  ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
//  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
//  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
//  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
//  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//  The licence and distribution terms for any publically available
//  version or derivative of this code cannot be changed. i.e. this code
//  cannot simply be copied and put under another distribution licence
//  (including the GNU Public Licence).
//
//////////////////////////////////////////////////////////////////////////

program IGator;

uses
  Classes,
  Windows,
  SysUtils,
  _Out in '_Out.Pas',
  _In in '_in.pas',
  Config in 'Config.pas',
  Utils in 'Utils.pas',
  _Pop in '_pop.pas',
  IniFiles,
  ShellAPI,
  SendMail in 'SendMail.pas';


var
  DoPop: Boolean;

procedure Help;
begin
  WriteLn('Starting Help engine');
  ShellExecute(0, { handle to parent window }
               nil,    { pointer to string that specifies operation to perform }
               'IGATOR.HLP',
               nil,    { pointer to string that specifies executable-file parameters }
               nil,    { pointer to string that specifies default directory }
               SW_SHOWNORMAL);

  Halt;
end;

procedure Usage;
begin
  WriteLn('Usage: Igator [POP|REG|/?');
  WriteLn(' POP - checks all POP3 servers metioned in the configuration file');
  WriteLn(' REG - register your version of IGATOR');
  WriteLn('  /? - Run IGATOR Help');
  Halt;
end;

procedure ProcessKeys;
var
  p: string;
begin
  p := UpperCase(ParamStr(1));
  if p = 'POP' then DoPop := True else
  if p = '/?' then Help else
  if p = '/H' then Help else
    Usage;
end;


begin
  WriteLn(XLogo);
  WriteLn('Copyright (C) 1997-98 RIT Research Labs');
  case ParamCount of
    0 : ;
    1 : ProcessKeys;
    else Halt;
  end;
  Users := TList.Create;
  ReadIni;
  if DoPop then
    begin
      CheckPop;
    end else
    begin
      WriteLn('Scanning Netmail...');
      ScanNetmail;
      WriteLn(#13#10'Scanning Mail Boxes...');
      ScanBoxes;
    end;
  UpdateIni;
end.
