/*
 *  server.c -- Handles inbound connections
 *
 *  server.c is a part of binkd project
 *
 *  Copyright (C) 1996-1997  Dima Maloff, 5047/13
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version. See COPYING.
 */

/*
 *  $Id: server.c,v 1.8 1997/10/23 03:39:42 mff Exp mff $
 *
 *  $Log: server.c,v $
 * Revision 1.8  1997/10/23  03:39:42  mff
 * DUP() removed
 *
 * Revision 1.7  1997/06/16  05:41:14  mff
 * Added exit(3) on config change.
 *
 * Revision 1.6  1997/03/09  07:14:49  mff
 * Now we use HOSTNAME()
 *
 * Revision 1.5  1997/02/07  06:42:59  mff
 * Under UNIXs SIGHUP forces binkd to restart
 *
 * Revision 1.4  1997/02/01  05:55:24  mff
 * Changed SIGCHLD support
 *
 * Revision 1.2  1996/12/14  07:10:52  mff
 * We now use branch(). Listening changed.
 */

#include <sys/types.h>
#if !defined(NT) && !defined(W95)
#include <sys/time.h>
#endif
#include <sys/stat.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#ifdef HAVE_FORK
#include <signal.h>
#elif defined(HAVE_THREADS)
#include <dos.h>
#include <process.h>
#else
#error Must define either HAVE_FORK or HAVE_THREADS!
#endif

#include "Config.h"
#include "iphdr.h"
#include "iptools.h"
#include "tools.h"
#include "readcfg.h"
#include "protocol.h"
#include "server.h"
#include "sys.h"
#include "assert.h"

int n_servers = 0;

#ifdef HAVE_FORK

static void chld (int signo)
{
  --n_servers;
#include "reapchld.inc"
}

#endif

void serv (void *arg)
{
  int h = *(int *) arg;
  extern int pidcmgr;

  pidcmgr = 0;
  protocol (h, 0);
  Log (5, "downing server...");
  soclose (h);
  free (arg);
#ifdef HAVE_THREADS
  --n_servers;
#endif
}

SOCKET sockfd = -1;
time_t config_time = 0;
extern int checkcfg_flag;	       /* exit(3) on config change */

int checkcfg ()
{
  struct stat sb;
  extern char *config;

  if (stat (config, &sb) == 0)
  {
    if (config_time == 0)
    {
      config_time = sb.st_mtime;
    }
    else if (config_time != sb.st_mtime)
    {
      soclose (sockfd);
      Log (2, "%s changed! exit(3)...", config);
      exit (3);
    }
  }
  return 0;
}

void servmgr (void *arg)
{
  SOCKET new_sockfd;
  int pid;
  int client_addr_len;
  struct sockaddr_in serv_addr, client_addr;
  int opt = 1;

  Log (4, "servmgr started");

  /* Store initial value for Binkd config's mtime */
  checkcfg ();

#ifdef HAVE_FORK
  signal (SIGCHLD, chld);
#endif

  if ((sockfd = socket (AF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET)
    Log (0, "socket: %s", TCPERR ());

  if (setsockopt (sockfd, SOL_SOCKET, SO_REUSEADDR,
		  (char *) &opt, sizeof opt) == SOCKET_ERROR)
    Log (1, "setsockopt (SO_REUSEADDR): %s", TCPERR ());

  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = htonl (INADDR_ANY);
  serv_addr.sin_port = htons ((unsigned short) iport);

  if (bind (sockfd, (struct sockaddr *) & serv_addr, sizeof (serv_addr)) != 0)
    Log (0, "bind: %s", TCPERR ());

  listen (sockfd, 5);

  for (;;)
  {
    client_addr_len = sizeof (client_addr);
    if ((new_sockfd = accept (sockfd, (struct sockaddr *) & client_addr,
			      &client_addr_len)) == INVALID_SOCKET)
    {
      if (TCPERRNO != EINVAL && TCPERRNO != EINTR)
	Log (1, "accept: %s", TCPERR ());
    }
    else
    {
      Log (3, "incoming from %s", get_hostname (&client_addr));

      /* Test config mtime */
      if (checkcfg_flag)
	checkcfg ();

      /* Creating a new process for the incoming connection */
      ++n_servers;
      if ((pid = branch (serv, (void *) &new_sockfd, sizeof (new_sockfd))) < 0)
      {
	--n_servers;
	Log (0, "cannot branch out");
      }
      else
      {
	Log (5, "started server #%i, id=%i", n_servers, pid);
#ifdef HAVE_FORK
	soclose (new_sockfd);
#endif
      }
    }
  }
}
