/* xxkb  - XKB keyboard indicator/switcher */
/* (c)  1999 Ivan Pascal <pascal@tsu.ru>   */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/XKBlib.h>
#include <X11/Xlibint.h>

#include "wlist.h"
#include "xxkb.h"

#define	NAME	"XXkb"
#define BASE(w)	(w & base_mask)

Display *dpy; int scr;
GC gc;
XkbEvent ev;

#ifdef XT_RESOURCE_SEARCH
#include <X11/IntrinsicP.h>
static XtAppContext app_cont;
#endif

Window root, MainWin, icon, win, focused, base_mask;
int revert, grp;
XWMHints *wm_hints;
XSizeHints *size_hints;
XClassHint class_hints;
char *name=NAME;
XFocusChangeEvent focused_event;

WInfo def_info, *info, *tmp_info;
kbdState def_state;

Bool When_start, When_create, When_change, Focus_out, Two_state,
     Button_enable, Main_enable, WMaker, Button_delete, Bell_enable,
     Ignore_reverse,
     fout_flag = False;
int Base_group, Alt_group, Bell_percent;
SearchList *Wm_nameList, *Wm_classNameList, *Wm_classClassList;
XImage *pictures[MAX_GROUP*2];
extern Geometry but_geom, main_geom;

static Boolean CheckIgnore(Window w);

int main (int argc, char ** argv)
{
  int xkbEventType, xkbError, reason_rtrn;

/* Lets begin */
  dpy = XkbOpenDisplay( "", &xkbEventType, &xkbError,
			  NULL, NULL, &reason_rtrn); 
  if (!dpy) {puts("Can' connect to X-server"); exit(-1);}
    
  scr = DefaultScreen(dpy);
  root = RootWindow(dpy, scr);
  base_mask = ~(dpy->resource_mask);

  focused_event.type = FocusIn;
  focused_event.display = dpy;

/* My configuration*/

#ifdef XT_RESOURCE_SEARCH
  app_cont = XtCreateApplicationContext();
  XtDisplayInitialize(app_cont, dpy, name, name, NULL, 0, &argc, argv);
#endif
  GetConfig(dpy);
    
/* My MAIN window */
  if (main_geom.mask & (XNegative|YNegative)) {
    int x,y; unsigned int width, height, bord, dep;
    Window rwin;
    XGetGeometry(dpy, root, &rwin,
	     &x, &y, &width, &height, &bord, &dep);
    if (main_geom.mask & XNegative)
       main_geom.x = width + main_geom.x - main_geom.width;
    if (main_geom.mask & YNegative)
       main_geom.y = height + main_geom.y - main_geom.height;
  }

  MainWin = XCreateSimpleWindow( dpy, root,
				main_geom.x, main_geom.y,
				main_geom.width, main_geom.height, 0,
				BlackPixel(dpy, scr),
				WhitePixel(dpy, scr));
    
  wm_hints = XAllocWMHints();
  wm_hints->window_group = MainWin;
  wm_hints->input = False;
  wm_hints->flags = InputHint | WindowGroupHint;
  XSetWMHints(dpy, MainWin, wm_hints);
  XStoreName(dpy, MainWin, name);

  class_hints.res_name  = name;
  class_hints.res_class = name;
  XSetClassHint(dpy, MainWin, &class_hints);
  XSetCommand(dpy, MainWin, argv, argc);
  
  if (main_geom.mask & (XValue|YValue)) {
    size_hints = XAllocSizeHints();
    size_hints->x = main_geom.x;
    size_hints->y = main_geom.y;
    size_hints->flags = USPosition;
    XSetNormalHints(dpy, MainWin, size_hints);
  }

/* Show window ? */
  if (WMaker) {
    icon = XCreateSimpleWindow( dpy, MainWin,
				main_geom.x, main_geom.y,
				main_geom.width, main_geom.height, 0,
				BlackPixel(dpy, scr),
				WhitePixel(dpy, scr));

    wm_hints->icon_window  = icon;
    wm_hints->initial_state = WithdrawnState;
    wm_hints->flags = wm_hints->flags | StateHint | IconWindowHint;
    XSetWMHints(dpy, MainWin, wm_hints);
  }
  else icon = NULL;
  
  if (Main_enable) XMapWindow(dpy, MainWin);

/* What events we want */
  XkbSelectEventDetails(dpy, XkbUseCoreKbd, XkbStateNotify, 0xFFF,
			      XkbGroupStateMask);
  if (When_create)
    XSelectInput(dpy, root, SubstructureNotifyMask);

  XSelectInput(dpy, MainWin, ExposureMask | ButtonPressMask);
  if (icon) XSelectInput(dpy, icon, ExposureMask | ButtonPressMask);

  getGC(MainWin, &gc);

/* set current defaults */
  def_state.group = Base_group;
  def_state.alt = Alt_group;  

  def_info.win = icon ? icon : MainWin;
  def_info.button = 0;
  def_info.state.group = Base_group;
  def_info.state.alt = Alt_group;

  Reset();

  if (When_start) {
    Window rwin, parent, *childrens, *child, app; int num; 
    XQueryTree(dpy, root, &rwin, &parent, &childrens, &num);
    child = childrens;
    while (num) {
      app = NULL;
      GetAppWindow(*child, &app);
      if (app) AddWindow(app, *child);
      child++; num--;
    }
    if (childrens) XFree(childrens);
    XGetInputFocus(dpy, &focused, &revert);
    info = win_find(focused);
    if (!info) info = &def_info;
  }

/* Main Loop */
  while (1) {
    XNextEvent(dpy, &ev.core);

    if (ev.type == xkbEventType){
      switch (ev.any.xkb_type) { 
        case XkbStateNotify :
          grp = ev.state.locked_group;

	  if (When_change && !fout_flag) {
	    XGetInputFocus(dpy, &focused, &revert);
            if((focused == None) || (focused == PointerRoot))
               break;
 	    if (focused != info->win) {
	      tmp_info = AddWindow(focused, focused);
	      if (tmp_info) {
	        info = tmp_info; info->state.group = grp;
	      }
	    }
	  }
	  fout_flag = False;
	  
          if (Two_state && ev.state.keycode) {
            int g_min, g_max;
            if (Base_group < info->state.alt) {
	      g_min = Base_group; g_max = info->state.alt;
	    }
	    else { g_max = Base_group; g_min = info->state.alt;}
 	    if ((grp > g_min) && (grp < g_max)) {
	      XkbLockGroup(dpy, XkbUseCoreKbd, g_max);
	      break;
	    }
	    if ((grp < g_min) || (grp > g_max)) {
	      XkbLockGroup(dpy, XkbUseCoreKbd, g_min);
	      break;
	    }
	  }
          info->state.group = grp;
	  if (Two_state && (grp != Base_group) && (grp != info->state.alt))
	    info->state.alt = grp;

	  if(info->button)
	    update_button(info->button, gc, grp);
	  update_window(MainWin, gc, grp);
	  if (icon) update_window(icon, gc, grp);
          if (Bell_enable)
            XBell(dpy, Bell_percent);
	  break;
	default: break;
      }
    } /* xkb events */
    else
      switch (ev.type) {          /* core events */
	case Expose:	/* Update our window or button */
	  if (ev.core.xexpose.count != 0) break;
	  win = ev.core.xexpose.window;
	  if ((win == MainWin) || (icon && (win == icon)))
	    update_window(win, gc, info->state.group);
	  else {
	    tmp_info = button_find(win);
	    if (tmp_info) update_button(win, gc, tmp_info->state.group);
	  }
	  break;
	case ButtonPress:
	  win = ev.core.xbutton.window;
	  switch (ev.core.xbutton.button) {
	    case Button1:
	      if ((win == info->button) || (win == MainWin) ||
		  (icon && (win == icon))) {
	        if (Two_state) {
	          if (info->state.group == Base_group)
	            XkbLockGroup(dpy, XkbUseCoreKbd, info->state.alt);
	          else
	            XkbLockGroup(dpy, XkbUseCoreKbd, Base_group);
	        }
	        else
	          XkbLockGroup(dpy, XkbUseCoreKbd, info->state.group + 1);
	      }
	      break;
	    case Button3:
	      if ((win == info->button) || (win == MainWin) ||
		  (icon && (win == icon))) {
	        XkbLockGroup(dpy, XkbUseCoreKbd, info->state.group + 1);
	      }
	      break;
	    case Button2:
	      if ((win != MainWin) && (win != icon)){
	      	if (Button_delete) {
	      	  XDestroyWindow(dpy,win);
	      	}
	        break;
	      }
	      win_free_list();
	      XFreeGC(dpy,gc);
	      if (icon) XDestroyWindow(dpy, icon);
	      XDestroyWindow(dpy,MainWin);
#ifdef XT_RESOURCE_SEARCH
	      XtCloseDisplay(dpy);
#else
	      XCloseDisplay(dpy);
#endif
	      exit(0);
	  }
	  break;
	case FocusIn:
	  info = win_find(ev.core.xfocus.window);
	  if (!info) {
	    printf ("Oops. FocusEvent from unknown window\n");
	    info = &def_info;
	  }
	  XkbLockGroup(dpy, XkbUseCoreKbd, info->state.group);
	  break;
	case FocusOut:
	  if (Focus_out) {
	    tmp_info = info;
	    info = &def_info;
	    info->state.group = Base_group; /*???*/
	    if (tmp_info->state.group != Base_group) {
	      fout_flag = True;
	      XkbLockGroup(dpy, XkbUseCoreKbd, info->state.group);
	    }
	  }
	  break;
        case ReparentNotify:
          win = ev.core.xreparent.window;
//printf("Event win %x parent %x, focused %x\n", win, ev.core.xreparent.parent);
          if( win == MainWin ||
             ev.core.xreparent.parent == root ||
             BASE(ev.core.xreparent.parent) == BASE(win) ) break;

          AddWindow(win, ev.core.xreparent.parent);
          break;
        case DestroyNotify:
          if (ev.core.xdestroywindow.event == root) break;

	  win = ev.core.xdestroywindow.window;
//printf("DestroyNotyfy win %x\n", win);
	  tmp_info= win_find(win);
	  if (tmp_info) {
	    win_free(win);
	    if (tmp_info == info) Reset();
	    break;
	  }

	  tmp_info = button_find(win);
	  if (tmp_info) tmp_info->button = 0;
          break;
        case CreateNotify:
        case UnmapNotify:
        case MapNotify:
        case MappingNotify:
        case ConfigureNotify:
        case GravityNotify:
          break;  /* Ignore this events */
	default:
	  printf("Unknown event %d\n", ev.type);
          break;
    }
  }
    return(0);
}

void Reset()
{
  info = &def_info;
  XkbLockGroup(dpy, XkbUseCoreKbd, Base_group);
}
void getGC(win, gc)
    Window win;
    GC * gc;
{
    unsigned long valuemask=0; /* No data in ``values'' */
    XGCValues values;
    *gc = XCreateGC(dpy, win, valuemask, &values);
/*	XSetForeground(dpy, *gc, BlackPixel(dpy, scr)); */
}

void update_window(win, gc, group)
Window win; GC gc; int group;
{
  if (pictures[group])
    XPutImage(dpy, win, gc, pictures[group],
		0, 0, 0, 0, main_geom.width, main_geom.height);
}

void update_button(win, gc, group)
Window win; GC gc; int group;
{
  if (pictures[group+4])
    XPutImage(dpy, win, gc, pictures[group + 4],
		0, 0, 0, 0, but_geom.width, but_geom.height);
}

WInfo* AddWindow(win, parent)
Window win, parent;
{
  WInfo *info;

  if (CheckIgnore(win) != Ignore_reverse)
     return NULL;

  info = win_find(win);
  if (!info) {
    info = win_add(win, &def_state);
    if (!info) return NULL;
    XGetInputFocus(dpy, &focused, &revert);
    XSelectInput(dpy, win, FocusChangeMask | StructureNotifyMask);
    if (focused == win) {
       focused_event.window = win;
       XPutBackEvent(dpy, (XEvent *) &focused_event);
    }
  }
  if (Button_enable && (!info->button))
    info->button = MakeButton(parent);
  return info;
}

Window MakeButton(parent)
Window parent;
{
  Window button, rwin;
  int x, y; unsigned int width, height, bord, dep;
  XSetWindowAttributes attr;

  parent = GetGrandParent(parent);

  if (but_geom.mask & (XNegative|YNegative))
    XGetGeometry(dpy, parent, &rwin,
		 &x, &y, &width, &height, &bord, &dep);
  x = (but_geom.mask & XNegative)?
      width + but_geom.x - but_geom.width : but_geom.x;
  y = (but_geom.mask & YNegative)?
      height + but_geom.y - but_geom.height : but_geom.y;

  if ((but_geom.width > width) || (but_geom.height > height)) return 0 ;

  button = XCreateSimpleWindow( dpy, parent,
			   x, y, but_geom.width, but_geom.height, 0,
			   BlackPixel(dpy, scr), WhitePixel(dpy, scr));

  attr.override_redirect = True;
  attr.win_gravity = but_geom.gravity;

  XChangeWindowAttributes(dpy, button, CWWinGravity|CWOverrideRedirect, &attr);
  XSelectInput(dpy, button,
	ExposureMask | ButtonPressMask | StructureNotifyMask);
  XMapWindow(dpy, button);
  return button;
}

Window GetGrandParent(w)
Window w;
{  Window rwin, parent, *child; int num;

  while (1) {
   XQueryTree(dpy, w, &rwin, &parent, &child, &num);
   if (child) XFree(child);
   if (parent == rwin) return w;
   w = parent;
  }
}

void GetAppWindow(win, core)
Window win, *core;
{ Window rwin, parent, *childrens, *child; int n;
  if (!XQueryTree(dpy, win, &rwin, &parent, &childrens, &n)) return;
  child = childrens;
  while(n) {
    if (BASE(*child) != BASE(win)) {
      *core = *child;
      break;
    }
    GetAppWindow(*child, core);
    if (*core) break;
    child++; n--;
  }
  if (childrens) XFree(childrens);
}

static
Boolean Compare(char *pattern, char *str)
{
  char *i = pattern, *j = str, *sub, *lpos;
  Boolean aster = False; 

   do {
     if ( *i == '*'){ 
       i++;
       if(*i == '\0') return True;
       aster = True; sub = i; lpos = j;
       continue;
     }
     if (*i == *j) {
       i++; j++;
       continue;
     }
     if (*j == '\0')
       return False;

     if (aster) {
       j = ++lpos;
       i = sub;
     } else {
       return False;
     }
   } while (*j || *i);

   return ((*i == *j) ? True : False);
}

static
Boolean searchInList(SearchList *list, char *str)
{
    int i;

    for (i = 0; i < list->num; i++){
      if( Compare(list->idx[i], str))
         return True;
    }
    return False;
}

static
Boolean CheckIgnore(Window w)
{
  Boolean ret;
  XClassHint wm_class;
  char *name;

  if( XGetClassHint(dpy, w, &wm_class)){
     ret = searchInList(Wm_classNameList, wm_class.res_name);
     if (!ret)
        ret = searchInList(Wm_classClassList, wm_class.res_class);
     Xfree(wm_class.res_name);
     Xfree(wm_class.res_class);
     if (ret)
        return ret;
  }

  XFetchName(dpy, w, &name);
  if(name == NULL)
     return False;
  ret = searchInList(Wm_nameList, name);
  Xfree(name);
  return ret;
}
