#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/Xutil.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "wlist.h"
#include "xxkb.h"
#include "resource.h"

#ifdef XT_RESOURCE_SEARCH
#include <X11/IntrinsicP.h>
#endif

char *XpmResMain[] = {S_MAIN_XPM1, S_MAIN_XPM2,
		      S_MAIN_XPM3, S_MAIN_XPM4};
char *XpmResBut[]  = {S_BUT_XPM1, S_BUT_XPM2,
		      S_BUT_XPM3, S_BUT_XPM4};
char *XpmDefMain[] = {D_MAIN_XPM_1, D_MAIN_XPM_2,
		      D_MAIN_XPM_3, D_MAIN_XPM_4};
char *XpmDefBut[]  = {D_BUT_XPM_1, D_BUT_XPM_2,
		      D_BUT_XPM_3, D_BUT_XPM_4};
LookupTab GravityTab[] = {
		{"NorthEast", 9, NorthEastGravity},
		{"NorthWest", 9, NorthWestGravity},
		{"North",     5, NorthGravity},
		{"SouthEast", 9, SouthEastGravity},
		{"SouthWest", 9, SouthWestGravity},
		{"South",     5, SouthGravity},
		{"East",      4, EastGravity},
		{"West",      4, WestGravity},
		{"Center",    6, CenterGravity},		
		{NULL, NULL, NULL}};

void err_malloc(void);
#define ERR_MALLOC	err_malloc()

extern Bool When_create, When_change, Focus_out, Two_state,
	    Button_enable, Main_enable, WMaker, Button_delete,
	    When_start, Bell_enable, Ignore_reverse;

extern int Base_group, Alt_group, Bell_percent;

extern SearchList *Wm_nameList, *Wm_classNameList, *Wm_classClassList;

extern XImage *pictures[];
Geometry but_geom = { XNegative, D_BUT_X, D_BUT_Y,
	      	    D_BUT_WIDTH, D_BUT_HEIGHT, D_BUT_GRAVITY},
 	 main_geom = {0, 0, 0, D_MAIN_WIDTH, D_MAIN_HEIGHT, 0};

void ParseConfig(db, class, prefix, name, type, def_val, value)
XrmDatabase db;
char *class, *prefix, *name, *def_val;
int type;
void *value;
{
  XrmValue val; char *type_ret, *fullname, *s; Bool res = False;

  if (db) {
     fullname = malloc(strlen(prefix) + strlen(name) + 1);
     if(!fullname) ERR_MALLOC;
     sprintf(fullname, "%s%s", prefix, name);
     res = XrmGetResource(db, fullname, class, &type_ret, &val);
     free(fullname);
  }
  
  if (!res) val.addr = def_val;
  switch (type) {
  case T_string:
    *((char **)value) = malloc(strlen(val.addr)+1);
    if (!*((char**)value)) ERR_MALLOC;
    strcpy(*((char**)value), val.addr);
    break;
  case T_bool:
    for (s = val.addr; *s; s++) if(isupper(*s)) *s = tolower(*s);
    *((Bool *)value) = (!strncmp(val.addr, "true", 4) ||
			!strncmp(val.addr, "yes",  3) ||
              		!strncmp(val.addr, "on",   2))? True : False;
    break;
  case T_int:
    *((int *)value) = atoi(val.addr);
  }
}

static
SearchList* MakeSearchList(char *str)
{
  int len = strlen(str), count = 0;
  char *i, *j;
  SearchList *ret;

  ret = malloc(sizeof(SearchList));
  if (!ret) ERR_MALLOC;
  ret->num = 0;
  ret->idx = NULL;
  ret->list = NULL;
  if (!len) return ret;

  ret->list = malloc(len+1);
  if (!ret->list) ERR_MALLOC;

  i = str; j = ret->list;
  while (len) {
     count++;
     while((*i != ' ') && (*i != '\t')){
        *j++ = *i++;
        if (!(--len)) {
          *j = '\0';
          break;
        }
     }
     *j++ = '\0';
     while((*i == ' ') || (*i == '\t')){
        i++;
        if (!(--len)) break;
     }
  }
  ret->num = count;

  ret->idx = malloc(count * sizeof(char*));
  if (!ret->list) ERR_MALLOC;

  for (count = 0, i = ret->list; count < ret->num; count++){
     ret->idx[count] = i;
     while(*i++);
  }

  return ret;
}

void GetConfig(Display *dpy)
{
  XrmDatabase db; char *name, *path, *filename; int i;
  
  XrmInitialize();

#ifdef XT_RESOURCE_SEARCH
  filename = XtResolvePathname(dpy, "app-defaults", NULL, NULL, NULL, NULL, 0, NULL);
#else
  filename = malloc(strlen(APPDEFDIR) + strlen(APPDEFFILE) + 2);
  if (!filename) ERR_MALLOC;
  sprintf(filename,"%s/%s", APPDEFDIR, APPDEFFILE);
#endif
  db = XrmGetFileDatabase(filename);
  free(filename);

  path = getenv("HOME");
#ifdef XT_RESOURCE_SEARCH
  filename = XtResolvePathname(dpy, path, USERDEFFILE, NULL,
             "%T/%L/%N%C:%T/%l/%N%C:%T/%N%C:%T/%L/%N:%T/%l/%N:%T/%N",
             NULL, 0, NULL);
#else
  filename = malloc(strlen(path) + strlen(USERDEFFILE) + 2);
  if (!filename) ERR_MALLOC;
  sprintf(filename,"%s/%s", path, USERDEFFILE);
#endif
  XrmCombineFileDatabase(filename, &db, True);
  free(filename);

  if (!db) printf("Can't open resource file. Try to use defaults.\n");

  ParseConfig(db, "", S_NAME, S_BUT_ENABLE,  T_bool, D_YES, &Button_enable);
  ParseConfig(db, "", S_NAME, S_MAIN_ENABLE, T_bool, D_YES, &Main_enable);
  ParseConfig(db, "", S_NAME, S_WMAKER,      T_bool, D_NO,  &WMaker);
  
  ParseConfig(db, "", S_NAME, S_CTRL_START,   T_bool, D_YES, &When_start);
  ParseConfig(db, "", S_NAME, S_CTRL_CREATE,  T_bool, D_YES, &When_create); 
  ParseConfig(db, "", S_NAME, S_CTRL_CHANGE,  T_bool, D_NO,  &When_change);
  ParseConfig(db, "", S_NAME, S_CTRL_FOCUS,   T_bool, D_NO,  &Focus_out);
  ParseConfig(db, "", S_NAME, S_CTRL_2_STATE, T_bool, D_YES, &Two_state);
  ParseConfig(db, "", S_NAME, S_CTRL_BUT_DEL, T_bool, D_YES, &Button_delete);
  
  ParseConfig(db, "", S_NAME, S_GROUP_BASE, T_int, "1", &Base_group);
  ParseConfig(db, "", S_NAME, S_GROUP_ALT,  T_int, "2", &Alt_group);
  Base_group--; Alt_group--;

  ParseConfig(db, "", S_NAME, S_BELL, T_bool, D_NO, &Bell_enable);
  ParseConfig(db, "", S_NAME, S_BELL_PER,  T_int, "-50", &Bell_percent);

  /*Load XPMs*/  
  ParseConfig(db, "", S_NAME, S_XPM_PATH, T_string, D_XPM_PATH, &path);
  for(i=0; i<4; i++) {
    ParseConfig(db, "", S_NAME, XpmResMain[i], T_string, XpmDefMain[i], &name);
    if (*name){
      if (*name == '/') load_image(name, i);
      else {
        filename = malloc(strlen(path) + strlen(name) + 2);
	if (!filename) ERR_MALLOC;
        sprintf(filename, "%s/%s", path, name);
        load_image(filename, i);
        free(filename);
      }
    }
    else pictures[i] = NULL;
  }
  if (Button_enable)
    for(i=0; i<4; i++) {
      ParseConfig(db, "", S_NAME,XpmResBut[i],T_string, XpmDefBut[i], &name);
      if (*name){
        if (*name == '/') load_image(name, i+4);
        else {
          filename = malloc(strlen(path) + strlen(name) + 2);
	  if (!filename) ERR_MALLOC;
          sprintf(filename, "%s/%s", path, name);
          load_image(filename, i+4);
          free(filename);
        }
      }
      else pictures[i+4] = NULL;
    }

  /* Parse geometry*/
  ParseConfig(db, "", S_NAME, S_MAIN_GEOM, T_string, D_MAIN_GEOM, &name);
  main_geom.mask = XParseGeometry(name, &main_geom.x, &main_geom.y,
				&main_geom.width, &main_geom.height);
  ParseConfig(db, "", S_NAME, S_BUT_GEOM, T_string, D_BUT_GEOM, &name);
  but_geom.mask = XParseGeometry(name, &but_geom.x, &but_geom.y,
				&but_geom.width, &but_geom.height);

  /* Parse gravity */
  ParseConfig(db, "", S_NAME, S_BUT_GRAV, T_string, D_BUT_GRAV, &name);
  for(i = 0; GravityTab[i].name; i++) {
    if (!strncmp(name, GravityTab[i].name, GravityTab[i].len)){
      but_geom.gravity = GravityTab[i].res;
      break;
    }
  }

  /* build 'ignore lists' */
  ParseConfig(db, "", S_NAME, S_IGN_NAME, T_string, D_EMPTY, &name);
  Wm_nameList = MakeSearchList(name);
  ParseConfig(db, "", S_NAME, S_IGN_CLASS_NAME, T_string, D_EMPTY, &name);
  Wm_classNameList = MakeSearchList(name);
  ParseConfig(db, "", S_NAME, S_IGN_CLASS_CLASS, T_string, D_EMPTY, &name);
  Wm_classClassList = MakeSearchList(name);
  ParseConfig(db, "", S_NAME, S_IGN_REV, T_bool, D_NO, &Ignore_reverse);
}

void err_malloc()
{
  printf("xxkb: ParseConfig: Memory allocation error\n");
  exit(0);
}

#include <X11/xpm.h>
extern Display *dpy;

int load_image(name, index)
char * name;
int index;
{ int res;
  res = XpmReadFileToImage(dpy, name, &pictures[index],
			     NULL, NULL);
  switch (res) {
  case XpmOpenFailed:
    printf("Xpm file open failed: %s\n", name);
    break;
  case XpmFileInvalid:
    printf("Xpm file is invalid: %s\n", name);
    break;
  case XpmNoMemory:
    printf("No memory for open xpm file: %s\n", name);
    break;
  default:
  }
}
