#include "alarm_applet.h"

#ifdef WITH_SOUND
/* 
 * Serperate stuff out in Linus' preferred manner,
 * making sure we don't have any #ifdef's within the
 * actual code
 */

#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <esd.h>





typedef struct _sound_info SoundInfo;

struct _sound_info
{
   int sock_id;
   int sample_id;
   esd_format_t format;
   gboolean playing;
};


static SoundInfo* sound_info = NULL;


void init_sound(void)
{
   FILE* in_file;
   AFfilehandle af_file;
   char buf[ESD_BUF_SIZE];
   /* Need to get these from the file using AudioFile */
   int bits, channels;
   int rate, format;
   int length = 0;
   gchar* filename;
   gchar* ext;
   struct stat stat_info;
   
   if(sound_info != NULL)
	 return;
   
   filename = get_sound_file_name();
   ext = strrchr(filename, '.');
   if(ext  == NULL || strcmp(ext, ".wav"))
	 return;

   
   af_file = afOpenFile(filename, "r", NULL);
   if(!af_file)
	 return;
   
   sound_info = g_new0(SoundInfo, 1);
   
   afGetSampleFormat(af_file, AF_DEFAULT_TRACK, &format, &bits);
   channels = afGetChannels(af_file, AF_DEFAULT_TRACK);
   rate = afGetRate(af_file, AF_DEFAULT_TRACK);
   
   afCloseFile(af_file);
   
   if(bits == 8)
	 sound_info->format |= ESD_BITS8;
   else if(bits == 16)
	 sound_info->format |= ESD_BITS16;
   
   if(channels == 1)
	 sound_info->format |= ESD_MONO;
   else if(channels == 2)
	 sound_info->format |= ESD_STEREO;
   
   in_file = fopen(filename, "r");
   if(!in_file)
	 return;
   
   sound_info->sock_id = -1;
   sound_info->sample_id = -1;
   sound_info->playing = FALSE;
   
   sound_info->sock_id = esd_open_sound(NULL);
   if(sound_info->sock_id <= 0)
   {
	  g_free(sound_info);
	  sound_info = NULL;
	  return;
   }
   
   
   sound_info->format |= ESD_PLAY;
   sound_info->format |= ESD_STREAM;
   
   stat(filename, &stat_info);
   sound_info->sample_id = esd_sample_cache(sound_info->sock_id,
											sound_info->format,
											rate,
											stat_info.st_size,
											filename);
   
   ddebug("Sample id is %d\n", sound_info->sample_id);
   while((length = fread(buf, 1, ESD_BUF_SIZE, in_file)) > 0)
   {
	  if((length = write(sound_info->sock_id, buf, length)) <= 0)
	  {
		 g_free(sound_info);
		 sound_info = NULL;
		 return;
	  }
   }
	
   fclose(in_file);
}


void play_sound_alarm(void)
{
   if(!sound_info)
	 return;

   esd_sample_loop(sound_info->sock_id, sound_info->sample_id);
   sound_info->playing = TRUE;
}


void stop_sound_alarm(void)
{
   if(!sound_info)
	 return;
   
   esd_sample_stop(sound_info->sock_id, sound_info->sample_id);
   sound_info->playing = FALSE;
}


/* Taken from the esd plugin with XMMS */
void change_volume(gint vol)
{
   esd_set_default_sample_pan(sound_info->sock_id, 
							  sound_info->sample_id,
							  vol, vol);
}


void preview_sound_file(gchar* filename)
{
   
   
   
}



void destroy_sound(void)
{
   if(!sound_info)
	 return;
   
   ddebug("destroy_sound\n");
   /* This should stop the sample
	* playing, but it doesn't !!!
	*/
   if(sound_info->playing)
	 /*esd_sample_kill(sound_info->sock_id, sound_info->sample_id);*/
	 esd_sample_stop(sound_info->sock_id, sound_info->sample_id);
   
   if(sound_info->sample_id > 0)
	 esd_sample_free(sound_info->sock_id, sound_info->sample_id);
   
   esd_close(sound_info->sock_id);
   g_free(sound_info);
   sound_info = NULL;
}


void load_new_sound_file(gchar* filename)
{
   char buf[ESD_BUF_SIZE];
   FILE* in_file;
   AFfilehandle af_file;
   int rate, channels, bits;
   int mode = ESD_STREAM, func = ESD_PLAY;
   int length = 0, format;
   struct stat stat_info;
   
   if(!sound_info)
   {
	  sound_info = g_new0(SoundInfo, 1);
	  sound_info->playing = FALSE;
	  sound_info->sample_id = -1;
	  sound_info->sock_id = -1;
	  sound_info->format = 0;
   }
  
   ddebug("loading new sound file %s\n", filename);
   if(sound_info->playing)
   {
	  ddebug("Sample is already playing\n");
	  /*esd_sample_kill(sound_info->sock_id, sound_info->sample_id);*/
	  esd_sample_stop(sound_info->sock_id, sound_info->sample_id);
	  sound_info->playing = FALSE;
   }
   
   esd_sample_free(sound_info->sock_id, sound_info->sample_id);
   sound_info->sample_id = -1;
   esd_close(sound_info->sock_id);
   sound_info->sock_id = esd_open_sound(NULL);
   if(sound_info->sock_id <= 0)
   {
	  g_free(sound_info);
	  sound_info = NULL;
	  ddebug("Can't open esd socket in load_new_sound\n");
	  return;
   }
   
   af_file = afOpenFile(filename, "r", NULL);
   if(!af_file)
   {
	  /* We can't open the new sound file, so clean up all the
	   * sound stuff 
	   */
	  close(sound_info->sock_id);
	  g_free(sound_info);
	  sound_info = NULL;
	  ddebug("Can't open af_file in load_new_sound\n");
	  return;
   }
   
   afGetSampleFormat(af_file, AF_DEFAULT_TRACK, &format, &bits);
   channels = afGetChannels(af_file, AF_DEFAULT_TRACK);
   rate = afGetRate(af_file, AF_DEFAULT_TRACK);
   
   afCloseFile(af_file);
   
   sound_info->format = 0;
   
   if(bits == 8)
	 sound_info->format |= ESD_BITS8;
   else if(bits == 16)
	 sound_info->format |= ESD_BITS16;
   
   if(channels == 1)
	 sound_info->format |= ESD_MONO;
   else if(channels == 2)
	 sound_info->format |= ESD_STEREO;
   
   sound_info->format |= ESD_STREAM;
   sound_info->format |= ESD_PLAY;
   
   in_file = fopen(filename, "r");
   if(!in_file)
	 return;
   
   stat(filename, &stat_info);
   
   sound_info->sample_id = esd_sample_cache(sound_info->sock_id,
											sound_info->format,
											rate,
											stat_info.st_size,
											filename);
   
   ddebug("Sample id is %d\n", sound_info->sample_id);
   while((length = fread(buf, 1, ESD_BUF_SIZE, in_file)) > 0)
   {
	  length = write(sound_info->sock_id, buf, length);
   }
   
   fclose(in_file);
   ddebug("Finished loading new file\n");
}


#else /* NO SOUND SUPPORT */

void init_sound(void)
{
}


void play_sound_alarm(void)
{
}


void stop_sound_alarm(void)
{
}


void destroy_sound(void)
{  
}


void change_volume(gint vol)
{
}


void load_new_sound_file(gchar* filename)
{
}


void preview_sound_file(gchar* filename)
{
}

#endif
