#include "alarm_applet.h"

typedef struct _popup_win PopupWin;

struct _popup_win
{
   GtkWidget* window;
   GtkWidget* scroll_win;
   GtkWidget* frame;
   GtkWidget* clist;
};

static char* tick_xpm[] = 
{
   "10 10 2 1",
   ". c None",
   "# c #000000",
   "..........",
   ".......###",
   "......###.",
   ".....###..",
   "##..###...",
   "######....",
   "..###.....",
   "...#......",
   "..........",
   ".........."
};


static GdkPixmap* tick_pix = NULL;
static GdkBitmap* tick_mask = NULL;
static PopupWin* popup = NULL;




void destroy_popup(void)
{
   if(popup == NULL)
	 return;
   
   ddebug("Called destroy_popup\n");
   gdk_pointer_ungrab(GDK_CURRENT_TIME);
   gtk_grab_remove(popup->window);
   gtk_widget_hide(popup->window);
   gtk_container_foreach(GTK_CONTAINER(popup->window),
						 (GtkCallback)gtk_widget_destroy, NULL);
   gtk_widget_destroy(popup->window);
   popup->window = NULL;
   g_free(popup);
   popup = NULL;
}


static void question_ok_button_cb(GtkWidget* w, gpointer cbdata)
{
   Alarm* a;
   GtkWidget* dia = (GtkWidget*)cbdata;
   
   a = (Alarm*)gtk_object_get_data(GTK_OBJECT(dia), "alarm");
   if(a)
   {
	  dump_alarm("question_ok_button_cb", a);
	  delete_alarm(a);
   }
   gtk_widget_destroy(dia);
}
   
   
   
static void show_question_dialog(Alarm* a)
{
   GtkWidget* mess_box = gnome_message_box_new(_("The alarm is persistant.\n"
												 "Do you really want to remove it ?"),
											   GNOME_MESSAGE_BOX_QUESTION,
											   GNOME_STOCK_BUTTON_OK,
											   GNOME_STOCK_BUTTON_CANCEL,
											   NULL);
   gtk_object_set_data(GTK_OBJECT(mess_box), "alarm", a);
   gnome_dialog_button_connect(GNOME_DIALOG(mess_box), 0,
							   GTK_SIGNAL_FUNC(question_ok_button_cb),
							   mess_box);
   gnome_dialog_button_connect_object(GNOME_DIALOG(mess_box), 1,
									  GTK_SIGNAL_FUNC(gtk_widget_destroy),
									  GTK_OBJECT(mess_box));
   gtk_widget_show(mess_box);
}
							 
  


static void close_popup_cb(GtkWidget* w, gpointer cbdata)
{
   destroy_popup();
}



static void sub_destroy_alarm_cb(GtkWidget* w, gpointer cbdata)
{
   Alarm* a;
   gint id = atoi((gchar*)cbdata);
   ddebug("Alarm id = \"%d\"\n", id);
   a = find_alarm_with_id(id);
   if(!a)
	 return;
   if(a->persistant)
   {
	  show_question_dialog(a);
   }
   else
   {
	  delete_alarm(a);
   }
   destroy_popup();
}



static void sub_alarm_props_cb(GtkWidget* w, gpointer cbdata)
{
   gint id = atoi((gchar*)cbdata);
   ddebug("Alarm id = \"%d\"\n", id);
   show_alarm_properties(id);
   ddebug("Called sub_alarm_props\n");
   destroy_popup();
}




static gint alarm_select_cb(GtkWidget* w, gint row, gint column, 
			    GdkEventButton* event, gpointer cbdata)
{
   GtkWidget* menu_item;
   GtkWidget* menu;
   gchar* text;
  
   gtk_clist_get_text(GTK_CLIST(w), row, 0, &text);
   ddebug("Selected row %d with alarm id %s\n", row, text);
   
   menu = gtk_menu_new();
   menu_item = gtk_menu_item_new_with_label("Delete");
   gtk_menu_append(GTK_MENU(menu), menu_item);
   gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
					  GTK_SIGNAL_FUNC(sub_destroy_alarm_cb), text);
   gtk_widget_show(menu_item);

   menu_item = gtk_menu_item_new_with_label("Properties");
   gtk_menu_append(GTK_MENU(menu), menu_item);
   gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
					  GTK_SIGNAL_FUNC(sub_alarm_props_cb), text);
   gtk_widget_show(menu_item);
   
    
   gtk_signal_connect_object(GTK_OBJECT(menu), "destroy",
							 GTK_SIGNAL_FUNC(gtk_widget_destroy),
							 GTK_OBJECT(menu));
   gtk_widget_show(menu);
      
   gnome_popup_menu_do_popup(menu, NULL, NULL, event, NULL);
   return TRUE;
}



static gint return_true_cb(GtkWidget* w, gpointer data)
{
   return TRUE;
}


void show_popup_dialog(void)
{
   gchar* col_titles[] = {"ID", "Time", "Type", "Persist"};
   gint x, y;
   gint scr_x, scr_y;
   GtkWidget* window;
   GtkWidget* clist;
   GtkWidget* scroll_win;
   GList* alarms;
   GtkWidget* frame;
   gint row_num  = 0;
   
   if(popup != NULL)
   {
	  return;
   }
   
   ddebug("Called show_popup_dialog\n");
   popup = g_new(PopupWin, 1);
   
   window = gtk_window_new(GTK_WINDOW_POPUP);
   gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, TRUE);
   gtk_window_set_title(GTK_WINDOW(window), "Alarm List");
   
   gdk_window_get_pointer(NULL, &x, &y, NULL);
   
   scr_x = gdk_screen_width();
   scr_y = gdk_screen_height();
   
   if(x + 226 >= scr_x)
	 x -= 226;
   if(y - 103 <= 0)
	 y += 103;
   
   gtk_widget_set_uposition(window, x, y - 103);
   gtk_widget_set_usize(window, 226, 103);
   gtk_widget_show(window);
   
   scroll_win = gtk_scrolled_window_new(NULL, NULL);
   gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scroll_win),
								  GTK_POLICY_AUTOMATIC,
								  GTK_POLICY_ALWAYS);
   gtk_container_set_border_width(GTK_CONTAINER(scroll_win), 1);
   
   clist = gtk_clist_new_with_titles(4, col_titles);
   gtk_signal_connect(GTK_OBJECT(clist), "select_row",
					  GTK_SIGNAL_FUNC(alarm_select_cb), NULL);
   gtk_clist_set_shadow_type(GTK_CLIST(clist), GTK_SHADOW_IN);
   gtk_clist_set_column_width(GTK_CLIST(clist), 0, 15);
   gtk_clist_set_column_width(GTK_CLIST(clist), 1, 50);
   gtk_clist_set_column_width(GTK_CLIST(clist), 2, 60);
   gtk_clist_set_column_width(GTK_CLIST(clist), 3, 20);
   gtk_clist_column_titles_passive(GTK_CLIST(clist));
   gtk_clist_set_selection_mode(GTK_CLIST(clist), GTK_SELECTION_SINGLE);
      

   alarms = get_alarm_list();
   while(alarms)
   {
	  gchar* entry[4];
	  Alarm* alarm = alarms->data;
	  entry[0] = g_strdup_printf("%d", alarm->ref_count);
	  entry[1] = g_strdup_printf("%.2d:%.2d hrs", alarm->hour, alarm->min);
	  switch(alarm->alarm_type)
	  {
		 case ALARM_DIALOG:
		 {
			entry[2] = "Dialog";
		 }
		 break;
		 case ALARM_SOUND:
		 {
			entry[2] = "Sound";
		 }
		 break;
		 case ALARM_VISUAL:
		 {
			entry[2] = "Visual";
		 }
		 break;
		 case ALARM_COMMAND:
		 {
			entry[2] = "Command";
		 }
		 break;
	  }

	  if(alarm->persistant)
		entry[3] =  "Yes";
	  else
		entry[3] = "No";
	  
	  gtk_clist_append(GTK_CLIST(clist), entry);
	  alarms = alarms->next;
   }
   
   gtk_widget_show(clist);
   gtk_container_add(GTK_CONTAINER(scroll_win), clist);
   gtk_widget_show(scroll_win);
   
   frame = gtk_frame_new(NULL);
   gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
   gtk_container_add(GTK_CONTAINER(frame), scroll_win);
   gtk_widget_show(frame);
   gtk_container_add(GTK_CONTAINER(window), frame);
   
   gtk_signal_connect(GTK_OBJECT(scroll_win), "button_press_event",
					  GTK_SIGNAL_FUNC(return_true_cb), NULL);
   gtk_signal_connect(GTK_OBJECT(window), "button_press_event",
					  GTK_SIGNAL_FUNC(close_popup_cb), NULL);
   gdk_pointer_grab(window->window, TRUE,
					GDK_BUTTON_PRESS_MASK |
					GDK_BUTTON_RELEASE_MASK |
					GDK_ENTER_NOTIFY_MASK |
					GDK_LEAVE_NOTIFY_MASK,
					NULL, NULL, GDK_CURRENT_TIME);
   gtk_grab_add(window);
   
   popup->window = window;
   popup->scroll_win = scroll_win;
   popup->clist = clist;
   popup->frame = frame;

}
