/* this file contains code to scale  XImage s */
/* Copyright (C) 1998 Sasha Vasko <sashav@sprintmail.com> */

/* Some pieces of it has been taken from XPM-contrib library for libXPM.
   Following is the original copyright notice : */
/*
 * $Id: xpm-contrib.shar,v 1.3 1994/01/04 10:57:13 lehors Exp $
 * 
 * Copyright 1991 Lionel Mallet
 * 
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appears in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Lionel MALLET not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Lionel MALLET makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * Lionel MALLET DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL Lionel MALLET BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION 
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *  This software is opened and free. Furthermore, everybody is kindly
 * invited to participate to improve it for the benefit of all.
 * Improvements can be new features, bugs fixes and porting issues
 * resolution.
 *
 * Author:  Lionel Mallet, SIMULOG
 */

/*
 * $XConsortium: Graphics.c,v 1.1 90/06/09 20:20:29 dmatic Exp $
 *
 * Copyright 1989 Massachusetts Institute of Technology
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of M.I.T. not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  M.I.T. makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * M.I.T. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
 * BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
 * OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author:  Davor Matic, MIT X Consortium
 */

#include "../../configure.h"
#include "../../include/aftersteplib.h"

/*
   #define LOG1(a)       fprintf( stderr, a );
   #define LOG2(a,b)    fprintf( stderr, a, b );
   #define LOG3(a,b,c)    fprintf( stderr, a, b, c );
   #define LOG4(a,b,c,d)    fprintf( stderr, a, b, c, d );
 */

#define LOG1(a)
#define LOG2(a,b)
#define LOG3(a,b,c)
#define LOG4(a,b,c,d)


#ifdef PAGER_BACKGROUND

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <unistd.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/xpm.h>

#include "../../include/afterstep.h"

#define max(a,b) ((a>=b)?a:b)
#define min(a,b) ((a<=b)?a:b)




extern Display *dpy;

void
ScaleDown (Position * target, Position target_size,
	   Position src_start, Position src_end)
{
  Position trg_first_half_end, src_first_half_end;

  src_first_half_end = (src_start + src_end) >> 1;
  if (target_size > 1)
    {
      trg_first_half_end = target_size >> 1;
      ScaleDown (target, trg_first_half_end, src_start, src_first_half_end);
      ScaleDown (target + trg_first_half_end, target_size - trg_first_half_end,
		 src_first_half_end + 1, src_end);
    }
  else if (target_size == 1)
    *target = src_first_half_end;
}

XImage *
ScaleXImageDownToSize (src, width, height)
     XImage *src;
     Position width, height;
{
  XImage *dst;
  Position x, y;
  Position *x_net, *y_net;

  if (width == 0 || height == 0)
    return NULL;

  dst = XSubImage (src, 0, 0, width, height);
  if (width < src->width || height < src->height)
    {
      /*
         * It would be nice to check if width or height < 1.0 and
         * average the skipped pixels. But, it is slow as it is now.
       */

      x_net = (Position *) safemalloc (sizeof (Position) * width);
      y_net = (Position *) safemalloc (sizeof (Position) * height);

      ScaleDown (x_net, width, 0, src->width - 1);
      ScaleDown (y_net, height, 0, src->height - 1);

      for (y = 0; y < height; y++)
	for (x = 0; x < width; x++)
	  XPutPixel (dst, x, y, XGetPixel (src, x_net[x], y_net[y]));
      free (x_net);
      free (y_net);

    }
  return (dst);
}

XImage *
ScaleXImageToSize (src, width, height)
     XImage *src;
     Dimension width, height;
{
  if (src->width >= width && src->height >= height)
    return ScaleXImageDownToSize (src, width, height);
  return NULL;
}

XImage *
ScaleXImage (src, scale_x, scale_y)
     XImage *src;
     double scale_x, scale_y;
{
  if (scale_x <= 1 && scale_y <= 1)
    return ScaleXImageToSize (src,
			      (Dimension) max (scale_x * src->width, 1),
			      (Dimension) max (scale_y * src->height, 1));
  return NULL;
}

Pixmap
ScalePixmapToWin (Pixmap src, Drawable to_win, unsigned int to_depth)
{
  XImage *srcImage, *trgImage;
  unsigned int src_width, src_height, trg_width, trg_height;
  GC tmp_gc;
  Window root;
  Pixmap trg = 0;

  unsigned int dum;
  int dummy;

  if (src != 0)
    {
      if( XGetGeometry(dpy, src, &root, &dummy, &dummy,
                     &src_width, &src_height, &dum, &dum) == 0 ) return None ;
      if( XGetGeometry(dpy, to_win, &root, &dummy, &dummy,
                        &trg_width, &trg_height, &dum, &dum) == 0 ) return None ;
      if ((srcImage = XGetImage (dpy, src, 0, 0, src_width, src_height, AllPlanes, ZPixmap)) != NULL)
	{
	  trg_width = min (trg_width, src_width);
	  trg_height = min (trg_height, src_height);
	  LOG3 ("\n Source width = %u, height = %u", src_width, src_height)
	    LOG3 ("\n Target width = %u, height = %u", trg_width, trg_height)
	    if ((trgImage = ScaleXImageToSize (srcImage, (Dimension) trg_width, (Dimension) trg_height)) != NULL)
	    {
	      /*GC XCreateGC(display, d, valuemask, values) */
	      if ((trg = XCreatePixmap (dpy, to_win, trg_width, trg_height, to_depth)) != 0)
		{
		  if ((tmp_gc = XCreateGC (dpy, trg, 0, NULL)) != NULL)
		    {
		      XPutImage (dpy, trg, tmp_gc, trgImage, 0, 0, 0, 0, trg_width, trg_height);
		      XFreeGC (dpy, tmp_gc);
		    }
		  else
		    {
		      XFreePixmap (dpy, trg);
		      trg = 0;
		    }
		}
	      XDestroyImage (trgImage);
	    }
	  XDestroyImage (srcImage);
	}
    }
  return trg;
}

#endif /*PAGER_BACKGROUND */
