/******************************************************************************
 *                                                                            *
 * File:   transiso.c         Version  1.13            Date: 1997-06-14       *
 *                                                                            *
 * Copyright (c) 1993-1997 by kosta@kostis.net (Kosta Kostis)                 *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * Function:                                                                  *
 *        - this program creates an 8-bit translation table to Unicode using  *
 *          two character encoding description files with ISO 10646 mnemonics *
 *                                                                            *
 ******************************************************************************
 *                                                                            *
 * History:                                                                   *
 *     1997-06-14: KK V1.13                                                   *
 *        - making use of environment variable TRANS                          *
 *     1996-06-01: KK V1.11                                                   *
 *        - minor changes, including my email address                         *
 *     1995-07-01: KK V1.10                                                   *
 *        - minor changes, including my email address                         *
 *     1994-03-31: KK V1.00                                                   *
 *        - initial coding                                                    *
 *                                                                            *
 *****************************************************************************/

#include <stdio.h>

/******************************************************************************

	General Program Definitions

 *****************************************************************************/

#include "transiso.h"
#include "taberr.h"
#include "tab.h"

/******************************************************************************

	String Support Functions

 *****************************************************************************/

#ifdef	NO_STRDUP
	#include "strdup.c"
#endif

#ifdef	NO_STRUPR
	#include "strupr.c"
#endif

/******************************************************************************

	Character Encoding Description Table Functions

 *****************************************************************************/

#include "readtab.h"

/******************************************************************************

	Character Encoding Translation Table and Output Functions

 *****************************************************************************/

#include "comptran.h"

/******************************************************************************

	Program Parameter Parsing Functions

 *****************************************************************************/

#include "scanflag.h"

/******************************************************************************

	Function:
		display copyright, author and program information

	Parameters:
		none

	Returns:
		nothing

 *****************************************************************************/

void	Hello (void)
{
	fprintf (stderr, MSG_COPYRIGHT) ;
	fprintf (stderr, MSG_VERSION, PRGNAM, VERSION) ;
}

/*****************************************************************************/

int     main
(
	int	argc,
	char	*argv		[]
)
{
	int	rc ;
	char	*SrcTable	[MAX_TABLE_ENTRIES] ;
	static	char	*DstTable	[ISO_TABLE_ENTRIES] ;
	static	ushort	DstCodes	[ISO_TABLE_ENTRIES] ;
	char	SrcName		[MAX_ENC_NAME_LENGTH + 1] ;
	char	DstName		[MAX_ENC_NAME_LENGTH + 1] ;
	char	*SrcComment	[MAX_COMMENTS] ;
	char	*DstComment	[MAX_COMMENTS] ;
	ushort	Result		[MAX_TABLE_ENTRIES] ;

	Hello () ;

	/**********************************************************************

		parse parameters/arguments

	 *********************************************************************/

	rc = ScanFlags (argc, argv) ;
	if (rc != SCN_OK)
	{
		/**************************************************************

			display syntax error message and quit

		 *************************************************************/

		fprintf (stderr, ERR_MSG_SYNTAX, PRGNAM) ;
		return (ERR_SYNTAX) ;
	}

	/**********************************************************************

		try to read character encoding description files

	 *********************************************************************/

	rc = ReadCodeTable (SrcFile, SrcTable, (ushort *) NULL,
		MAX_TABLE_ENTRIES, SrcName, SrcComment, 0) ;
	if (rc != ERR_NONE)
		return (rc) ;

	rc = ReadCodeTable (DstFile, DstTable, DstCodes,
		ISO_TABLE_ENTRIES, DstName, DstComment, 0) ;
	if (rc != ERR_NONE)
		return (rc) ;

	/**********************************************************************

		create translation table

	 *********************************************************************/

	if (TransMake != TRANS_MAKE_NOTHING)
	{
		TransTable (SrcTable, MAX_TABLE_ENTRIES, DstTable,
			ISO_TABLE_ENTRIES, DstCodes, Result) ;
		fprintf (stdout,
			MSG_CREATE, PRGNAM, TabFile, SrcFile, DstFile) ;
	}

	DumpProg (SrcTable, DstTable, DstCodes, TabFile,
		Result, MAX_TABLE_ENTRIES,
		SrcName, DstName, SrcComment, DstComment, TransMake) ;

	if (TableDump)
	{
		DumpCodeTable (stdout, SrcFile,
			SrcTable, (ushort *) NULL, MAX_TABLE_ENTRIES) ;
		DumpCodeTable (stdout, DstFile,
			DstTable, DstCodes, ISO_TABLE_ENTRIES) ;
	}

	/**********************************************************************

		free memory allocated by ReadCodeTable () and quit

	 *********************************************************************/

	FreeCodeTable (SrcTable, MAX_TABLE_ENTRIES) ;
	FreeCodeTable (DstTable, ISO_TABLE_ENTRIES) ;

	return (ERR_NONE) ;
}
