#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <stdio.h>
#include <dirent.h>
#include <unistd.h>
#include <wait.h>
#include <string.h>

/*
   This one is simple. Specify the file/dir you want to scan, and that's it.

   Don't forget that there is a SOPHIE_TIMEOUT - if you plan to scan big directories :)
*/

char sockname[256];
int check(char *path);

int main(int argc, char *argv[])
{
	char path[1024];
	
	if (argc != 3)
	{
		printf("Usage: %s <socket> <path>\n", argv[0]);
		exit(1);
	}
	
	memset(sockname, 0, sizeof(sockname));
	memset(path, 0, sizeof(path));

	strncpy(sockname, argv[1], sizeof(sockname)-1);
	strncpy(path, argv[2], sizeof(path)-1);
	
	strncat(path, "\n", sizeof(path)-1);
	check(path);

	exit(0);

}

int check(char *path)
{
	int sock;
	struct sockaddr_un server;
	char buf[1024];
	int bread;

	/* Create socket */
	sock = socket(AF_UNIX, SOCK_STREAM, 0);
	if (sock < 0)
	{
		perror("socket");
		exit(1);
	}
	/* Connect socket using name specified by command line. */
	server.sun_family = AF_UNIX;
	strcpy(server.sun_path, sockname);

	if (connect(sock, (struct sockaddr *)  &server, sizeof(struct sockaddr_un)) < 0)
	{
		close(sock);
		perror("connect");
		exit(1);
	}

	if (write(sock, path, strlen(path)) < 0)
		perror("write");
	
	memset(buf, 0, sizeof(buf));
	if ((bread = read(sock, buf, sizeof(buf))) > 0)
	{
		if (strchr(buf, '\n'))
			*strchr(buf, '\n') = '\0';

		if (strchr(path, '\n'))
			*strchr(path, '\n') = '\0';

		if (buf[0] == '1')
		{
			char *vname = buf+2;
			printf("FILE/DIRECTORY INFECTED : [%s] (VIRUS: %s)\n", path, vname);
		}
		else if (!strncmp(buf, "-1", 2))
		{
			printf("UNKNOWN STATUS: [%s]\n", path);
		}
		else
		{
			printf("FILE/DIRECTORY OKAY     : [%s]\n", path);
		}
	}
	else
	{
		printf("*** Argh - failed to read response from Sophie\n");
	}

	close(sock);
	return(0);
}
