<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */
?>

<?php
  include("acid_conf.php");
  include("acid_db_common.php");
  include("acid_common.php");
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <TITLE>ACID: Lookup for
     <?php
       echo $ip0.'.'.$ip1.'.'.$ip2.'.'.$ip3.'/'.$netmask;
      ?> 
    </TITLE>
    <LINK rel="stylesheet" type="text/css" href="acid_style.css">
</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">
     <?php
       echo $ip0.'.'.$ip1.'.'.$ip2.'.'.$ip3.'/'.$netmask;
      ?> 
      Lookup</TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>
</TR>
</TABLE>
<P><P>

<?php

function PrintEventsByIP($db, $ip_src0, $ip_src1, $ip_src2, $ip_src3)
{
  /* Jeffs stuff */
  /* Count total events for the given address */
  $event_cnt = EventCntByAddr($db, $ip_src0, $ip_src1, $ip_src2, $ip_src3);

  /* Grab unique alerts and count them */
  $unique_events = UniqueEventCntByAddr($db, $ip_src0, $ip_src1, $ip_src2, $ip_src3, $count);
  $unique_event_cnt = count($unique_events);

 echo '<B>'.$unique_event_cnt.' unique alerts detected among '.$event_cnt.' alerts on '.
       $ip_src0.'.'.$ip_src1.'.'.$ip_src2.'.'.$ip_src3.'/32</B><BR>';
   
  /* Print the Statistics on Each of the Unique Alerts */
  echo '<TABLE BORDER=1>
        <TR>
           <TD CLASS="plfieldhdr">Signature</TD>
           <TD CLASS="plfieldhdr">Total<BR> Occurences</TD>
           <TD CLASS="plfieldhdr">Num of Sensors</TD>
           <TD CLASS="plfieldhdr">First<BR> Occurance</TD>
           <TD CLASS="plfieldhdr">Last<BR> Occurance</TD>
        </TR>';

 for ( $i = 0; $i < $unique_event_cnt; $i++ ) {

$current_event = $unique_events[$i];
//$total = UniqueEventTotalsByAddr($db, $i, $ip_src0, $ip_src1, $ip_src2, $ip_src3, $db);
$total = UniqueEventTotalsByAddr($db, $ip_src0, $ip_src1, $ip_src2, $ip_src3, $current_event);
$num_sensors = UniqueSensorCntByAddr($db, $ip_src0, $ip_src1, $ip_src2, $ip_src3, $current_event);
$start_time = StartTimeForUniqueEventByAddr($db, $ip_src0, $ip_src1, $ip_src2, $ip_src3, $current_event);
$stop_time = StopTimeForUniqueEventByAddr($db, $ip_src0, $ip_src1, $ip_src2, $ip_src3, $current_event);

     /* Print out */ 
     echo '<TR>';
/*     echo '  <TD ALIGN=CENTER><FORM METHOD="post" ACTION="acid_pkt_main.php">
                 <INPUT TYPE=hidden NAME="sig[0]" VALUE="=">
                 <INPUT TYPE=hidden NAME="sig[1]" VALUE="'.$sig_name.'">
                 <INPUT TYPE=hidden NAME="caller" VALUE="stat_alerts">
                 <INPUT TYPE=hidden NAME="num_result_rows" VALUE="-1">
                 <INPUT TYPE=submit NAME="submit" VALUE="'.$sig_name.'">
                 ';*/
     echo "  <TD ALIGN=CENTER> ".BuildSigLookup($unique_events[$i]);
     $tmp_iplookup = 'acid_pkt_main.php?sig%5B0%5D=%3D&sig%5B1%5D='.(rawurlencode($unique_events[$i])).
                     '&num_result_rows=-1&time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=+'.
                     '&submit=Query+DB&current_view=-1&ip_addr_cnt=2'.
                     BuildIPFormVars($ip_src0, $ip_src1, $ip_src2, $ip_src3);

     echo "  <TD ALIGN=CENTER> <A HREF=\"$tmp_iplookup\">$total</A> ";
     echo "  <TD ALIGN=CENTER> $num_sensors ";
     echo "  <TD ALIGN=CENTER> $start_time";
     echo "  <TD ALIGN=CENTER VALIGN=CENTER> $stop_time";
     echo '  </TR>';
}

echo "</TABLE>\n";
}

  /* Connect to the Alert database */
  $db=acid_mysql_connect($alert_host, $alert_port, $alert_user, $alert_password, $alert_dbname);
  mysql_select_db($alert_dbname, $db);

   $tmp_srcdst_iplookup = 'acid_pkt_main.php?sig%5B0%5D=%3D'.
                          '&num_result_rows=-1&time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=+'.
                          '&submit=Query+DB&current_view=-1&ip_addr_cnt=2'.
                          BuildIPFormVars($ip0, $ip1, $ip2, $ip3);

   $tmp_src_iplookup    = 'acid_pkt_main.php?sig%5B0%5D=%3D'.
                          '&num_result_rows=-1&time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=+'.
                          '&submit=Query+DB&current_view=-1&ip_addr_cnt=1'.
                          BuildSrcIPFormVars($ip0, $ip1, $ip2, $ip3);

   $tmp_dst_iplookup    = 'acid_pkt_main.php?sig%5B0%5D=%3D'.
                          '&num_result_rows=-1&time%5B0%5D%5B0%5D=+&time%5B0%5D%5B1%5D=+'.
                          '&submit=Query+DB&current_view=-1&ip_addr_cnt=1'.
                          BuildDstIPFormVars($ip0, $ip1, $ip2, $ip3);
?>

<CENTER>
 <FONT> all alerts with      
     <?php
       echo $ip0.'.'.$ip1.'.'.$ip2.'.'.$ip3.'/'.$netmask;
      ?>  as :</FONT> 
<?php
  echo '
 <A HREF="'.$tmp_src_iplookup.'">source</A> | 
 <A HREF="'.$tmp_dst_iplookup.'">destination</A> | 
 <A HREF="'.$tmp_srcdst_iplookup.'">source/destination</A><BR>';

 $addr = $ip0.'.'.$ip1.'.'.$ip2.'.'.$ip3;

 echo '<FONT>
       lookup (whois) in: 
       <A HREF="http://www.arin.net/cgi-bin/whois.pl?queryinput='.$addr.'">ARIN</A> |
       <A HREF="http://www.ripe.net/cgi-bin/whois?query='.$addr.'">RIPE</A> |
       <A HREF="http://www.apnic.net/apnic-bin/whois.pl?search='.$addr.'">APNIC</A> &nbsp;&nbsp;||&nbsp;
       <A HREF="http://www.samspade.org/t/lookat.cgi?whois=on&ipblock=on&address='.$addr.'">SamSpade</A><BR>';

  echo 'show: 
       <A HREF="acid_stat_ipaddr.php?ip0='.$ip0.'&ip1='.$ip1.'&ip2='.$ip2.'&ip3='.$ip3.
                                    '&netmask='.$netmask.'&action=events">unique alerts</A>
       </FONT>';
?>
 <P>

</CENTER>
<HR>

<FORM METHOD="POST" ACTION="acid_stat_ipaddr.php">

<?
  if ( $debug_mode == 1 )
     echo '<TABLE BORDER=1>
             <TR><TD>action</TD><TD>submit</TD></TR>
             <TR><TD>'.$action.'</TD><TD>'.$submit.'</TD></TR>
           </TABLE>';

  /* Print the Statistics the IP address */
  echo '<CENTER>FQDN: <B>';
  if ( $ip0 != "255" && $ip1 != "255" && $ip2 != "255" && $ip3 != "255" )
        echo gethostbyaddr($ip0.'.'.$ip1.'.'.$ip2.'.'.$ip3);
   else
        echo $ip0.'.'.$ip1.'.'.$ip2.'.'.$ip3.' (Broadcast)';
  
  echo    '</B>
        <TABLE BORDER=1>
        <TR>
           <TD CLASS="plfieldhdr">Num of <BR>Sensors</TD>
           <TD CLASS="plfieldhdr">Occurances <BR>as Src.</TD>
           <TD CLASS="plfieldhdr">Occurances <BR>as Dest.</TD>
           <TD CLASS="plfieldhdr">First<BR> Occurance</TD>
           <TD CLASS="plfieldhdr">Last<BR> Occurance</TD>
        </TR>';

  /* Number of Sensor  */
  $temp = "SELECT distinctrow sid FROM iphdr WHERE ".
          "(ip_src0=".$ip0." AND ip_src1=".$ip1." AND ip_src2=".$ip2." AND ip_src3=".$ip3.") OR ".
          "(ip_dst0=".$ip0." AND ip_dst1=".$ip1." AND ip_dst2=".$ip2." AND ip_dst3=".$ip3.")";
  $result2 = mysql_query($temp, $db);
  $num_sensors = mysql_num_rows($result2);
  mysql_free_result($result2);

  /* Unique instances as Source Address  */
  $temp = "SELECT sid from iphdr WHERE ".
         "(ip_src0=".$ip0." AND ip_src1=".$ip1." AND ip_src2=".$ip2." AND ip_src3=".$ip3.")"; 
  $result2 = mysql_query($temp, $db);
  $num_src_ip = mysql_num_rows($result2);
  mysql_free_result($result2); 

  /* Unique instances Dest. Address  */
  $temp = "SELECT sid from iphdr WHERE ".
         "(ip_dst0=".$ip0." AND ip_dst1=".$ip1." AND ip_dst2=".$ip2." AND ip_dst3=".$ip3.")";
  $result2 = mysql_query($temp, $db);
  $num_dst_ip = mysql_num_rows($result2);
  mysql_free_result($result2); 

  /* First and Last timestamp of this address */
  $temp = "SELECT min(timestamp), max(timestamp) FROM event LEFT JOIN iphdr ".
          "ON event.sid=iphdr.sid AND event.cid=iphdr.cid WHERE ".
          "((ip_src0=".$ip0." AND ip_src1=".$ip1." AND ip_src2=".$ip2." AND ip_src3=".$ip3.") OR ".
          "(ip_dst0=".$ip0." AND ip_dst1=".$ip1." AND ip_dst2=".$ip2." AND ip_dst3=".$ip3.")) AND ".
          "signature LIKE '%'";
  $result2 = mysql_query($temp, $db);
  $myrow = mysql_fetch_row($result2);
  $start_time = $myrow[0];
  $stop_time = $myrow[1];
  mysql_free_result($result2);

  /* Print out */ 
  echo '<TR>
         <TD ALIGN=CENTER>'.$num_sensors;
  if ( $num_src_ip == 0 )
         echo '<TD ALIGN=CENTER>'.$num_src_ip;
  else
         echo '<TD ALIGN=CENTER><A HREF="'.$tmp_src_iplookup.'">'.$num_src_ip.'</A>';
  if ( $num_dst_ip == 0 )         
         echo '<TD ALIGN=CENTER>'.$num_dst_ip;
  else
         echo '<TD ALIGN=CENTER><A HREF="'.$tmp_dst_iplookup.'">'.$num_dst_ip.'</A>';
  echo '
         <TD ALIGN=CENTER>'.$start_time.'
         <TD ALIGN=CENTER VALIGN=CENTER>'.$stop_time.'
       </TR>
      </TABLE></CENTER>';

  if ( $action == "events" )
  {
     echo '<HR>
            <CENTER><P>';
     PrintEventsByIP($db, $ip0, $ip1, $ip2, $ip3);
     echo ' </CENTER>';	
  }     
?>

</FORM>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_footer.html");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

</HTML>




