<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */

function DeleteSelectedAlerts($alert_del, $num_rows, &$del_method, $sql, &$num_result_rows, $db)
{
  $del_alert_num = 0;
  $del_table_list[0] = "event";
  $del_table_list[1] = "iphdr";
  $del_table_list[2] = "tcphdr";
  $del_table_list[3] = "udphdr";
  $del_table_list[4] = "icmphdr";
  $del_table_list[5] = "opt";
  $del_table_list[6] = "data";
  $del_table_list[7] = "acid_ag_alert";

  if ( $del_method == "Entire Query" )
  {
     $result = mysql_query($sql, $db);
     if ( mysql_errno($db) > 0 )
     {
        ErrorMessage("Error retrieving alert list to delete");
        return -1;
     }
  }

  for ( $i = 0; $i < $num_rows; $i++ )
  {
      if ( $alert_del[$i] != "" || $del_method == "Entire Query")
      {
         if ( $del_method == "Entire Query" )
         {
            $myrow = mysql_fetch_row($result);
            $sid = $myrow[0];
            $cid = $myrow[1];  
         }
         else 
            GetQueryResultID($alert_del[$i], $seq, $sid, $cid);

         //echo '<BR>'.$sid.' - '.$cid;
         for ( $j = 0; $j < 8; $j++ )
         {
            /* If trying to add to an ACID table append ag_ to the fields */
            if ( strstr($del_table_list[$j], "acid_") == "" )
               $sql2 = "DELETE FROM ".$del_table_list[$j]." WHERE sid=".$sid." AND cid=".$cid;
            else
               $sql2 = "DELETE FROM ".$del_table_list[$j]." WHERE ag_sid=".$sid." AND ag_cid=".$cid;              
            mysql_query($sql2, $db);

            $error = mysql_errno($db);
            if ( $error > 0 )
               ErrorMessage("Error Deleting Alert"." ".$del_table_list[$j]);
            else if ( $j == 0 ) 
               ++$del_alert_num; 
         } 
     }
  }

  if ( $method == "Entire Query" )
     mysql_free_result($result);

  if ( $del_alert_num > 0 )
  {
     ErrorMessage("Successfully deleted ".$del_alert_num." alert(s)");
     /* Reset the alert count that the query is re-executed to reflect the deletion */
     $num_result_rows = -1;
     $del_method = "Query DB";
  }

  if ( $del_alert_num == 0 )
     ErrorMessage("No alerts were selected or the Delete was not successful");
 
}

function PrintQueryResultAction($action, $ag_add_key, $select_criteria)
/*
   $select_criteria: 1 = Selected
                     2 = Select + ALL on Screen + Entire Query 
*/
{
  echo '<CENTER>
        <TABLE BORDER=1>
          <TR>
            <TD ALIGN=CENTER>Action<BR>
            
            <SELECT NAME="action">
               <OPTION VALUE=" "         '.chk_select($action," ").'>{ action }
               <OPTION VALUE="ag_by_id"  '.chk_select($action,"ag_by_id").'>Add to AG (by ID)
               <OPTION VALUE="ag_by_name"'.chk_select($action,"ag_by_name").'>Add to AG (by Name)
               <OPTION VALUE="del_alert" '.chk_select($action,"del_alert").'>Delete Alert(s)
            </SELECT>

            <INPUT TYPE="text" NAME="ag_add_key" VALUE="'.$ag_add_key.'">
            <INPUT TYPE="submit" NAME="submit" VALUE="Selected">';
            if ( $select_criteria == 2 )
               echo '
                    <INPUT TYPE="submit" NAME="submit" VALUE="ALL on Screen">
                    <INPUT TYPE="submit" NAME="submit" VALUE="Entire Query">';
    echo '
            </TD>
          </TR>
        </TABLE>
        </CENTER>';
}

?>




