#!/usr/bin/perl

# text4sel.pl, distributed as part of Snortsnarf v111500.1
# Author: James Hoagland, Silicon Defense (hoagland@SiliconDefense.com)
# copyright (c) 2000 by Silicon Defense (http://www.silicondefense.com/)
# Released under GNU General Public License, see the COPYING file included
# with the distribution or http://www.silicondefense.com/snortsnarf/ for
# details.

# text4sel.pl is a CGI script that accepts an ip address in 'ip', an end
#   ('src' or 'dest') in 'end', a comma-separated list of logs in 'logs',
#   and 'include' with 'g' to grab general alerts and 'a' to grab anomaly
#   alerts or 'ga' for both to produce a text file showing the alerts with
#   'end' 'ip' in 'logs' to in the given files.

# Please send complaints, kudos, and especially improvements and bugfixes to
# hoagland@SiliconDefense.com.  As described in GNU General Public License, no
# warranty is expressed for this program.

use CGI;
require "snort_alert_parse.pl";

# get paramaters of the invocation
$input= new CGI;
foreach (@ARGV) {  # simulate field input if running on command line
  $input->param(split('=',$_,2));
}
$end= $input->param('end');
$ip= $input->param('ip');
$logs= $input->param('logs');
$include= $input->param('include');
@logs= split(',',$logs);

# print out headers
print $input->header('text/plain');

@alerts= &grab_alerts_of_type($ip,$end,$include,@logs);

@alerts2= ();
foreach $alertinfo (@alerts) {
	($alert,$num,$filepath,$file_type,$format)= @{$alertinfo};
	$time= &alert_time_index($alert,$format);
	push(@alerts2,[$alert,$format,$time]);
}

@alerts= sort {$a->[2] <=> $b->[2]} @alerts2;

@atypes= ();
push(@atypes,'standard') if $include =~ /g/;
push(@atypes,'anomaly') if $include =~ /a/;

print "# ip: $ip, end: $end, alert type(s): ",join(', ',@atypes),"\n";
print "# file(s) searched: ",join(', ',@logs),"\n";
print "# generated: ".localtime(time())."\n\n";

foreach $alertinfo (@alerts) {
	($alert,$format,$time)= @{$alertinfo};
	print $alert,"\n";
	print "\n" if $format eq 'fullalert';
}

# $Id: text4sel.pl,v 1.4 2000/11/15 22:40:28 jim Exp $
