# hostSentry - Login Anomaly Detector Default User Class
#
# Author: Craig H. Rowland <crowland@psionic.com>
# Created: 10-6-98
#
# Send all changes/modifications/bugfixes to the above address.  
# 
# This software is Copyright(c) 1997-98 Craig H. Rowland
# 
# Disclaimer:
# 
# All software distributed by Craig H. Rowland ("the author") and
# Psionic Systems is distributed AS IS and carries NO WARRANTY or
# GUARANTEE OF ANY KIND. End users of the software acknowledge that         
# they will not hold the author, Psionic Systems, and any employer of    
# the author liable for failure or non-function of a software
# product. YOU ARE USING THIS PRODUCT AT YOUR OWN RISK
# 
# Licensing restrictions apply. See the license that came with this
# file for more information or visit http://www.psionic.com for more
# information.
# 
# This software is NOT GPL NOR PUBLIC DOMAIN so please read the license   
# before modifying or distributing. Contact the above address if you have
# any questions.
# 
# $Id: hostSentryUser.py,v 1.1 1999/03/22 04:56:47 crowland Exp crowland $


# Schema version
DBVERSION = 1
# Max number of logins an object will track before
# they roll old ones off the end (you may want to increase
# this if you want to track a huge number of logins)
# This needs to be moved to the config file.

MAX_LOGINS = 1000

# Basic User Object
class hostSentryUser:

	def __init__(self):
		self.__username = ''
		self.__recordCreated = ''
		self.__firstLogin = ''
		self.__trackLogins=[]
		self.__validLoginDays=''
		self.__validLoginHours=''
		self.__adminDisabled=0
		self.__securityDisabled=0
		self.__totalLogins=0
		self.__version=DBVERSION

	def setRecordCreated(self, created):
		self.__recordCreated = created

	def getRecordCreated(self):
		return self.__recordCreated

	def setUsername(self, username):
		self.__username = username

	def getUsername(self):
		return self.__username

	def setFirstLogin(self, firstLogin):
		self.__firstLogin = firstLogin

	def getFirstLogin(self):
		return self.__firstLogin

	def insertTrackLogins(self, track, index = 0):
		self.__trackLogins.insert(index, track)

	def setTrackLogins(self, track=[]):
		self.__trackLogins = track

	def getTrackLogins(self):
		return self.__trackLogins

	def delTrackLogins(self, index = 0):
		del self.__trackLogins[index]

	def cycleTrackLogins(self):
		if len(self.__trackLogins) > MAX_LOGINS:
			del self.__trackLogins[MAX_LOGINS]

	def setValidLoginDays(self, days):
		self.__validLoginDays = days

	def getValidLoginDays(self):
		return self.__validLoginDays

	def setValidLoginHours(self, hours):
		self.__validLoginHours = hours

	def getValidLoginHours(self):
		return self.__validLoginHours

	def setAdminDisabled(self, disabled):
		self.__adminDisabled = disabled

	def getAdminDisabled(self):
		return self.__adminDisabled

	def setSecurityDisabled(self, disabled):
		self.__securityDisabled = disabled

	def getSecurityDisabled(self):
		return self.__securityDisabled

	def setTotalLogins(self, logins):
		self.__totalLogins = logins

	def getTotalLogins(self):
		return self.__totalLogins


