# hostSentry - Login Anomaly Detector Stat Module
#
# Author: Craig H. Rowland <crowland@psionic.com>
# Created: 10-6-98
#
# Send all changes/modifications/bugfixes to the above address.  
# 
# This software is Copyright(c) 1997-98 Craig H. Rowland
# 
# Disclaimer:
# 
# All software distributed by Craig H. Rowland ("the author") and
# Psionic Systems is distributed AS IS and carries NO WARRANTY or
# GUARANTEE OF ANY KIND. End users of the software acknowledge that         
# they will not hold the author, Psionic Systems, and any employer of    
# the author liable for failure or non-function of a software
# product. YOU ARE USING THIS PRODUCT AT YOUR OWN RISK
# 
# Licensing restrictions apply. See the license that came with this
# file for more information or visit http://www.psionic.com for more
# information.
# 
# This software is NOT GPL NOR PUBLIC DOMAIN so please read the license   
# before modifying or distributing. Contact the above address if you have
# any questions.
# 
# Description:
# 
# This module allows you to perform a variety of functions
# on the database.
#
# $Id: hostSentryStat.py,v 1.1 1999/03/22 04:57:29 crowland Exp crowland $


from hostSentryCore import *
import hostSentryConfig
import hostSentryUser
import hostSentryLog
import hostSentryDB

import getopt
import string
import sys

class hostSentryStat(hostSentryCore):

	def __init__(self, dbFile = None):
		self.setLogLevel()
		self.dbFile = dbFile
		self.dbHandle = None


	def usage(self):

		print 'Usage: hostSentryStat.py <option> [argument]'
		print ''
		print '-u <username>  		-- Retrieve username record from DB'
		print '-l 			-- Dump entire DB'
		print '-d <username>		-- Delete user record from DB (CAUTION)'
#		print '-t			-- Print total number of user records'

	def delUser(self, username):

		dbObj=hostSentryDB.hostSentryDB(self.dbFile)
		dbObj.open()

		try:		
			if dbObj.exists(username):
				userObj = dbObj.delete(username)
				print 'User %s deleted from DB.' % username
			else:
				print 'User: %s does not exist in DB.' % username	
			dbObj.close()
		except:
			print 'Error processing user %s from DB' % username
			dbObj.close()


	def getUser(self, username):

		dbObj=hostSentryDB.hostSentryDB(self.dbFile)
		dbObj.open()
	

		try:		
			if dbObj.exists(username):
				userObj = dbObj.get(username)
				print ''
				print 'Retrieved Username: ' + userObj.getUsername()
				print 'Record Created: ' + userObj.getRecordCreated()
				print 'First Login: ' + userObj.getFirstLogin()
				print 'Track Logins: ', userObj.getTrackLogins()
				print 'Valid Login Days: ' + userObj.getValidLoginDays()
				print 'Valid Login Hours: ' + userObj.getValidLoginHours()
				print 'Admin Disabled: %d' % userObj.getAdminDisabled()
				print 'Security Disabled: %d' % userObj.getSecurityDisabled()
				print 'Total Logins: %d' % userObj.getTotalLogins()
			else:
				print 'User: %s does not exist in DB.' % username	

			dbObj.close()
		except:
			print 'Error processing user %s from DB' % username
			dbObj.close()

	def dumpDB(self):


		dbObj = hostSentryDB.hostSentryDB(self.dbFile)
		dbObj.open()
		users = dbObj.dump()
		totalUsers = 0

		try:
			for x in range(len(users)):
				userObj = dbObj.get(users[x])
				totalUsers = totalUsers + 1
				print ''
				print 'Retrieved Username: ' + userObj.getUsername()
				print 'Record Created: ' + userObj.getRecordCreated()
				print 'First Login: ' + userObj.getFirstLogin()
				print 'Track Logins: ', userObj.getTrackLogins()
				print 'Valid Login Days: ' + userObj.getValidLoginDays()
				print 'Valid Login Hours: ' + userObj.getValidLoginHours()
				print 'Admin Disabled: %d' % userObj.getAdminDisabled()
				print 'Security Disabled: %d' % userObj.getSecurityDisabled()
				print 'Total Logins: %d' % userObj.getTotalLogins()
				print ''

			print 'Total Users: %d' % totalUsers		
			dbObj.close()
		except:
			print 'Error processing DB'
			dbObj.close()



if __name__ == '__main__':


	db = '/usr/local/abacus/hostsentry/hostsentry.db'
	oper = hostSentryStat(db)

	try:
		options, args = getopt.getopt(sys.argv[1:], 'd:lu:')
	except:
		oper.usage()
		sys.exit()
	
	if len(options) == 0:
		oper.usage()
		sys.exit()


	for x in range(len(options)):
		if options[x][0] == '-u':
			oper.getUser(options[x][1])
		elif options[x][0] == '-l':
			oper.dumpDB()
		elif options[x][0] == '-d':
			oper.delUser(options[x][1])

