# hostSentry - Login Anomaly Detector Main Database Methods
#
# Author: Craig H. Rowland <crowland@psionic.com>
# Created: 10-6-98
#
# Send all changes/modifications/bugfixes to the above address.  
# 
# This software is Copyright(c) 1997-98 Craig H. Rowland
# 
# Disclaimer:
# 
# All software distributed by Craig H. Rowland ("the author") and
# Psionic Systems is distributed AS IS and carries NO WARRANTY or
# GUARANTEE OF ANY KIND. End users of the software acknowledge that         
# they will not hold the author, Psionic Systems, and any employer of    
# the author liable for failure or non-function of a software
# product. YOU ARE USING THIS PRODUCT AT YOUR OWN RISK
# 
# Licensing restrictions apply. See the license that came with this
# file for more information or visit http://www.psionic.com for more
# information.
# 
# This software is NOT GPL NOR PUBLIC DOMAIN so please read the license   
# before modifying or distributing. Contact the above address if you have
# any questions.
# 
# $Id: hostSentryDB.py,v 1.1 1999/03/22 04:56:41 crowland Exp crowland $


from hostSentryCore import *
import hostSentryConfig
import hostSentryUser
import hostSentryLog

import sys
import shelve

class hostSentryDB(hostSentryCore):

	def __init__(self, dbFile = None):
		self.setLogLevel()
		self.dbFile = dbFile
		self.dbHandle = None

#########################################
# open Method
#
# Opens DB.
#########################################
	def open(self, dbFile = None):
		if dbFile != None:
			self.dbFile = dbFile
		if self.dbFile == None:
			raise hostSentryError('adminalert: User database file not specified.')

		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: hostSentryDB: open: opening database: ' + self.dbFile)

		try:
			self.dbHandle = shelve.open(self.dbFile)
		except:
			raise hostSentryError(sys.exc_value)

#########################################
# store Method
#
# Store user object
#########################################
	def store(self, hostSentryUserObj):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: hostSentryDB: store: storing user in database: ' + hostSentryUserObj.getUsername())

		# DB not open yet. Do it now.
		if self.dbHandle == None:
			try:
				self.open()
			except:
				raise hostSentryError(sys.exc_value)

		self.dbHandle[hostSentryUserObj.getUsername()] = hostSentryUserObj

#########################################
# get Method
#
# gets user object.
#########################################
	def get(self, username):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: hostSentryDB: get: retrieving user from database: ' + username)

		if self.dbHandle == None:
			try:
				self.open()
			except:
				raise hostSentryError(sys.exc_value)

		return self.dbHandle[username]

#########################################
# delete Method
#
# deletes user object.
#########################################
	def delete(self, username):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: hostSentryDB: delete: deleting user from database: ' + username)

		if self.dbHandle == None:
			try:
				self.open()
			except:
				raise hostSentryError(sys.exc_value)

		del self.dbHandle[username]


#########################################
# exists Method
#
# check if user object exists in DB
#########################################
	def exists(self, username):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: hostSentryDB: exists: checking for user in database: ' + username)

		if self.dbHandle == None:
			try:
				self.open()
			except:
				raise hostSentryError(sys.exc_value)

		return	self.dbHandle.has_key(username)

#########################################
# dump Method
#
# dump all DB records
#########################################
	def dump(self):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: hostSentryDB: dump: dumping all keys from database.')

		if self.dbHandle == None:
			try:
				self.open()
			except:
				raise hostSentryError(sys.exc_value)

		return self.dbHandle.keys()

#########################################
# close Method
#
# closes db.
#########################################
	def close(self):
		if self.getLogLevel() > 0:
			hostSentryLog.log('debug: hostSentryDB: close: closing database: ' + self.dbFile)

		if self.dbHandle == None:
			return
		else:
			self.dbHandle.close()
		
if __name__ == '__main__':

	username = sys.argv[1]
	testObj = hostSentryUser.hostSentryUser()

	test=hostSentryDB('/tmp/test')
	test.setLogLevel(99)
	test.open()

	testObj.setUsername(username)
	print 'Username: ' + testObj.getUsername()

	if test.exists(username):
		print 'User ' + username + ' already exists in database. Skipping'
	else:
		print 'User ' + username + ' does NOT exist in database. Adding.'
		test.store(testObj)

	users = test.dump()
	totalUsers = 0

	for x in range(len(users)):
		testRetObj = test.get(users[x])
		totalUsers = totalUsers + 1
		print ''
		print 'Retrieved Username: ' + testRetObj.getUsername()
		print 'Record Created: ' + testRetObj.getRecordCreated()
		print 'First Login: ' + testRetObj.getFirstLogin()
		print 'Track Logins: ', testRetObj.getTrackLogins()
		print 'Valid Login Days: ' + testRetObj.getValidLoginDays()
		print 'Valid Login Hours: ' + testRetObj.getValidLoginHours()
		print 'Admin Disabled: %d' % testRetObj.getAdminDisabled()
		print 'Security Disabled: %d' % testRetObj.getSecurityDisabled()
		print 'Total Logins: %d' % testRetObj.getTotalLogins()
		print ''
		print 'Total Users: %d' % totalUsers		


#	print 'Deleting User Entry: ' + testObj.getUsername()
#	test.delete(testObj.getUsername())
#
#	if test.exists(username):
#		print 'User ' + username + ' not removed from database.'
#	else:
#		print 'User ' + username + ' successfully removed from database.'

	test.close()
