# hostSentryConfig - Login Anomaly Detector Configuration Parser
#
# Author: Craig H. Rowland <crowland@psionic.com>
# Created: 10-6-98
#
# Send all changes/modifications/bugfixes to the above address.  
# 
# This software is Copyright(c) 1997-98 Craig H. Rowland
# 
# Disclaimer:
# 
# All software distributed by Craig H. Rowland ("the author") and
# Psionic Systems is distributed AS IS and carries NO WARRANTY or
# GUARANTEE OF ANY KIND. End users of the software acknowledge that         
# they will not hold the author, Psionic Systems, and any employer of    
# the author liable for failure or non-function of a software
# product. YOU ARE USING THIS PRODUCT AT YOUR OWN RISK
# 
# Licensing restrictions apply. See the license that came with this
# file for more information or visit http://www.psionic.com for more
# information.
# 
# This software is NOT GPL NOR PUBLIC DOMAIN so please read the license   
# before modifying or distributing. Contact the above address if you have
# any questions.
# 
# $Id: hostSentryConfig.py,v 1.1 1999/03/22 04:56:36 crowland Exp crowland $


from hostSentryCore import *

import sys
import re
import string

# This is the default config file. I'll make this more
# accessible in the future.
CONFIG='/usr/local/abacus/hostsentry/hostsentry.conf'

class hostSentryConfig(hostSentryCore):
                
        def __init__(self, location = ''):
		if location == '':
			self.configFile = CONFIG
		else:
	                self.configFile = config

		self.config = None

######################################
# configInit Method
#
# Opens the config file.
#
# Raises exception if it is not found.
######################################
        def configInit(self):
                try:
                        self.config=open(self.configFile)
                except:
                        if sys.exc_value[0] == 2:
                                raise hostSentryError('Config file not found: ' + self.configFile)
                        else:
                                raise hostSentryError(sys.exc_value[1])

######################################
# close Method
#
# Closes the config file.
######################################
	def close(self):
		try:
			if self.config != None:
				self.config.close()
		except:
			raise hostSentryError(sys.exc_value[1])


########################################################
# parseToken
#
# This reads the config file and parses named tokens.
# A token is formed:
#
# TOKEN_NAME = "token information here"
# 
# The data between quotes is returned on success otherwise
# None.
#
#
#######################################################
	def parseToken(self, tokenName=''):
		# Grab the token name we're looking for and the length
		# so we don't regex in too far.
		if tokenName == '':
			raise hostSentryError('No token name supplied.')
		else:
			tokenLen = len(tokenName)	

		# if the config file hasn't been init yet. Then
		# do it.
		if self.config == None:
			self.configInit()
		# Rewind to beginning
		else:
			self.config.seek(0)

		# loop through the file looking for the token.
		while 1:
			line = self.config.readline()
			if len(line) < 1:
				break
			elif line[0] == '#':
				pass
			elif re.search(line[:tokenLen], tokenName) != None:
				try:
					tokenData = string.split(line, '\"', 2)
				except:
					raise hostSentryError('config token not properly formatted (check quotes)')
				if len(tokenData) != 3:
					raise hostSentryError('config token not properly formatted (check quotes)')
				else:					
					return tokenData[1]

		# The config token hasn't been found so return None
		return None


# That's it
