/* $Id: sig_rmd160.c,v 1.2 2004/02/21 22:41:22 xie Exp $ */
/*
 * md5wrapper.c
 *
 *	signature function hook for MD5 (the RSA Data Security, Inc. MD5 
 *	Message Digesting Algorithm) for Tripwire.
 *
 *	The original MD5 code is contained in md5.c in its entirety.
 *
 * Gene Kim
 * Purdue University
 * September 27, 1992
 */

#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "sigs.h"
#include "rmd160.h"
#define BUFSIZE 4096

char *btob64();

/*
 * int
 * pf_signature(int fd_in, char *ps_signature, int siglen)
 *
 *	fd_in: 		pointer to input file descriptor
 *	ps_signature: 	pointer to array where signature will be stored
 *	siglen: 	length of the signature array (for overflow checking)
 */

int
sig_rmd160_get(sig_text, ps_signature)
char *sig_text;
byte *ps_signature;
{
	unsigned char buffer[BUFSIZE];
	int readin;
	int i;
	byte hashcode[RMDsize / 8];

	if (strlen(sig_text) <= 0)
		return -1;

	RMD(sig_text, hashcode);

	for (i = 0; i < RMDsize / 8; i++)
		sprintf(ps_signature + 2 * i, "%02x", hashcode[i]);

	return 0;
}

int
rmd160_str(const char *instr, char *series)
{
	int i;
	char buffer[50];

	memset(buffer, '\0', 41);
	if (sig_rmd160_get(instr, buffer) < 0)
		return -1;

	memset(series, '\0', 41);
	strncpy(series, buffer, 40);
	return 0;
}
