/*
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
*/

/* $Id: lids_capflag.h,v 1.2 2004/02/21 22:41:22 xie Exp $ */
#ifndef LIDS_CAPFLAG_H
#define LIDS_CAPFLAG_H

#define EINVAL -1
#define ENOENT -2

typedef struct entry_s {
	struct entry_s *next;
	char *name;		/* Name of entry */
	int val;		/* Value of entry */
	char *desc;		/* Short description of entry */
	int pos;		/* Location of entry */
} entry_t;

extern entry_t flag_list[];
extern entry_t cap_list[];
extern entry_t socket_list[];

#define for_each_entry(list,c)	for ((c) = list; (c)->next != NULL; (c) = (c)->next)

extern entry_t *getentrybyname(entry_t * list, const char *name);
extern entry_t *getentrybyval(entry_t * list, int val);
extern entry_t *getentrybypos(entry_t * list, int pos);

extern void setentry(entry_t * list);
extern void endentry(entry_t * list);

#define FLAG_FULL_SET           (~0)
#define FLAG_TO_MASK(flag)      (1 << (flag))
#define flag_raise(flag, bit)   ((flag) |= FLAG_TO_MASK(bit))
#define flag_lower(flag, bit)   ((flag) &= ~FLAG_TO_MASK(bit))
#define flag_raised(flag, bit)  ((flag) & FLAG_TO_MASK(bit) & FLAG_FULL_SET)

#define CAP_FULL_SET            (~0)
#define CAP_TO_MASK(cap)       (1 << (cap))
#define cap_raise(cap, bit)    ((cap) |= CAP_TO_MASK(bit))
#define cap_lower(cap, bit)    ((cap) &= ~CAP_TO_MASK(bit))
#define cap_raised(cap, bit)   ((cap) & CAP_TO_MASK(bit) & CAP_FULL_SET)

#endif
