/* 
 *
 *	This is a part of lib/des/read_pwd.c 
 * 
 * Copyright (C) 1995 Eric Young (eay@mincom.oz.au)
 * All rights reserved.
 * 
 */
/* $Id: read_pw.c,v 1.2.2.2 2004/03/10 08:24:28 xie Exp $ */

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <setjmp.h>

#include <termio.h>
#define TTY_STRUCT      struct termio
#define TTY_FLAGS       c_lflag
#define TTY_get(tty,data)   ioctl(tty,TCGETA,data)
#define TTY_set(tty,data)   ioctl(tty,TCSETA,data)

#ifndef NX509_SIG
#define NX509_SIG 32
#endif

static void (*savsig[NX509_SIG]) ();
static jmp_buf save;

static void recsig(int);

static void pushsig();

static void popsig();
static void
read_till_nl(in)

FILE *in;
{
#define SIZE 4
	char buf[SIZE + 1];

	do {
		fgets(buf, SIZE, in);
	} while (strchr(buf, '\n') == NULL);
}

/* return 0 if ok, 1 (or -1) otherwise */
static int
read_pw(buf, buff, size, prompt, verify)
char *buf;
char *buff;
int size;
char *prompt;
int verify;
{
	TTY_STRUCT tty_orig, tty_new;
	int number = 5;
	int ok = 0;
	int ps = 0;
	FILE *tty = NULL;
	char *p;

	if ((tty = fopen("/dev/tty", "r")) == NULL)
		tty = stdin;

	if (TTY_get(fileno(tty), &tty_orig) == -1)
		return (-1);
	memcpy(&(tty_new), &(tty_orig), sizeof (tty_orig));

	if (setjmp(save)) {
		ok = 0;
		goto error;
	}
	pushsig();
	ps = 1;

	tty_new.TTY_FLAGS &= ~ECHO;

	if (TTY_set(fileno(tty), &tty_new) == -1)
		return (-1);
	ps = 2;

	while ((!ok) && (number--)) {
		fputs(prompt, stderr);
		fflush(stderr);

		buf[0] = '\0';
		fgets(buf, size, tty);
		if (feof(tty))
			goto error;
		if ((p = (char *) strchr(buf, '\n')) != NULL)
			*p = '\0';
		else
			read_till_nl(tty);
		if (verify) {
			/* thats UGLY (output is "reenter new password") */
			fprintf(stderr, "\nre%s", prompt);
			fflush(stderr);
			buff[0] = '\0';
			fgets(buff, size, tty);
			if (feof(tty))
				goto error;
			if ((p = (char *) strchr(buff, '\n')) != NULL)
				*p = '\0';
			else
				read_till_nl(tty);

			if (strcmp(buf, buff) != 0) {
				fprintf(stderr, "\nverify failed");
				fflush(stderr);
				break;
				/* continue; */
			}
		}
		ok = 1;
	}

      error:
	fprintf(stderr, "\n");
	/* What can we do if there is an error? */
	if (ps >= 2)
		TTY_set(fileno(tty), &tty_orig);

	if (ps >= 1)
		popsig();
	if (stdin != tty)
		fclose(tty);
	return (!ok);
}

static void
pushsig()
{
	int i;

	for (i = 1; i < NX509_SIG; i++)
		savsig[i] = signal(i, recsig);
}

static void
popsig()
{
	int i;

	for (i = 1; i < NX509_SIG; i++)
		signal(i, savsig[i]);
}

static void
recsig(i)
int i;
{
	longjmp(save, 1);
}

int
read_password(key, prompt, verify)
char (*key);
char *prompt;
int verify;
{
	int ok;
	char buf[BUFSIZ], buff[BUFSIZ];

	if ((ok = read_pw(buf, buff, BUFSIZ, prompt, verify)) == 0)
		strcpy(key, buf);
	memset(buf, 0, BUFSIZ);
	memset(buff, 0, BUFSIZ);
	return (ok);
}

/*
 *	MD5 password routine. by xie hua gang.
 */

/* if type != 1 then verify the (new) password */
int
read_crypto_passwd(char *crypto_key, int type, int num)
{
	int ok, i, len;
	char key[1024];

	if (type) {
		ok = read_password(crypto_key, "enter new password: ", type);
	} else {
		ok = read_password(crypto_key, "enter password: ", type);
	}

	if (ok < 0)
		return 0;
	memset(key,0,1024);
	len = strlen(crypto_key);
	memcpy(key, crypto_key, len);
	for (i = 0; i < num; i++) {
		if ((ok = sha256(key, len, crypto_key)) < 0)
			break;
		memcpy(key, crypto_key, 32);
		len = 32;
	}

	return ok;
}

#ifdef DEBUG

main()
{
	int ok;
	char key[160];

	ok = read_crypto_passwd(key, 0, 0);
	printf(" ok = %d,key=%s\n", ok, key);
	ok = read_crypto_passwd(key, 0, 1);
	printf(" ok = %d,key=%s\n", ok, key);
	ok = read_crypto_passwd(key, 0, 2);
	printf(" ok = %d,key=%s\n", ok, key);
}

#endif
