/*
   Copyright (c) Carnegie Mellon University 1994, 1995

   CERT(sm) Coordination Center
   Software Engineering Institute
   Carnegie Mellon University
   Pittsburgh, PA 15213-3890
   U.S.A.
   CERT is a service mark of Carnegie Mellon University.
*/


#include <stdio.h>
#include <sys/types.h>

#include <sys/uio.h>
#include <sys/mbuf.h>
#include <sys/map.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>


#define MAXINTERFACES   16

main (argc, argv)
register int argc;
register char *argv[];
{
   register int fd, intrface, nr_promiscuous_devices = 0;
   struct ifreq buf[MAXINTERFACES];
   struct ifconf ifc;

	if ((fd = socket (AF_INET, SOCK_DGRAM, 0)) >= 0) {
	    ifc.ifc_len = sizeof buf;
	    ifc.ifc_buf = (caddr_t) buf;

	    if (!(ioctl (fd, SIOCGIFCONF, (char *) &ifc))) {
		intrface = ifc.ifc_len / sizeof (struct ifreq);

		if (!intrface) {
		    (void)fprintf(stderr, "cpm: No network interfaces found.\n");
		    (void)exit(0);
		}
		(void)fprintf(stderr, "%d network interfaces found:\n", intrface);
		while (intrface-- > 0) {
		    (void)fprintf (stderr, "  %s: ", buf[intrface].ifr_name);
		    if (!(ioctl(fd, SIOCGIFFLAGS, (char *) &buf[intrface]))) {
			if (buf[intrface].ifr_flags & IFF_PROMISC) {
			    (void)fprintf (stderr, "*** IN PROMISCUOUS MODE ***\n");
			    nr_promiscuous_devices++;
			} else {
			    (void)fprintf (stderr, "Normal\n");
			}
		    } else {
			char str[256];
			(void)sprintf (str, "cpm: ioctl device %s", buf[intrface].ifr_name);
			perror(str);
		    }
		}
	} else
		perror ("cpm: ioctl");
    } else
	perror ("cpm: socket");

    (void)close (fd);
    (void)fprintf (stderr, "%d of them %s in promiscuous mode.\n",
	nr_promiscuous_devices, nr_promiscuous_devices==1 ? "is" : "are");
    return nr_promiscuous_devices;

}


