/*
 * sarg - Squid user management log
 * Mar/98 - Pedro L Orso - orso@onda.com.br
 */

#include "include/conf.h"

void geraindex(char *dirname, int debug, char *BgColor, char *TxColor, char *TxBgColor, char *TiColor, char *LogoImage, char *LogoText, char *LogoTextColor, char *Width, char *Height, char *Title, char *BgImage, char *FontFace, char *HeaderColor, char *HeaderBgColor, char *FontSize, char *TempDir, char *DateFormat, const char *periodo)
{

   FILE *fp_ou;
   DIR *dirp;
   struct dirent *direntp;
   char html[MAXLEN];
   char wdir[MAXLEN];
   char data[80];
   char tuser[20];
   char tbytes[20];
   char media[20];
   char ftime[128];

   if(LastLog[0] != '\0')
      mklastlog(dirname,debug);

   sprintf(wdir,"%sindex.html",dirname);

   if(strcmp(Index,"no") == 0) {
      if(access(wdir, R_OK) == 0)
         unlink(wdir);
      return;
   }

   if(debug)
      debuga(text[53]);

   if((fp_ou=fopen(wdir,"w"))==NULL) {
      fprintf(stderr, "SARG: (index) %s: %s\n",text[45],wdir);
      exit(1);
   }

   fputs("<html>\n",fp_ou);
   fputs("<head>\n",fp_ou);
   sprintf(html,"  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   fputs(html,fp_ou);
   fputs("</head>\n",fp_ou);

   if(strlen(FontFace) > 0) {
      sprintf(html,"<font face=%s>\n",FontFace);
      fputs(html,fp_ou);
   }

   sprintf(html,"<body bgcolor=%s text=%s background='%s'>\n",BgColor,TxColor,BgImage);
   fputs(html,fp_ou);

   fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);

   if(strlen(LogoImage) > 0) {
      sprintf(html,"<tr><th align=left><img src='%s' border=0 align=absmiddle width=%s height=%s><font color=%s>%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
      fputs(html,fp_ou);
   }

   sprintf(html,"<tr><th align=center><b><font color=%s size=+1>%s</font></b></th></tr>\n",TiColor,Title);
   fputs(html,fp_ou);

   fputs("</table></center>\n",fp_ou);
   fputs("<center><table cellpadding=1 cellspacing=1>\n",fp_ou);
   fputs("<tr><td></td><td></td></tr>",fp_ou);


   sprintf(html,"<tr><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,text[101],HeaderBgColor,FontSize,HeaderColor,text[102],HeaderBgColor,FontSize,HeaderColor,text[103],HeaderBgColor,FontSize,HeaderColor,text[93],HeaderBgColor,FontSize,HeaderColor,text[96]);
   fputs(html,fp_ou);

   dirp = opendir(dirname);

   while ( (direntp = readdir( dirp )) != NULL ){
      if(strstr(direntp->d_name,"-") == 0)
         continue;

      obtdate(dirname,direntp->d_name,data);
      obtuser(dirname,direntp->d_name,tuser);
      obttotal(dirname,direntp->d_name,tbytes,tuser,media);

      sprintf(html,"<tr><td bgcolor=%s><font size=%s><a href='%s/%s'>%s</font></a></td><td bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td></tr>\n",TxBgColor,FontSize,direntp->d_name,ReplaceIndex,direntp->d_name,TxBgColor,FontSize,data,TxBgColor,FontSize,tuser,TxBgColor,FontSize,tbytes,TxBgColor,FontSize,media);
      fputs(html,fp_ou);
   }

   (void)closedir( dirp );

   strcpy(html,"</table></center>");
   fputs(html,fp_ou);

   zdate(ftime, DateFormat);

   sprintf(html,"<br><br><center><font size=-2>%s <a href='%s'>%s-%s</a> %s %s</font></center>\n",text[108],URL,PGM,VERSION,text[109],ftime);
   fputs(html,fp_ou);

   strcpy(html,"</html>\n");
   fputs(html,fp_ou);

   return;
}
