/*
 * sarg - Squid user management log
 * Mar/98 - Pedro L Orso - orso@onda.com.br
 */

#include "include/conf.h"

void htmlrel(const char *dirname, int debug, int iprel, int ipuser, char *BgColor, char *TxColor, char *TxBgColor, char *TiColor, char *LogoImage, char *LogoText, char *LogoTextColor, char *Width, char *Height, char *Title, char *BgImage, char *FontFace, char *HeaderColor, char *HeaderBgColor, char *FontSize, char *TempDir, char *UserSortField, char *UserSortOrder, char *DateFormat, int indexonly, char *PerUserLimitFile, char *PerUserLimit, char *Ip2Name)

{
   DIR *dirp;
   FILE *fp_in, *fp_ou, *fp_ip, *fp_ip2, *fp_usr, *fp_tt;

   struct dirent *direntp;
   long long int nnbytes=0, unbytes=0, tnbytes=0, totbytes=0, totbytes2=0;
   long long int totelap=0, totelap2=0, nnelap=0, unelap=0, tnelap=0;
   long long int incache=0, oucache=0, tnincache=0, tnoucache=0, twork=0, twork2=0;
   char arqin[MAXLEN], arqou[MAXLEN], arqper[MAXLEN], arqip[MAXLEN];
   char nacc[20], nbytes[20], url[1024], purl[1024], tmsg[30], tmsg2[30], nelap[20], csort[MAXLEN];
   char periodo[MAXLEN], usuario[MAXLEN], wusuario[MAXLEN], u2[MAXLEN], duser[MAXLEN];
   char userbytes[20], userelap[20], userurl[1024], userip[MAXLEN], userhora[9], userdia[9];
   char olduserip[MAXLEN], tmp2[MAXLEN], tmp3[MAXLEN], incac[20], oucac[20];
   char denied_report[255];
   char ttd1[3], ttd2[3], ttd3[5], ttt1[3], ttt2[3], ttt3[3];
   char *str;
   char ftime[128], warea[MAXLEN];
   char wtemp[MAXLEN], totuser[8];
   long long int tnacc=0, ttnacc=0, unacc=0;
   float perc=0, perc2=0, ouperc=0, inperc=0;
   char *s;
   int  x;

   if(indexonly) return;
   if(strstr(ReportType,"users_sites") == 0) return;

   strcpy(tmp2,TempDir);
   strcat(tmp2,"/sargtmp.unsort");

   strcpy(tmp3,TempDir);
   strcat(tmp3,"/sargtmp.log");

/*
 * Obtem o periodo
 */

   strcpy(arqper,dirname);
   strcat(arqper,"/periodo");

   if ((fp_in = fopen(arqper, "r")) == 0){
      fprintf(stderr, "SARG: (html) %s: %s\n",text[45],arqper);
      exit(1);
   }

   fgets(periodo,sizeof(periodo),fp_in);
   fclose(fp_in);

/*
 * Obtem total geral de bytes trafegados
 */
   strcpy(arqper,dirname);
   strcat(arqper,"/geral");

   if ((fp_in = fopen(arqper, "r")) == 0){
      fprintf(stderr, "SARG: (html) %s: %s\n",text[45],arqper);
      exit(1);
   }

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      if(strstr(buf,"TOTAL") == 0) {
         getword(wtemp,buf,' ');
         ttnacc+=my_atoll(buf);
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         totbytes+=my_atoll(wtemp);
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         totelap+=my_atoll(wtemp);
      }
   }

   fclose(fp_in);

   dirp = opendir(dirname);
   while ( (direntp = readdir( dirp )) != NULL ) {
      if(strstr(direntp->d_name,".txt") ==0)
         continue;

      strcpy(usuario,direntp->d_name);
      wusuario[0]='\0';

      striptxt:
      getword(warea,usuario,'.');
      strcpy(denied_report,warea);
      strcat(wusuario,warea);

      if(strcmp(usuario,"txt") !=0) {
         strcat(wusuario,".");
         goto striptxt;
      }

      report_day(dirname, wusuario, iprel, userip, BgColor, TxColor, TxBgColor, TiColor, LogoImage, LogoText, LogoTextColor, Width, Height, Title, BgImage, FontFace, HeaderColor, HeaderBgColor, FontSize, TempDir, UserSortField, UserSortOrder, DateFormat, periodo);

      strcpy(usuario,wusuario);
      strcpy(arqin,dirname);
      strcat(arqin,"/");
      strcpy(arqou,arqin);
      strcat(arqou,usuario);
      strcat(arqou,".html");
      strcpy(duser,arqin);
      strcat(duser,"denied_");
      strcat(arqin,direntp->d_name);
 
      if((str=(char *) strstr(denied_report, "_")) != (char *) NULL ) {
         if((str=(char *) strstr(str+1, "_")) != (char *) NULL )
            fixip(denied_report);
      }
      strcat(duser,denied_report);
      strcat(duser,".html");
      if(access(duser, R_OK) != 0)
         denied_report[0]='\0';

      if ((fp_in = fopen(arqin, "r")) == 0){
         fprintf(stderr, "SARG: (html) %s: %s\n",text[45],arqin);
         exit(1);
      }

      while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
         getword(wtemp,buf,' ');
         tnacc+=my_atoll(wtemp);
         getword(wtemp,buf,' ');
         tnbytes+=my_atoll(wtemp);
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         getword(wtemp,buf,' ');
         tnelap+=my_atoll(wtemp);
         getword(wtemp,buf,' ');
         tnincache+=my_atoll(wtemp);
         getword(wtemp,buf,' ');
         tnoucache+=my_atoll(wtemp);
      }

      fclose(fp_in);

      if ((fp_in = fopen(arqin, "r")) == 0){
         fprintf(stderr, "SARG: (html) %s: %s\n",text[45],arqin);
         exit(1);
      }

      if ((fp_ou = fopen(arqou, "w")) == 0){
         fprintf(stderr, "SARG: (html) %s: %s\n",text[45],arqou);
         exit(1);
      }

/*
 * Grava HEADER para usuario
 */

      fputs("<html>\n",fp_ou);
      fputs("<head>\n",fp_ou);
      sprintf(html,"  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
      fputs(html,fp_ou);
      fputs("</head>\n",fp_ou);

      if(strlen(FontFace) > 0) {
         sprintf(html,"<font face=%s>\n",FontFace);
         fputs(html,fp_ou);
      }

      sprintf(html,"<body bgcolor=%s text=%s background='%s'>\n",BgColor,TxColor,BgImage);
      fputs(html,fp_ou);

      fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);

      if(strlen(LogoImage) > 0) {
         sprintf(html,"<tr><th align=left><img src='%s' border=0 align=absmiddle width=%s height=%s><font color=%s
   >%s</font>\n",LogoImage,Width,Height,LogoTextColor,LogoText);
         fputs(html,fp_ou);
      }

      sprintf(html,"<tr><th align=center colspan=2><b><font color=%s size=+1>%s</font></b></th></tr>\n",TiColor,Title);
      fputs(html,fp_ou);
      fputs("<tr><td></td></tr><tr><td></td></tr>",fp_ou);

      strcpy(u2,usuario);
      if(ipuser){
         strcpy(u2,usuario);
         fixip(u2);
      }
      if(strcmp(Ip2Name,"yes") == 0)
         ip2name(u2);

      if(UserTabFile[0] != '\0') {
         sprintf(warea,":%s:",u2);
         if((str=(char *) strstr(userfile,warea)) != (char *) NULL ) {
            z1=0;
            str2=(char *) strstr(str+1,":");
            str2++;
            bzero(name, MAXLEN);
            while(str2[z1] != ':') {
               name[z1]=str2[z1];
               z1++;
            }
         } else strcpy(name,u2);
      } else strcpy(name,u2);

      fputs("</table></center>\n",fp_ou);
      fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);
 
      sprintf(html,"<tr><td align=right bgcolor=%s><font size=%s>%s:</font></td><td align=left bgcolor=%s><font size=%s>&nbsp;%s</font></td></td></tr>\n",HeaderBgColor,FontSize,text[89],TxBgColor,FontSize,periodo);
      fputs(html,fp_ou);
      sprintf(html,"<tr><td align=right bgcolor=%s><font size=%s>%s:</font></td><td align=left bgcolor=%s><font size=%s>&nbsp;%s</font></td></td></tr>\n",HeaderBgColor,FontSize,text[90],TxBgColor,FontSize,name);
      fputs(html,fp_ou);
      sprintf(html,"<tr><td align=right bgcolor=%s><font size=%s>%s:</font></td><td align=left bgcolor=%s><font size=%s>&nbsp;%s, %s</font></td></td></tr>\n",HeaderBgColor,FontSize,text[104],TxBgColor,FontSize,UserSortField,UserSortOrder);
      fputs(html,fp_ou);
      sprintf(html,"<tr><td align=center bgcolor=%s colspan=2><font size=%s>%s %s</font></td></tr>\n",HeaderBgColor,FontSize,text[32],text[55]);
      fputs(html,fp_ou);
 
      fputs("</table></center>\n",fp_ou);
      fputs("<center><table cellpadding=1 cellspacing=1>\n",fp_ou);
      fputs("<tr><td></td><td></td></tr>",fp_ou);

      if(strlen(denied_report) > 0) {
         sprintf(html,"<tr><td colspan=11><font size=-1><a href=\"denied_%s.html\">%s</a> %s</font></td></tr>\n",denied_report,text[116],text[55]);
         fputs(html,fp_ou);
      }

      sprintf(html,"<tr><th></th><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%%%s</font></th><th bgcolor=%s colspan=2><font size=%s color=%s>%s-%s-%s</font></th><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th bgcolor=%s><font size=%s color=%s>%%%s</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,text[91],HeaderBgColor,FontSize,HeaderColor,text[92],HeaderBgColor,FontSize,HeaderColor,text[93],HeaderBgColor,FontSize,HeaderColor,text[93],HeaderBgColor,FontSize,HeaderColor,text[113],text[114],text[112],HeaderBgColor,FontSize,HeaderColor,text[94],HeaderBgColor,FontSize,HeaderColor,text[95],HeaderBgColor,FontSize,HeaderColor,text[99]);
      fputs(html,fp_ou);

      if(debug){
         if(ipuser){
            strcpy(u2,usuario);
            fixip(u2);
            sprintf(msg, "%s: %s",text[61],u2);
         } else
            sprintf(msg, "%s: %s",text[61],usuario);
         debuga(msg);
      }

      fscanf(fp_in,"%s",nacc);
      fscanf(fp_in,"%s",nbytes);
      fscanf(fp_in,"%s",url);
      fscanf(fp_in,"%s",tmsg);
      fscanf(fp_in,"%s",nelap);
      fscanf(fp_in,"%s",incac);
      fscanf(fp_in,"%s",oucac);

      while(!feof(fp_in)) {
         strcpy(purl,url);
         sprintf(tmsg2,"%s",text[46]);
         if(strcmp(tmsg,tmsg2) == 0) {
            strcpy(purl,"<font COLOR=red>");
            strcat(purl,url);
	    strcat(purl,"</font>");
         }else {
            strcpy(purl,url);
            strncpy(tmsg,"                              ",30);
         }

         nnbytes=my_atoll(nbytes);
         nnelap=my_atoll(nelap);
         incache=my_atoll(incac);
         oucache=my_atoll(oucac);

         if(nnbytes) {
            perc=nnbytes * 100;
            perc=perc / tnbytes;
	 } else {
            perc=0;
            ouperc=0;
         }

         if(nnelap) {
            perc2=nnelap * 100;
            perc2=perc2 / tnelap;
         } else perc2=0;

         if(incache) {
            inperc=incache * 100;
            inperc=inperc / nnbytes;
         } else inperc=0;

         if(oucache) {
            ouperc=oucache * 100;
            ouperc=ouperc / nnbytes;
         } else ouperc=0;

         twork=my_atoll(nacc);
	 sprintf(wwork1,"%s",fixnum(twork));
	 sprintf(wwork2,"%s",fixnum(nnbytes));
	 sprintf(wwork3,"%s",fixnum(nnelap));

	 if(strcmp(Privacy,"yes") == 0)
            sprintf(httplink,"<font size=%s color=%s><href=http://%s>%s",	\
			    FontSize,PrivacyStringColor,PrivacyString,PrivacyString);
	 else
            sprintf(httplink,"<font size=%s><a href=http://%s>%s</A>",FontSize,url,purl);

         if(strstr(ReportType,"site_user_time_date") != 0) {
            sprintf(ltext110,"%s",text[110]);
            if(ltext110){
               for(s=ltext110; *s; ++s)
                  *s=tolower(*s);
            }
            z1=0;
            z2=0;
	    strcpy(siteind,url);
            str=siteind;
            for(z1=0; z1<=strlen(str); z1++) {
               if(str[z1]=='-')
                  str[z1]='_';
               if(str[z1]=='.')
                  str[z1]='_';
               if(str[z1]==':')
                  str[z1]='_';
               siteind[z2]=str[z1];
               z2++;
            }
	    sprintf(href2,"<a href='tt%s-%s.html' style='color:FF3333;'>",usuario,siteind);
         } else {
            bzero(href2, MAXLEN);
            bzero(ltext110, 50);
         } 

         sprintf(html,"<tr><td align=left bgcolor=%s><font size=%s>%s%s</font></td><td align=left bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</td><td align=right bgcolor=%s><font size=%s>%3.2f%%</td><td align=center bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%s</font></td><td align=right bgcolor=%s><font size=%s>%3.2f%%</font></td><td bgcolor=%s><font size=%s>%s</font></td></tr>\n",TxBgColor,FontSize,href2,ltext110,TxBgColor,FontSize,httplink,TxBgColor,FontSize,wwork1,TxBgColor,FontSize,wwork2,TxBgColor,FontSize,perc,TxBgColor,FontSize,inperc,TxBgColor,FontSize,ouperc,TxBgColor,FontSize,buildtime(nnelap),TxBgColor,FontSize,wwork3,TxBgColor,FontSize,perc2,TxBgColor,FontSize,tmsg);
         fputs(html,fp_ou);

          if(iprel) {
             strcpy(arqip,dirname);
             strcat(arqip,"/");
             strcat(arqip,usuario);
             strcat(arqip,".ip");

             if ((fp_ip = fopen(arqip, "r")) == 0){
                fprintf(stderr, "SARG: (html) %s: %s\n",text[45],arqip);
                exit(1);
	     }

             if ((fp_ip2 = fopen(tmp2, "a")) == 0){
                fprintf(stderr, "SARG: (html) %s: %s\n",text[45],tmp2);
                exit(1);
	     }

             while(fgets(buf,sizeof(buf),fp_ip)!=NULL)
             {
                if(strstr(buf,url) != 0)
                   fputs(buf,fp_ip2);
             }

             fclose(fp_ip);
             fclose(fp_ip2);

             sprintf(csort,"sort -n -T %s -k 1,1 -k 5,5 -o %s %s",TempDir,tmp3,tmp2);

             system(csort);

             if ((fp_ip = fopen(tmp3, "r")) == 0){
                fprintf(stderr, "SARG: (html) %s: %s\n",text[45],tmp3);
                exit(1);
	     }

             fscanf(fp_ip,"%s",userip);
             fscanf(fp_ip,"%s",userurl);
             fscanf(fp_ip,"%s",userdia);
             fscanf(fp_ip,"%s",userhora);
             fscanf(fp_ip,"%s",userbytes);
             fscanf(fp_ip,"%s",userelap);

             strcpy(olduserip,userip);

             while(!feof(fp_ip))
             {

	        if(strcmp(userip,olduserip) != 0) {
                   my_lltoa(unelap,val2,0);
		   sprintf(wwork1,"%s",fixnum(unbytes));
                   sprintf(html,"<tr><td align=right><font size=-2>%s</font></td><td></td><td align=right><font size=-2>%s</font></td><td></td><td></td><td align=center><font size=-2>%s</font></td><td align=right><font size=-2>%s</font></td></tr>\n",olduserip,wwork1,buildtime(unelap),val2);
                   fputs(html,fp_ou);

                   strcpy(olduserip,userip);
                   unacc=0;
                   unbytes=0;
                   unelap=0;
                }

                unbytes=unbytes+my_atoll(userbytes);
                unelap=unelap+my_atoll(userelap);

                fscanf(fp_ip,"%s",userip);
                fscanf(fp_ip,"%s",userurl);
                fscanf(fp_ip,"%s",userdia);
                fscanf(fp_ip,"%s",userhora);
                fscanf(fp_ip,"%s",userbytes);
                fscanf(fp_ip,"%s",userelap);

             }

	     fclose(fp_ip);

             unlink(tmp2);
             unlink(tmp3);

             my_lltoa(unelap,val3,0);
	     sprintf(wwork1,"%s",fixnum(unbytes));
             sprintf(html,"<tr><td align=right><font size=-2>%s</font></td><td></td><td align=right><font size=-2>%s</font></td><td></td><td></td><td align=center><font size=-2>%s</font></td><td align=right><font size=-2>%s</font></td></tr>\n",olduserip,wwork1,buildtime(unelap),val3);
             fputs(html,fp_ou);
	  }

          unacc=0;
          unbytes=0;
          unelap=0;

          fscanf(fp_in,"%s",nacc);
          fscanf(fp_in,"%s",nbytes);
          fscanf(fp_in,"%s",url);
          fscanf(fp_in,"%s",tmsg);
          fscanf(fp_in,"%s",nelap);
          fscanf(fp_in,"%s",incac);
          fscanf(fp_in,"%s",oucac);
//          fscanf(fp_in,"%s",datestimes);

       }

       if(iprel)
          unlink(arqip);
       unlink(arqin);

       strcpy(html,"<tr><td> </td></tr>");
       fputs(html,fp_ou);
       fputs(html,fp_ou);

       if(tnbytes) {
          perc=totbytes / 100;
          perc=tnbytes / perc;
       } else perc=0;

       if(tnelap) {
          perc2=totelap / 100;
          perc2=tnelap / perc2;
       } else perc2=0;

       if(tnoucache) {
          ouperc=tnoucache * 100;
          ouperc=ouperc / tnbytes;
       } else ouperc=0;

       if(tnincache) {
          inperc=tnincache * 100;
          inperc=inperc / tnbytes;
       } else inperc=0;

       sprintf(wwork1,"%s",fixnum(tnacc));
       sprintf(wwork2,"%s",fixnum(tnbytes));
       sprintf(wwork3,"%s",fixnum(tnelap));

       sprintf(html,"<tr><th></th><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,text[107],HeaderBgColor,FontSize,HeaderColor,wwork1,HeaderBgColor,FontSize,HeaderColor,wwork2,HeaderBgColor,FontSize,HeaderColor,perc,HeaderBgColor,FontSize,HeaderColor,inperc,HeaderBgColor,FontSize,HeaderColor,ouperc,HeaderBgColor,FontSize,HeaderColor,buildtime(tnelap),HeaderBgColor,FontSize,HeaderColor,wwork3,HeaderBgColor,FontSize,HeaderColor,perc2);

       fputs(html,fp_ou);
       fclose(fp_in);

       if(atoi(PerUserLimit) > 0) {
          if(tnbytes > (atoi(PerUserLimit)*1000000)) {
             limit_flag=0;
             if(access(PerUserLimitFile, R_OK) == 0) {
                if((fp_usr = fopen(PerUserLimitFile, "r")) == 0) {
                   fprintf(stderr, "SARG: (html) %s: %s\n",text[45],PerUserLimitFile);
                   exit(1);
                }
                while(fgets(tmp5,sizeof(tmp5),fp_usr)!=NULL) {
                   if(strstr(tmp5,"\n") != 0)
                      tmp5[strlen(tmp5)-1]='\0';
                   if(strcmp(tmp5,u2) == 0) {
                      limit_flag=1;
                      break;
                   }
                }
                fclose(fp_usr);
             }

             if(!limit_flag) {
                if((fp_usr = fopen(PerUserLimitFile, "a")) == 0) {
                   fprintf(stderr, "SARG: (html) %s: %s\n",text[45],PerUserLimitFile);
                   exit(1);
                }
                sprintf(html,"%s\n",u2);
                fputs(html,fp_usr);
                fclose(fp_usr);
 
                if(debug){
                   sprintf(msg, "%s %s %s (%s MB). %s %s",text[32],u2,text[74],PerUserLimit,text[75],PerUserLimitFile);
                   debuga(msg);
                }
             }
          }
       }

      strcpy(arqper,dirname);
      strcat(arqper,"/usuarios");

      if ((fp_in = fopen(arqper, "r")) == 0){
         fprintf(stderr, "SARG: (html) %s: %s\n",text[45],arqper);
         exit(1);
      }

      fgets(totuser,8,fp_in);
      fclose(fp_in);

      totbytes2=totbytes/my_atoll(totuser);
      totelap2=totelap/my_atoll(totuser);

      if(totbytes2) {
         perc = totbytes / 100;
         perc = totbytes2 / perc;
      } else perc=0;

      if(totelap2) {
         perc2 = totelap / 100;
         perc2 = totelap2 / perc2;
      } else perc2=0;

      twork2=my_atoll(totuser);
      twork=tnacc/twork2;

      sprintf(wwork1,"%s",fixnum(twork));
      sprintf(wwork2,"%s",fixnum(totbytes2));
      sprintf(wwork3,"%s",fixnum(totelap2));

      sprintf(html,"<tr><th></th><th align=left bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s></font></th><th></th><th></th><th align=center bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%s</font></th><th align=right bgcolor=%s><font size=%s color=%s>%3.2f%%</font></th></tr>\n",HeaderBgColor,FontSize,HeaderColor,text[96],HeaderBgColor,FontSize,HeaderColor,wwork1,HeaderBgColor,FontSize,HeaderColor,wwork2,HeaderBgColor,FontSize,HeaderColor,HeaderBgColor,FontSize,HeaderColor,buildtime(totelap2),HeaderBgColor,FontSize,HeaderColor,wwork3,HeaderBgColor,FontSize,HeaderColor,perc2);
      fputs(html,fp_ou);

      tnacc=0;
      tnbytes=0;
      tnelap=0;
      tnincache=0;
      tnoucache=0;

      fputs("</center></table>\n",fp_ou);

      zdate(ftime, DateFormat);
      sprintf(html,"<br><br><center><font size=-2>%s <a href='%s'>%s-%s</a> %s %s</font></center>\n",text[108],URL,PGM,VERSION,text[109],ftime);
      fputs(html,fp_ou);

      fputs("</html>\n",fp_ou);

      fclose(fp_ou);

   }

   (void)closedir( dirp );

   return;
}
