/*
** Russian codepages convertor v.3.11.
** (c)w_re -- Oleg A. Paraschenko.
** Please visit http://beta.math.spbu.ru/~prof/w_re/ for more information.
** You can contact author by E-MAIL prof@beta.math.spbu.ru
**
** For nice view of listings use tabs stops 3 chars. 
*/

#ifndef _FOR_WIN_
#ifndef _FOR_UNIX_
#ifndef _FOR_DOS_
#error It is must be defined _FOR_WIN_, _FOR_DOS_ or _FOR_UNIX_
#endif
#endif
#endif
#if defined(_FOR_UNIX_) && defined(_FOR_WIN_)
#error It is cant be defined both _FOR_WIN_ and _FOR_UNIX_
#endif
#if defined(_FOR_UNIX_) && defined(_FOR_DOS_)
#error It is cant be defined both _FOR_DOS_ and _FOR_UNIX_
#endif
#if defined(_FOR_WIN_) && defined(_FOR_DOS_)
#error It is cant be defined both _FOR_WIN_ and _FOR_DOS_
#endif
#if defined(_FOR_WIN_) || defined(_FOR_DOS_)
#define _FOR_BC_
#endif

#ifdef _FOR_BC_
#  include <conio.h>
#endif
#ifdef _FOR_WIN_
#  include <windows.h>
#endif
#ifdef _FOR_UNIX_
#  include <unistd.h>
#  include <stdio.h>
#  include <string.h>
#  include <limits.h>
#  include <fcntl.h>
#  include <sys/stat.h>
#endif
#ifdef _FOR_DOS_
#  include <stdio.h>
#  include <string.h>
#  include <io.h>
#  include <dos.h>
#  include <dir.h>
#  include <fcntl.h>
#  include <sys/stat.h>
#endif

/*
**    ,    
**     .
*/
#if defined (_FOR_DOS_) || (_FOR_UNIX_)
#define HANDLE int
#define INVALID_HANDLE_VALUE -1
#endif
#ifdef _FOR_WIN_
#define MAXPATH MAX_PATH
#endif
#ifdef _FOR_UNIX_
#define MAXPATH PATH_MAX
#endif

#define byte unsigned char
/*
** .    .  
**  ,   parse_args().
**  -   parser.h
*/
int flag_from_alt  	= 0, flag_from_koi = 0;
int flag_from_mac  	= 0, flag_from_win = 0;
int flag_to_alt    	= 0, flag_to_koi   = 0;
int flag_to_mac    	= 0, flag_to_win   = 0;
int flag_to_lat    	= 0;
int flag_cr2crlf   	= 0, flag_crlf2cr  = 0;
int flag_u2d       	= 0, flag_d2u      = 0;
int flag_u2w       	= 0, flag_w2u      = 0;
int flag_help      	= 0;
int flag_overwrite	= 0;
int flag_silence		= 0;
int flag_verbose		= 0;
int flag_close			= 0;
int flag_noclose		= 0;
/*
** xxx_suff -   ,   xxx.
**       ,  
** set_defaults      xxx_suff_def.
**   xxx_suff_user    .
*/
char *alt_suff = NULL,  *koi_suff = NULL;
char *win_suff = NULL,  *mac_suff = NULL;
char *lat_suff = NULL,  *any_suff = NULL;
char *alt_suff_def = ".alt";
char *koi_suff_def = ".koi";
char *mac_suff_def = ".mac";
char *win_suff_def = ".win";
char *lat_suff_def = ".lat";
#define ext_size 48
char alt_suff_user[ext_size + 2] = "",  koi_suff_user[ext_size + 2] = "";
char mac_suff_user[ext_size + 2] = "",  win_suff_user[ext_size + 2] = "";
char lat_suff_user[ext_size + 2] = "",  any_suff_user[ext_size + 2] = "";
/*
**  : hIn -  ,
** hXxx -    xxx.
*/
HANDLE   hIn   = INVALID_HANDLE_VALUE, hAlt  =  INVALID_HANDLE_VALUE,
         hKoi  = INVALID_HANDLE_VALUE, hWin  =  INVALID_HANDLE_VALUE,
         hMac  = INVALID_HANDLE_VALUE, hLat  =  INVALID_HANDLE_VALUE;
/*
** . pBuf_in - , pBuf_out -  
** .   :
** pBuf_xxx <= _xxx < pEnd_buf_xxx
*/
#define buf_size 4096
byte pBuf_in   [buf_size];
byte pBuf_out  [buf_size];
byte *pEnd_buf_in    = pBuf_in  + buf_size;
byte *pEnd_buf_out   = pBuf_out + buf_size;
/*
**    confile.h/xxx2yyy.h
** bytes_readed      .
*/
#ifdef _FOR_WIN_
DWORD bytes_readed;
#else
int bytes_readed;
#endif
/*
** ,     .  
** windows-  ,  ,  
**  rusconv,  .
*/
int	help_finished	=	0;
/*
** argc, argv - ,    main().
** argi -     .
*/
int  argi, argc;
char **argv;
/*
** out_dir - ,     .
*/
char   out_dir[MAXPATH + 2];

/*
** lostmem.h       .
**     LM_DEBUG,        .
*/
#include "lostmem.h"

/*
**  windows-    ,  
**  rusconv.
**  From console.h:
** void	set_title_help			(void);
** void	set_title_count	 	(int);
** void	set_title_finish		(int);
** void	close_or_not_close	(int);
*/
#ifdef _FOR_WIN_
#include "console.h"
#endif

/*
** tables.h -      .
**  From tables.h:
** byte alt2alt[];
** byte alt2koi[];
** byte koi2alt[];
** byte alt2mac[];
** byte mac2alt[];
** byte alt2win[];
** byte win2alt[];
** byte alt2lat[];
** struct oneChar;
** #define alt2lat_ext_size
** struct latChar alt2lat_ext[]
*/
#include "tables.h"

/*
** print.h -      .
**  From print.h:
** void  print_copyright            (void);
** void  print_help_tip             (void);
** int   need_more_help             (void);
** void  print_help                 (void);
** void  print_internal_error       (char*, int);
** void  print_no_ext_arg           (char*);
** void  print_ext_redefined        (char*, char*);
** void  print_ext_too_long         (char*, char*);
** void  print_parse_error          (char*);
** void  print_cant_use_both        (char*, char*);
** void  print_no_src_coding        (void);
** void	print_anysuff_manyenc		(void);
** void	print_overwrite_manyenc		(void);
** void  print_no_files             (void);
** void  print_no_dest_coding       (void);
** void  print_cant_make_temp_file  (void);
** void  print_too_long_file_name   (char*, char*, char*, char*);
** void  print_cant_open_file       (char*)
** void  print_cant_create_file     (char*);
** void  print_read_error           (char*);
** void  print_write_error          (char*);
** void  print_cant_overwrite       (char*, char*);
** void  print_no_mem               (void);
** void  print_no_such_file         (char*);
** void  print_read_only_file       (char*, char*, char*);
** void  print_no_match             (char*);
** void  print_is_dir               (char*);
** void  print_colon                (void);
** void  print_to                   (void);
** void  print_cur_file_name        (char*, char*);
** void  print_ok                   (void);
** void  print_string               (char*);
** void  print_files_converted      (int);
*/
#include "print.h"

/*
** filer.h -     .
**  from filer.h:
** struct oneFile;
** struct oneFile *files_to_convert = NULL, *last_file_in_list = NULL;
** void  free_files_mem (void);
** int   add_file_name  (char*, char*);
** int   dir_exists     (char*);
** int   create_file_list_set_out_dir (void);
*/
#include "filer.h"

/*
** parser.h -     .
**  from parser.h:
** int   set_alt_suffix    (void);
** int   set_koi_suffix    (void);
** int   set_mac_suffix    (void);
** int   set_win_suffix    (void);
** int   set_lat_suffix    (void);
** void  *minus_table[];
** void  *plus_table[];
** void  *slash_table[];
** int   find_flag_and_set  (void**, char*);
** int   parse_args         (void);
** int   validate_flags     (void);
** int   set_defaults       (void);
** int   free_buffers_mem   (void);
*/
#include "parser.h"

/*
** xxx2yyy.h -       .
**  from xxx2yyy.h:
** int from2alt (void);
** int from2koi (void);
** int from2mac (void);
** int from2lat (void);
** int from2win (void);
*/
#include "xxx2yyy.h"

/*
** convfile.h -      .
**  from convfile.h:
** int   convert_handles   (void);
** int   convert_file      (struct oneFile *);
*/
#include "convfile.h"

int
main (int argc_main, char* argv_main[]) {
   /*
   **   
   */
   struct oneFile *cur_file = NULL;
   /*
   **    
   */
   int ccode;
   /*
   **     -   rusconv.
   */
   int converted = 0;
   /****
   **  argc  argv     .
   */
   argc = argc_main;
   argv = argv_main;
   /*
   **  malloc  free    .
   */
   LM_start();
   /*
   **  .   argi =  ,
   **       
   */
   ccode = parse_args ();
   if (ccode)
      goto exit_proc;
   /*
   **    ,   
   **       .
   */
   if (flag_help) {
      print_help ();
      goto exit_proc;
   };
   /*
   **  ,     .
   */
   ccode = validate_flags ();
   if (ccode)
      goto exit_proc;
   /*
   **  , ,   '-cr2crlf', 
   **       
   ** .      .
   */
   ccode = set_defaults ();
   if (ccode)
      goto exit_proc;
   /*
   **    copyright.   :  
   **       , copyright  -
   **    ( print_no_files()).
   */
   if (flag_verbose) {
      print_copyright ();
   };
   /*
   **     .
   */
   ccode = create_file_list_set_out_dir ();
   if (ccode)
      goto exit_proc;
   if (!files_to_convert) {
      print_no_files ();
      goto exit_proc;
   };
   /*
   **    .
   */
   cur_file = files_to_convert;
   while (cur_file) {
		ccode = convert_file(cur_file);
		/*
		**   ,    .
		**  windows-    .
		*/
		if (!ccode) {
			converted++;
			#ifdef _FOR_WIN_
			set_title_count (converted);
         #endif
      };
      cur_file = cur_file->next;
      };
exit_proc:
   /*
   **   .     ( 
   ** LM_DEBUG) ,        .
   */
   free_files_mem   ();
   LM_finish();
   /*
   **     .
	*/
	print_files_converted (converted);
	/*
	**  windows-     .
	**  ,     ,   .
	*/
	#ifdef _FOR_WIN_
		close_or_not_close (converted);
	#endif
	/*
	**     -   rusconv.
	*/
	return converted;
};







