/*
** convfile.h -    rusconv.c.
**      ,    .
**   - 14  1998 .
** (c)w_re --  .
*/

#ifdef _FOR_BC_
#define TMPSTR "\\rcXXXXXX"
#define SLASHSTR "\\"
#endif
#ifdef _FOR_UNIX_
#define TMPSTR "/rcXXXXXX"
#define SLASHSTR "/"
#endif

/*
** convert_handles()  ,   .
**    flag_from_xxx,
** flag_to_xxx, hIn, hXxx, bytesReaded.
**     ,     .
**  :
**  0 -  ok.
** 11 -    .
** 21 -       .
** 22 -       -8.
** 23 -       Macintosh.
** 24 -       .
** 25 -       Windows.
** !0 -  .
*/
int
convert_handles (void) {
   int ccode = 0;
   /*
   **     
   **      .   
   **     
   ** from2alt, from2koi, from2mac, from2lat  from2win,
   **      bytes_readed -
   **      .
   */
   while (1) {
      /*
      **  ?
      */
      #ifdef _FOR_WIN_
      if (!ReadFile (hIn, pBuf_in, buf_size, &bytes_readed, NULL)) {
         ccode = 11;
         goto exit_proc;
      };
      #else
      bytes_readed = read (hIn, pBuf_in, buf_size);
      if (bytes_readed == -1) {
         ccode = 11;
         goto exit_proc;
      };
      #endif
      /*
      **  ?
      */
      if (!bytes_readed) {
         ccode = 0;
         goto exit_proc;
      };
      /*
      **     
      */
      if (flag_to_alt) {
         if       (flag_from_alt)   ccode = do_alt2alt ();
         else if  (flag_from_koi)   ccode = do_koi2alt ();
         else if  (flag_from_mac)   ccode = do_mac2alt ();
         else if  (flag_from_win)   ccode = do_win2alt ();
         if (ccode) {
            ccode = 21;
            goto exit_proc;
         };
      };
      /*
      **     -8
      */
      if (flag_to_koi) {
         if       (flag_from_alt)   ccode = do_alt2koi ();
         else if  (flag_from_koi)   ccode = do_koi2koi ();
         else if  (flag_from_mac)   ccode = do_mac2koi ();
         else if  (flag_from_win)   ccode = do_win2koi ();
         if (ccode) {
            ccode = 22;
            goto exit_proc;
         };
      };
      /*
      **     Macintosh
      */
      if (flag_to_mac) {
         if       (flag_from_alt)   ccode = do_alt2mac ();
         else if  (flag_from_koi)   ccode = do_koi2mac ();
         else if  (flag_from_mac)   ccode = do_mac2mac ();
         else if  (flag_from_win)   ccode = do_win2mac ();
         if (ccode) {
            ccode = 23;
            goto exit_proc;
         };
      };
      /*
      **     
      */
      if (flag_to_lat) {
         if       (flag_from_alt)   ccode = do_alt2lat ();
         else if  (flag_from_koi)   ccode = do_koi2lat ();
         else if  (flag_from_mac)   ccode = do_mac2lat ();
         else if  (flag_from_win)   ccode = do_win2lat ();
         if (ccode) {
            ccode = 24;
            goto exit_proc;
         };
      };
      /*
      **     Windows
      */
      if (flag_to_win) {
         if       (flag_from_alt)   ccode = do_alt2win ();
         else if  (flag_from_koi)   ccode = do_koi2win ();
         else if  (flag_from_mac)   ccode = do_mac2win ();
         else if  (flag_from_win)   ccode = do_win2win ();
         if (ccode) {
            ccode = 25;
            goto exit_proc;
         };
      };
   };   /* end of while(1) -   */
exit_proc:
   return ccode;
}; /* convert_handles (); */

/*
** convert_file() -      .
** cur_file -    ,   
**               ,    .
**    ,    - 0,  - !0
*/
int
convert_file (struct oneFile *cur_file) {
   char  fname_in    [MAXPATH + 2],
         fname_alt   [MAXPATH + 2],
         fname_koi   [MAXPATH + 2],
         fname_mac   [MAXPATH + 2],
         fname_lat   [MAXPATH + 2],
         fname_win   [MAXPATH + 2],
         fname_noext [MAXPATH + 2];
   char  *tmp, *fname_out = NULL;
   int   ccode = 0, len = 0;
   /*
   **   Windows-    .   
   **    SECURITY_ATTRIBUTES,     .
   */
   #ifdef _FOR_WIN_
      SECURITY_ATTRIBUTES sec_attr = {
         sizeof (SECURITY_ATTRIBUTES), NULL, FALSE
      };
   #endif
   hIn = hAlt = hKoi = hMac = hLat = hWin = INVALID_HANDLE_VALUE;
   /*
   **   .   -  
   **  (out_dir) +    + 
   **  (.alt, .koi, .mac, .lat  .win).  
   **    fname_alt, fname_koi, fname_mac,
   ** fname_lat  fname_win.      ,
   **        ,   .
   **       fname_out.
   **       fname_in.
   */
   *fname_in   = *fname_alt   = *fname_koi = '\0';
   *fname_mac  = *fname_lat   = *fname_win = '\0';
   *fname_noext   = '\0';
   /*
   **  ,    .
   */
   print_file_name (cur_file->dir_name, cur_file->file_name);
   /*
   **     .
	*/
	if (strlen (cur_file->file_name) + 2 > MAXPATH) {
		print_colon ();
		print_too_long_file_name (cur_file->file_name, "", "", "");
		ccode = 1;
		goto close_all;
	};
	strcpy (fname_noext, cur_file->file_name);
	tmp = strrchr (fname_noext, '.');
	if (tmp) *tmp = '\0';
	/*
	**    ,     .
	*/
	if (flag_overwrite) {
		if (flag_to_alt)
			fname_out = fname_alt;
		if (flag_to_koi)
			fname_out = fname_koi;
		if (flag_to_mac)
			fname_out = fname_mac;
		if (flag_to_lat)
			fname_out = fname_lat;
		if (flag_to_win)
			fname_out = fname_win;
		#ifndef _FOR_WIN_
		if (strlen (cur_file->dir_name) + sizeof (TMPSTR) + 2 > MAXPATH) {
			print_colon ();
			print_too_long_file_name (cur_file->dir_name, "", TMPSTR, "");
			print_cant_make_temp_file ();
			ccode = 1;
			goto close_all;
		};
		strcpy (fname_out, cur_file->dir_name);
		strcat (fname_out, TMPSTR);  /* "\\rcXXXXXX"  "/rcXXXXXX" */
		if (!mktemp (fname_out)) {
			print_colon ();
			print_cant_make_temp_file ();
			ccode = 1;
			goto close_all;
		};
		#endif
		#ifdef _FOR_WIN_
		/*
		**  -   Windows  ...
		**  fname_out    ,  MAX_PATH .
		**   ,   help.
		*/
		if (!GetTempFileName (cur_file->dir_name, "rc", 0, fname_out)) {
			print_colon ();
			print_cant_make_temp_file ();
			ccode = 1;
			goto close_all;
		};
		#endif
		/*
		**      .
		*/
		print_to ();
		print_string (fname_out);
	} else { /* !flag_overwrite */
	/*
	**     ,     ,
	**       .
	*/
		len = strlen (out_dir) + strlen (fname_noext) + 2;
		/*
		**   .alt-    .
		*/
		if(flag_to_alt) {
			if (len + strlen (alt_suff) > MAXPATH) {
				print_colon ();
				print_too_long_file_name (out_dir, SLASHSTR,
							fname_noext, alt_suff);
				ccode = 1;
				goto close_all;
			};
			strcpy (fname_alt, out_dir);
			strcat (fname_alt, SLASHSTR); /* "\\" or "/" */
			strcat (fname_alt, fname_noext);
			strcat (fname_alt, alt_suff);
			print_to ();
			print_string (fname_alt);
		};
		/*
		**   .koi-    .
		*/
		if(flag_to_koi) {
			if (len + strlen (koi_suff) > MAXPATH) {
				print_colon ();
				print_too_long_file_name (out_dir, SLASHSTR,
							fname_noext, koi_suff);
				ccode = 1;
				goto close_all;
			};
			strcpy (fname_koi, out_dir);
			strcat (fname_koi, SLASHSTR); /* "\\" or "/" */
			strcat (fname_koi, fname_noext);
			strcat (fname_koi, koi_suff);
			/*
			**         ,  
			** ,      ,  ,
			**  '->',    ','.
			*/
			if (flag_to_alt) {
				print_comma ();
			} else {
				print_to ();
			};
			print_string (fname_koi);
		};
		/*
		**   .mac-    .
		*/
		if(flag_to_mac) {
			if (len + strlen (mac_suff) > MAXPATH) {
				print_colon ();
				print_too_long_file_name (out_dir, SLASHSTR,
							fname_noext, mac_suff);
				ccode = 1;
				goto close_all;
			};
			strcpy (fname_mac, out_dir);
			strcat (fname_mac, SLASHSTR); /* "\\" or "/" */
			strcat (fname_mac, fname_noext);
			strcat (fname_mac, mac_suff);
			if (flag_to_alt || flag_to_koi) {
				print_comma ();
			} else {
				print_to ();
			};
			print_string (fname_mac);
		};
		/*
		**   .lat-    .
		*/
		if(flag_to_lat) {
			if (len + strlen (lat_suff) > MAXPATH) {
				print_colon ();
				print_too_long_file_name (out_dir, SLASHSTR,
							fname_noext, lat_suff);
				ccode = 1;
				goto close_all;
			};
			strcpy (fname_lat, out_dir);
			strcat (fname_lat, SLASHSTR); /* "\\" or "/" */
			strcat (fname_lat, fname_noext);
			strcat (fname_lat, lat_suff);
			if (flag_to_alt || flag_to_koi || flag_to_mac) {
				print_comma ();
			} else {
				print_to ();
			};
			print_string (fname_lat);
		};
		/*
		**   .win-    .
		*/
		if(flag_to_win) {
			if (len + strlen (win_suff) > MAXPATH) {
				print_colon ();
				print_too_long_file_name (out_dir, SLASHSTR,
							fname_noext, win_suff);
				ccode = 1;
				goto close_all;
			};
			strcpy (fname_win, out_dir);
			strcat (fname_win, SLASHSTR); /* "\\" or "/" */
			strcat (fname_win, fname_noext);
			strcat (fname_win, win_suff);
			if (flag_to_alt || flag_to_koi || flag_to_mac || flag_to_lat) {
				print_comma ();
			} else {
				print_to ();
			};
			print_string (fname_win);
		};
	}; /* end of if (flag_overwrite) else ... */
	/*
	**   ,   .
	*/
	if (strlen (cur_file->dir_name) + strlen (cur_file->file_name) >
		 MAXPATH - 2) {
		print_too_long_file_name (cur_file->dir_name, SLASHSTR,
					cur_file->file_name, "");
		ccode = 1;
		goto close_all;
	};
	strcpy (fname_in, cur_file->dir_name);
	strcat (fname_in, SLASHSTR);
   strcat (fname_in, cur_file->file_name);
   /*
   **    ,    
   **   .      ,
   **   .
   */
   if (flag_overwrite) {
      print_to ();
      print_string (fname_in);
   };
   print_colon ();
   /*
   **  .   - .
   **
   ** Dos-.
   */
   #ifdef _FOR_DOS_
      #define OPEN_IN_FILE \
         hIn = open (fname_in, O_RDONLY|O_BINARY)
      #define CREATE_FILE(handle, name) \
         handle = open (name, O_CREAT|O_TRUNC|O_WRONLY|O_BINARY, \
         S_IREAD|S_IWRITE)
   #endif
   /*
   ** UNIX-.
	*/
	#ifdef _FOR_UNIX_
		#define O_FLAGS O_CREAT|O_TRUNC|O_WRONLY
		#define S_FLAGS S_IRUSR|S_IWUSR|S_IRGRP|S_IWGRP|S_IROTH|S_IWOTH
		#define OPEN_IN_FILE hIn = open (fname_in, O_RDONLY)
		#define CREATE_FILE(handle, name) handle = open (name, O_FLAGS, S_FLAGS)
	#endif
	/*
	** Windows-    .     
	**  SECURITY_ATTRIBUTES,     .
	*/
	#ifdef _FOR_WIN_
		/*
		** #define   .
		*/
		#define OPEN_IN_FILE \
			hIn = CreateFile \
			(fname_in, GENERIC_READ, FILE_SHARE_READ, &sec_attr, \
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, \
			INVALID_HANDLE_VALUE)
		/*
		** #define   .
		*/
		#define CREATE_FILE(handle, name) \
         handle = CreateFile \
         (name, GENERIC_WRITE, FILE_SHARE_READ, &sec_attr, \
         CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL | FILE_FLAG_SEQUENTIAL_SCAN, \
         INVALID_HANDLE_VALUE)
   #endif
   hIn = hAlt = hKoi = hMac = hLat = hWin = INVALID_HANDLE_VALUE;
   /*
   **   .
   */
   OPEN_IN_FILE;
   if (hIn == INVALID_HANDLE_VALUE) {
      print_cant_open_file (fname_in);
      ccode = 1;
      goto close_all;
   };
   /*
   **     
   */
   if (flag_to_alt) {
      CREATE_FILE (hAlt, fname_alt);
      if (hAlt == INVALID_HANDLE_VALUE) {
         print_cant_create_file (fname_alt);
         ccode = 1;
         goto close_all;
      };
   };
   /*
   **     -8
   */
   if (flag_to_koi) {
      CREATE_FILE (hKoi, fname_koi);
      if (hKoi == INVALID_HANDLE_VALUE) {
         print_cant_create_file (fname_koi);
         ccode = 1;
         goto close_all;
      };
   };
   /*
   **     Macintosh
   */
   if (flag_to_mac) {
      CREATE_FILE (hMac, fname_mac);
      if (hMac == INVALID_HANDLE_VALUE) {
         print_cant_create_file (fname_mac);
         ccode = 1;
         goto close_all;
      };
   };
   /*
   **     
   */
   if (flag_to_lat) {
      CREATE_FILE (hLat, fname_lat);
      if (hLat == INVALID_HANDLE_VALUE) {
         print_cant_create_file (fname_lat);
         ccode = 1;
         goto close_all;
      };
   };
   /*
   **     Windows
   */
   if (flag_to_win) {
      CREATE_FILE (hWin, fname_win);
      if (hWin == INVALID_HANDLE_VALUE) {
         print_cant_create_file (fname_win);
         ccode = 1;
         goto close_all;
      };
   };
   /*
   **  !    .
   **   -   convert_handles().
   */
   ccode = convert_handles ();
   if (ccode) {
      if (ccode == 11)
         print_read_error (fname_in);
      if (ccode == 21)
         print_write_error (fname_alt);
      if (ccode == 22)
         print_write_error (fname_koi);
      if (ccode == 23)
         print_write_error (fname_mac);
      if (ccode == 24)
         print_write_error (fname_lat);
      if (ccode == 25)
         print_write_error (fname_win);
		goto close_all;
	};
	/*
   **     .  .
   **         
   ** ,   .
   */
close_all:
   #ifdef _FOR_WIN_
   #define CLOSE(arg)   CloseHandle(arg)
   #else
   #define CLOSE(arg)   close(arg)
   #endif
   if (hAlt != INVALID_HANDLE_VALUE) CLOSE (hAlt);
   if (hKoi != INVALID_HANDLE_VALUE) CLOSE (hKoi);
   if (hMac != INVALID_HANDLE_VALUE) CLOSE (hMac);
   if (hLat != INVALID_HANDLE_VALUE) CLOSE (hLat);
   if (hWin != INVALID_HANDLE_VALUE) CLOSE (hWin);
   if (hIn  != INVALID_HANDLE_VALUE) CLOSE (hIn);
   if (ccode || !flag_overwrite)
		goto  exit_proc;
	/*
	**     .
	**   .
	*/
	#ifdef _FOR_WIN_
	ccode = !DeleteFile (fname_in);
	#else
	ccode = remove (fname_in);
	#endif
	if (ccode) {
		print_cant_overwrite (fname_in, fname_out);
		ccode = 1;
		goto exit_proc;
	};
	/*
	**      .
	*/
	#ifdef _FOR_WIN_
   ccode = !MoveFile (fname_out, fname_in);
   #else
   ccode = rename (fname_out, fname_in);
   #endif
   if(ccode) {
      print_cant_overwrite (fname_in, fname_out);
      ccode = 1;
      goto exit_proc;
   };
exit_proc:
   /*
   **     ,  'ok'.
   */
   if (!ccode) {
      print_ok ();
   };
   return ccode;
};

