/*
** print.h -    rusconv.c.
**      .
**   - 14  1998 .
** (c)w_re --  .
*/

/*
** print_copyright()     .   
**  Widows    rusconv'a,   
**    ,     .
*/
void
print_copyright (void) {
   int i;
   if (flag_silence)
      return;
   #ifdef _FOR_BC_
   for (i = 0; i < argc; i++) {
      printf ("%s ", argv[i]);
   };
   printf ("\n");
	#endif
	printf ("** rusconv -- convertor of Russian codepages, v.3.11.\n");
	printf ("** (c)w_re -- Oleg A. Paraschenko  http://beta.math.spbu.ru/~prof/w_re/\n");
};

/*
** print_help_tip()    .
*/
void
print_help_tip (void) {
   if (flag_silence)
      return;
   printf ("try 'rusconv -h' or read the manual for help.\n");
};

#ifdef _FOR_BC_
/*
** need_more_help()         
** ,     .  UNIX'    .
*/
int
need_more_help (void) {
   int   ccode = 1;
   char  ch;
   if (flag_silence)
      return ccode;
   printf ("Press <ENTER> for more help or q/Q to exit...\n");
   ch = (char) getch ();
   if ((ch == 'q') || (ch == 'Q'))
      ccode = 0;
   return ccode;
};

/*
**  ,   .
**  DOS/WINDOWS  - .
*/
void
print_help (void) {
	/*
	**  windows-   ,    rusconv,
   ** ,   .
	*/
	#ifdef _FOR_WIN_
	set_title_help ();
	#endif
	help_finished	=	0;
   puts ("** rusconv -- convertor of Russian codepages, v.3.11.");
   puts ("** (c)w_re -- Oleg A. Paraschenko  http://beta.math.spbu.ru/~prof/w_re/");
	puts ("Examples of usage:");
   puts ("-   >rusconv -koi +alt +koi +win +mac +lat file1.txt file2.txt d:\\txt\\ ");
   puts ("Program supposes that files 'file1.txt' and 'file2.txt' are");
   puts ("in koi-8 codepage and converts them to other codepages. They are:");
   puts ("alternative(dos), koi-8(unix), windows, macintosh and latinica.");
   puts ("Corresponding files are 'file1.alt', 'file1.koi', 'file1.win',");
   puts ("'file1.mac', 'file1.lat' and 'file2.alt' ... 'file2.lat'.");
   puts ("They are placed in directory 'd:\\txt'.");
   puts ("--  >rusconv -cr2crlf -o \\\\server\\d\\files\\*.txt ");
   puts ("Program changes content of text files in remote directory");
   puts ("from unix style of text files (end of line coded by one code '10')");
   puts ("to dos/windows one (end of line coded by two codes '13' '10').");
	puts ("--- >rusconv -unix2win -ext html koi\\*.html win\\");
   puts ("Program converts html-files in directory 'koi' from unix text");
   puts ("to windows text and puts files to directory 'win' with");
   puts ("extension 'html'. This command is the same as");
   puts (">rusconv -koi +win -cr2crlf -wext html koi\\*.html win\\");
   puts ("");
   puts ("The above usage is only a very basic example of rusconv's capability.");
	if (!need_more_help ())
      goto  exit_proc;
   puts ("Usage:");
   puts (" rusconv -h");
   puts (" rusconv [options] -(alt|koi|mac|win) +(alt|koi|mac|lat|win) [--]");
   puts ("         <file_list> [output_dir]");
   puts (" rusconv [options] -(cr2crlf|crlf2cr) [--] <file_list> [output_dir]");
   puts (" rusconv [options] -(dos2unix|win2unix|unix2dos|unix2win|d2u|w2u|u2d|u2w)");
   puts ("         [--] <file_list> [output_dir]");
   puts ("");
   puts ("1) >rusconv -h");
   puts ("Print this help.");
   puts ("");
   puts ("2) >rusconv [options] -(alt|koi|mac|win) +(alt|koi|mac|lat|win) [--]");
   puts ("         <file_list> [output_dir]");
   puts ("Program converts files in <file_list> from the encoding -xxx");
   puts ("to +xxx. Output are placed in files with default extensions");
	puts ("'.alt', '.koi', '.mac', '.lat', '.win' in current directory");
	puts ("or in output_dir, if specified.");
	puts ("Options:");
	puts (" -noclose - Do not close window after rusconv finished, by default.");
	puts (" -close   - Close window after rusconv finished. Flags 'close' and 'noclose'");
	puts ("            are usefull only in windows version.");
	puts ("");
	if (!need_more_help ())
		goto  exit_proc;
	puts (" -s       - Silent mode, do not output messages.");
	puts (" -v       - Verbose mode, print a lot of massages, default for");
	puts ("            DOS/WINDOWS-version. Can't be used with '-s' flag.");
	puts (" -cr2crlf - Convert from UNIX to DOS text file format.");
	puts (" -crlf2cr - Convert from DOS to UNIX text file format.");
	puts ("            You can specify only one of flags '-cr2crlf' and '-crlf2cr'.");
	puts (" -aext <extension>,   -kext <extension>,   -mext <extension>,");
	puts (" -lext <extension>,   -wext <extension>,   -ext  <extension>");
	puts ("            Define extensions for encodings: alternative, koi-8,");
	puts ("            macintosh, latinica, windows. Defaults extensions are");
	puts ("            '.alt', '.koi', '.mac', '.lat' and '.win'. If you translate");
	puts ("            only to one encoding, you can use command '-ext'.");
	puts (" -o       - Overwrite converting files. Instead of creating new files");
	puts ("            program changes content of given files. In this case");
	puts ("            you can specify only one target codepage.");
	puts ("Codepages:");
	puts (" alt:  Used by MS-DOS.");
	puts (" koi:  Used by UNIX and in Russian Internet.");
	puts (" mac:  Used by Macintosh.");
	puts (" win:  Used by Windows.");
	puts (" lat:  Latinica, russian text spelled latin letters.");
	puts ("       You can't translate from this encoding.");
	puts ("");
	if (!need_more_help ())
		goto  exit_proc;
	puts ("3) >rusconv [options] -(cr2crlf|crlf2cr) [--] <file_list> [output_dir]");
	puts ("");
	puts ("Program converts files in <file_list> from dos/windows text file");
	puts ("style to unix one, and vice versa. Output are placed in files with");
	puts ("extensions '.cr' (unix style) and '.crlf' (dos style) in current directory.");
	puts ("Output directory and extensions can be defined by user.");
	puts ("");
	puts ("Valid options:");
	puts (" -s     - Silent work.");
	puts (" -v     - Verbose work.");
	puts (" -o     - Overwrite files.");
	puts (" -suff <extension>   - redefine default extensions ('.cr' and '.crlf')");
	puts ("");
	puts ("4) >rusconv [options] -(dos2unix|win2unix|unix2dos|unix2win|d2u|w2u|u2d|u2w)");
	puts ("         [--] <file_list> [output_dir]");
	puts (" -dos2unix (or -d2u)   stands for '-alt +koi -crlf2cr'.");
	puts (" -win2unix (or -w2u)   stands for '-win +koi -crlf2cr'.");
	puts (" -unix2dos (or -u2d)   stands for '-koi +alt -cr2crlf'.");
	puts (" -unix2win (or -u2w)   stands for '-koi +win -cr2crlf'.");
   puts ("This options replace most often combinations of flags:");
   puts ("it is all you need for translating russian files between");
   puts ("most popular operating systems.");
   puts ("");
   if (!need_more_help ())
		goto  exit_proc;
	puts ("");
	puts ("For more help please read the manual or visit homepage of rusconv:");
	puts ("http://beta.math.spbu.ru/~prof/w_re/");
	puts ("(c)w_re -- Oleg A. Paraschenko");
	help_finished	=	1;
exit_proc:
	return;
};          /* print_help() */
#endif      /* #ifdef _FOR_BC_  */

/*
**  UNIXa    -    .
*/
#ifdef _FOR_UNIX_
void
print_help (void) {
	puts ("** rusconv -- convertor of Russian codepages, v.3.11.");
	puts ("** (c)w_re -- Oleg A. Paraschenko  http://beta.math.spbu.ru/~prof/w_re/");
	puts (" rusconv -h");
	puts (" rusconv [options] -(alt|koi|mac|win) +(alt|koi|mac|lat|win) [--]");
	puts ("         <file_list> [output_dir]");
	puts (" rusconv [options] -(cr2crlf|crlf2cr) <file_list> [--] [output_dir]");
	puts (" rusconv [options] -(dos2unix|win2unix|unix2dos|unix2win|d2u|w2u|u2d|u2w)");
	puts ("         [--] <file_list> [output_dir]");
	puts ("Program converts files in <file_list> from the encoding -xxx to +xxx. Output");
	puts ("are placed in files with extensions '.alt', '.koi', '.mac', '.lat', '.win'");
	puts ("in current directory or in output_dir, if specified.");
	puts (" -s       - Silent mode.");
	puts (" -v       - Verbose mode.");
	puts (" -cr2crlf - Convert from UNIX to DOS text file format.");
	puts (" -crlf2cr - Convert from DOS to UNIX text file format.");
	puts (" -o       - Overwrite converting files.");
	puts (" -aext, -kext, -mext, -lext, -wext, -ext <extension>");
	puts ("            Redefine default extensions");
	puts (" -d2u == '-alt +koi -crlf2cr'        -w2u == '-win +koi -crlf2cr'");
	puts (" -u2d == '-koi +alt -cr2crlf'        -u2w == '-koi +win -cr2crlf'");
	puts (" -dos2unix==d2u    -win2unix==w2u    -unix2dos==u2d    -unix2win==u2w");
	puts ("For more information please read the manual or visit");
	puts ("homepage of rusconv at http://beta.math.spbu.ru/~prof/w_re/");
};       /* print_help() */
#endif   /* #ifdef _FOR_UNIX_ */

/*
**    ,   
**  .        ,
**      ,    
**   .
**  file -     ,   .
**  line -    .
*/
void
print_internal_error (char *file, int line) {
   if (flag_silence)
      return;
   printf ("\nerror: sorry, internal error has been detected\n");
   printf ("\t in source file '%s' on line %i.\n", file, line);
   printf ("\t please inform us about it by email prof@beta.math.spbu.ru\n");
};
  
/*
** print_no_ext_arg()    set_xxx_ext, 
**    -   .
** comm -      (aext, kext, mext, wext).
*/
void
print_no_ext_arg (char *comm) {
   if (flag_silence)
      return;
   print_copyright ();
   printf ("error: argument missed after '%s'.\n", comm);
   print_help_tip ();
};

/*
** print_ext_redefined()    set_xxx_ext, 
**       .
**  comm -    
**  ext  -  
*/
void
print_ext_redefined (char *comm, char *ext) {
   if (flag_silence)
      return;
   print_copyright ();
   printf ("error: '%s %s': extension yet defined.\n", comm, ext);
   print_help_tip ();
};

/*
** print_ext_too_long()    set_xxx_ext, 
**     .
** comm -    
** ext  - 
*/
void
print_ext_too_long (char *comm, char *ext) {
   if (flag_silence)
      return;
   print_copyright ();
	printf ("error: '%s %s': extension too long. ", comm, ext);
   printf ("Please use not more than %i symbols.\n", ext_size);
   print_help_tip ();
};

/*
** print_parse_error() ,    
**    .
** flag -    .
*/
void
print_parse_error (char* flag) {
   if (flag_silence)
      return;
   print_copyright ();
   printf ("error: unrecognized flag '%s'.\n", flag);
   print_help_tip ();
};

/*
** print_cant_use_both()     
** ,     .
**  flag1  -   
**  flag2  -   
*/
void
print_cant_use_both (char *flag1, char *flag2) {
   if (flag_silence)
      return;
   print_copyright ();
   printf ("error: flags '%s' and '%s' can't be used together.\n",
      flag1, flag2);
   print_help_tip ();
};

/*
** print_no_src_coding()     
** ,    ,   .
*/
void
print_no_src_coding (void) {
   print_copyright ();
   if (flag_silence)
      return;
   printf ("error: you forgot to specify source encoding.\n");
   print_help_tip ();
};


/*
** print_no_files() ,      
**   .
*/
void
print_no_files (void) {
   if (flag_silence)
      return;
   printf ("error: no files to convert.\n");
   print_help_tip ();
};

/*
** print_no_dest_coding()     
** ,    ,   .
*/
void
print_no_dest_coding (void) {
	print_copyright ();
	if (flag_silence)
		return;
	printf ("error: you forgot to specify target encoding.\n");
	print_help_tip ();
};

/*
**        
**    ,   - .
*/
void
print_anysuff_manyenc (void){
	print_copyright ();
	if (flag_silence)
		return;
	printf ("error: only one target encoding can be used with flag 'ext'.\n");
	print_help_tip ();
};

/*
**        
**    ,   - .
*/
void
print_overwrite_manyenc (void){
	print_copyright ();
	if (flag_silence)
		return;
	printf ("error: only one target encoding can be used with file overwriting.\n");
	print_help_tip ();
};

/*
** print_cant_make_temp_file() ,   
**    .
*/
void
print_cant_make_temp_file (void) {
   if (flag_silence)
      return;
   printf ("error: can't make name for temporary file.\n");
};

/*
** print_too_long_file_name() ,     
**  path, slash, name, ext -   
*/
void
print_too_long_file_name (char *path, char *slash, char *name, char *ext) {
   if (flag_silence)
      return;
   printf ("error: file name too long: '%s%s%s%s'.\n",
      path, slash, name, ext);
};

/*
** print_cant_open_file() ,     .
**  fname -  .
*/
void
print_cant_open_file (char *fname) {
   if (flag_silence)
      return;
   printf ("error: can't open file '%s'.\n", fname);
};

/*
** print_cant_create_file() ,     .
**  fname -  .
*/
void
print_cant_create_file (char *fname) {
   if (flag_silence)
      return;
   printf ("error: can't create file '%s'.\n", fname);
};

/*
** print_read_error() ,    
**   .
**  fname -  .
*/
void
print_read_error (char *fname) {
   if (flag_silence)
      return;
   printf ("error: error reading file '%s'.\n", fname);
};

/*
** print_write_error() ,    
**   .
**  fname -  .
*/
void
print_write_error (char *fname) {
   if (flag_silence)
      return;
   printf ("error: error writing file '%s'.\n", fname);
};

/*
** print_cant_overwrite() ,     
**    .
**  src  -  .
**  file - ,    .
*/
void
print_cant_overwrite (char *src, char *file) {
   if (flag_silence)
      return;
   printf ("error: can't replace file '%s' by file '%s'.\n", src, file);
};

/*
** print_no_mem()    .
*/
void
print_no_mem (void) {
   if (flag_silence)
      return;
   printf ("error: not enough memory.\n");
};

/*
** print_no_such_file() ,    .
**  fname -  .
*/
void
print_no_such_file (char *fname) {
   if (flag_silence)
      return;
   printf ("error: file '%s' does not exists.\n", fname);
};

/*
** print_is_dir() ,       .
**  dir -  .
*/
void
print_is_dir (char *dir) {
   if (flag_silence)
      return;
   printf ("warning: '%s' is a directory, skipping.\n", dir);
};

/*
** print_read_only() ,    
**       read-only.
**  path, slash, name -   .
*/
#ifdef _FOR_BC_
void
print_read_only_file (char *path, char *slash, char *name) {
	if (flag_silence)
		return;
	printf ("warning: '%s%s%s' is read-only, skipping.\n", path, slash, name);
};
#endif

/*
** print_no_match() ,     ,
**  findfirst/findnext,   .
**  pattern - .
*/
#ifdef _FOR_BC_
void
print_no_match (char *pattern) {
   if (flag_silence)
      return;
   printf ("warning: pattern '%s' produce no files.\n", pattern);
};
#endif

/*
** print_colon()     ': '
*/
void
print_colon (void) {
   if (flag_silence || !flag_verbose)
      return;
   printf (": ");
};

/*
** print_to()     ' -> '
*/
void
print_to (void) {
   if (flag_silence || !flag_verbose)
      return;
   printf (" -> ");
};

/*
** print_comma()     ', '
*/
void
print_comma (void) {
   if (flag_silence || !flag_verbose)
      return;
   printf (", ");
};

/*
** print_cur_file_name()     
**  file -  .
**  dir  - ,   .
*/
void
print_file_name (char *dir, char *file) {
   if (flag_silence || !flag_verbose)
      return;
   #ifdef _FOR_UNIX_
   printf ("%s/%s", dir, file);
   #else
   printf ("%s\\%s", dir, file);
   #endif
};

/*
** print_string()    puts().
**  str -   .
*/
void
print_string (char *str) {
   if (flag_silence || !flag_verbose)
      return;
   printf ("%s", str);
};

/*
** print_ok() ,  ,    .
*/
void
print_ok (void) {
   if (flag_silence || !flag_verbose)
      return;
   printf ("ok.\n");
};

/*
** print_files_converted() ,    .
**  n -   .
*/
void
print_files_converted (int n) {
   if (flag_silence || !flag_verbose)
      return;
   printf ("%d file(s) converted.\n", n);
};

