/*
** filer.h -    rusconv.c.
**     .
**   - 14  1998 .
** (c)w_re --  .
*/

/*
**   files_to_convert   ,
**   ,  ,  
**  . last_file_in_list   
**   .
*/
struct oneFile {
   char           *dir_name;
   char           *file_name;
   struct oneFile *next;
};
struct oneFile *files_to_convert = NULL, *last_file_in_list = NULL;

/*
**        ,
**  .
*/
void
free_files_mem (void) {
   struct oneFile *tmp, *cur;
   cur = files_to_convert;
   while (cur) {
      tmp = cur->next;
      Free (cur->dir_name);
      Free (cur->file_name);
      Free (cur);
      cur = tmp;
   };
   files_to_convert  = NULL;
   last_file_in_list = NULL;
};

/*
**        .
**  file_name -  
**  dir_name  - ,     
**  file_name, dir_name   
**  ,     .
**  :
**  0 -  
** !0 - 
*/
int
add_file_name (char const *dir_name, char const *file_name) {
   struct oneFile *node       = NULL;
   char           *file_loc   = NULL,
                  *dir_loc    = NULL;
   int            ccode       = 1;
   /*
   **   
   */
   node     = (struct oneFile*)Malloc (sizeof (struct oneFile));
   file_loc = (char*)Malloc (strlen (file_name) + 2);
   dir_loc  = (char*)Malloc (strlen (dir_name)  + 2);
   if (! (node && file_loc && dir_loc)) {
      goto err_exit;
   };
   /*
   **  
   */
   strcpy (dir_loc,  dir_name);
   strcpy (file_loc, file_name);
   node->dir_name  = dir_loc;
   node->file_name = file_loc;
   node->next      = NULL;
   /*
   **     
   */
   if (last_file_in_list) {
      last_file_in_list->next = node;
      last_file_in_list = node;
      ccode = 0;
      goto exit_proc;
   };
   /*
   ** if (last_file_in_list == NULL) -    . 
   */
   last_file_in_list = files_to_convert = node;
   ccode = 0;
   goto exit_proc;
   /*
   **  -  ,   .
   */
err_exit:
   ccode = 1;
   print_no_mem ();
   if (!node)
      goto exit_proc;
   if (node->dir_name)
      Free (node->dir_name);
   if (node->file_name)
      Free (node->file_name);
   Free (node);
exit_proc:
   return ccode;
};

/*
** dir_exists() ,    .
**    ,  stat()  DOS'
**  -     (, smth\*.*)
** ,   - .
**  :
**  !0 -   
**   0 -    
*/
#ifdef _FOR_UNIX_
int
dir_exists (char *dir) {
	struct stat statbuf;
	int   ccode = 0;
	if (stat (dir, &statbuf))
		goto  exit_proc;
	ccode = (statbuf.st_mode & S_IFDIR);
exit_proc:
	return ccode;
};
#endif

#ifdef _FOR_DOS_
int
dir_exists (char* dir) {
	struct stat statbuf;
	int   ccode = 0;
	/*
	**   (Windows98) stat (*.*) , 
	** *.* -  ...      -
	**     .   ,
	**   -   .
	*/
	if (strchr (dir, '*'))
		goto	exit_proc;
	if (strchr (dir, '?'))
   	goto	exit_proc;
	/*
	**  -  .
	*/
	if (stat (dir, &statbuf))
		goto  exit_proc;
	ccode = (statbuf.st_mode & S_IFDIR);
exit_proc:
	return ccode;
};
#endif

#ifdef _FOR_WIN_
int
dir_exists (char* dir) {
	int ccode = 0;
	DWORD attr;
	attr = GetFileAttributes (dir);
	if (attr == 0xffffffffl)
		goto exit_proc;
	ccode = attr & FILE_ATTRIBUTE_DIRECTORY;
exit_proc:
	return ccode;
};
#endif

/*
** create_file_list_set_out_dir -    ,
**   ,   
**  .
**  argc, argv -   ,     main()
**  argi       -       ,
**                .
**     .
**  :
**   0    -   
**  !0    -  
*/

#ifdef _FOR_UNIX_
int
create_file_list_set_out_dir (void) {
	int   ccode = 0;
	int   len	= 0;
	char  *file_name;
	/*
	**  UNIX-   ,
	**   ,   ,   
	**    .   .
	*/
	files_to_convert  = NULL;
	last_file_in_list = NULL;
	/*
	**  :   - .
	*/
	strcpy (out_dir, ".");
	for (; argi < argc; argi++) {
		/*
		**  ;     ,
		**     .
		*/
		if (dir_exists (argv[argi])) {
			if ((argi != argc - 1) || flag_overwrite) {
				print_is_dir (argv[argi]);
				continue;
			};
			/*
			**      
			*/
			len = strlen (argv[argi]);
			if (len > MAXPATH) {
            print_too_long_file_name (argv[argi], "", "", "");
            ccode = 1;
            goto exit_proc;
         };
         strcpy (out_dir, argv[argi]);
         if (out_dir[len - 1] == '/')
            out_dir[len - 1] = '\0';
         continue;
		};
		/*
      **         
      */
      if (strlen (argv[argi]) > MAXPATH) {
         print_too_long_file_name (argv[argi], "", "", "");
         continue;
      };
      file_name = strrchr (argv[argi], '/');
      if (file_name) {
         *file_name++ = '\0';
         ccode = add_file_name (argv[argi], file_name);
      } else {
         ccode = add_file_name (".", argv[argi]);
      };
      if (ccode) {
         goto exit_proc;
      };
   };  /* for (; argi < argc; argi++) */
   ccode = 0;
exit_proc:
   return ccode;
};     /* int create_file_list_set_out_dir() */
#endif /* #ifdef _FOR_UNIX_ */

#ifdef _FOR_BC_
int
create_file_list_set_out_dir (void) {
   #ifdef _FOR_DOS_
   struct ffblk      find;
   #endif
   #ifdef _FOR_WIN_
   WIN32_FIND_DATA   find_data;
   HANDLE            find_handle;
   #endif
   int               ccode = 1,
                     len,
                     find_n;
   char              *tmp  = NULL;
   char              dir_name[MAXPATH + 2];
   files_to_convert  = NULL;
   last_file_in_list = NULL;
   /*
   **  :   - .
   */
   strcpy (out_dir, ".");
	for (; argi < argc; argi++) {
		/*
		**     DOSa .
		*/
		for (tmp = argv[argi]; *tmp ;tmp++) {
			if (*tmp == '/') *tmp = '\\';
		};
      /*
      **  ;     ,
      **     .
      */
      if (dir_exists (argv[argi])) {
         if ((argi != argc - 1) || flag_overwrite) {
            print_is_dir (argv[argi]);
            continue;
         };
         /*
         **       .
         */
         len = strlen (argv[argi]);
         if (len > MAXPATH) {
            print_too_long_file_name (argv[argi], "", "", "");
            ccode = 1;
            goto exit_proc;
         };
         strcpy (out_dir, argv[argi]);
         if (out_dir[len - 1] == '\\')
            out_dir[len - 1] = '\0';
         continue;
      }; /* if (dir_exists (argv[argi])) */
      /*
      **   ,    .
      */
      if (strlen (argv[argi]) > MAXPATH) {
         print_too_long_file_name (argv[argi], "", "", "");
         continue;
      };
      strcpy (dir_name, argv[argi]);
      tmp = strrchr (dir_name, '\\');
      if (tmp) {
         *tmp = '\0';
      } else {
         strcpy (dir_name, ".");
      };
      /*
      **      . 
      **  ,  . ,
      **    ,    ,
      **     ,     .
      **  , ,       
      **   -   .
      */
      #ifdef _FOR_DOS_
      find_n = 0;
      if (findfirst (argv[argi], &find, FA_RDONLY || FA_ARCH)) {
         print_no_such_file (argv[argi]);
         continue;
      };
      if ((find.ff_attrib & FA_RDONLY) && flag_overwrite) {
         print_read_only_file (dir_name, "\\", find.ff_name);
         ccode = 0;
      } else {
         ccode = add_file_name (dir_name, find.ff_name);
         find_n++;
      };
      #endif
      /*
      **  Windows  .       
      ** .      . 
      **   , ,   , 
      ** ,    .
      */
      #ifdef _FOR_WIN_
      find_n = 0;
      find_handle = FindFirstFile (argv[argi], &find_data);
      if (INVALID_HANDLE_VALUE == find_handle) {
         print_no_such_file (argv[argi]);
         continue;
      };
      ccode = 0;
      if ( ! (find_data.dwFileAttributes &
             (FILE_ATTRIBUTE_DIRECTORY | FILE_ATTRIBUTE_HIDDEN |
              FILE_ATTRIBUTE_SYSTEM))
          ) {
         if ( (find_data.dwFileAttributes & FILE_ATTRIBUTE_READONLY) &&
               flag_overwrite
            ) {
            print_read_only_file (dir_name, "\\", find_data.cFileName);
         } else {
            ccode = add_file_name (dir_name, find_data.cFileName);
            find_n++;
         };
      };
      #endif
      if (ccode) {
         ccode = 1;
         goto exit_proc;
      };
      /*
      **    .
      */
      #ifdef _FOR_DOS_
      while (!findnext (&find)) {
         if ((find.ff_attrib & FA_RDONLY) && flag_overwrite) {
            print_read_only_file (dir_name, "\\", find.ff_name);
            ccode = 0;
         } else {
            ccode = add_file_name (dir_name, find.ff_name);
            find_n++;
         };
         if (ccode) {
            ccode = 1;
            goto exit_proc;
         };
      };
      #endif
      #ifdef _FOR_WIN_
      while (FindNextFile (find_handle, &find_data)) {
         ccode = 0;
         if ( ! (find_data.dwFileAttributes &
                (FILE_ATTRIBUTE_DIRECTORY | FILE_ATTRIBUTE_HIDDEN |
                 FILE_ATTRIBUTE_SYSTEM))
             ) {
            if ( (find_data.dwFileAttributes & FILE_ATTRIBUTE_READONLY) &&
                  flag_overwrite
               ) {
               print_read_only_file (dir_name, "\\", find_data.cFileName);
            } else {
               ccode = add_file_name (dir_name, find_data.cFileName);
               find_n++;
            };
         };
         if (ccode) {
            ccode = 1;
            goto exit_proc;
         };
      };
      #endif
      /*
      **  Windows     .
      */
      #ifdef _FOR_WIN_
      FindClose (find_handle);
      #endif
      /*
      **        , 
      **    .
      */
      if (!find_n) {
         print_no_match (argv[argi]);
      };
   };    /* for (; argi < argc; argi++) ...*/
   ccode = 0;
exit_proc:
   return ccode;
};       /* int create_file_list_and_set_out_dir() */
#endif   /* #ifdef _FOR_WIN_ */

