/*
 *  Copyright (c) 1999 Easysoft Ltd. All rights reserved.
 * 
 *  This file contains the ODBCINSTGetProperties function required by
 *  unixODBC (http://www.unixodbc.org) to define Easysoft ODBC-ODBC Bridge
 *  DSNs.
 *
 *  $Id: setup.c,v 1.3 1999/09/06 10:58:55 martin Exp martin $
 *
 *  $Log: setup.c,v $
 *  Revision 1.3  1999/09/06 10:58:55  martin
 *  Add description and copyright.
 *
 *  Revision 1.2  1999/09/06 10:49:55  martin
 *  Add BlockFetchSize, MetaData_ID_Identifier and Unquote_Catalog_Fns.
 *
 *  Revision 1.1  1999/09/06 09:44:37  martin
 *  Initial revision
 *
 */

#include <odbcinstext.h>

char *help_strings[] = 
{
    "Name of the server to connect to.",
    "Name of the network protocol to use.",
    "Number of the port the server is listening on.",
    "Name of the remote DSN to connect to.",
    "Name of the user to log on to server box as.",
    "Password of the user to log on to server box as.",
    "Name of the remote database user.",
    "Password of the remote datbase user.",
    "Number of rows to bind in Block-Fetch-Mode.",
    "Remove quotes on catalog functions (Applix's AXData).",
    "Tell driver to treat strings as literal and treat wildcard "
        "characters as literals."
};

int ODBCINSTGetProperties(
    HODBCINSTPROPERTY hLastProperty)
{
    hLastProperty->pNext =
        (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
    hLastProperty = hLastProperty->pNext;
    memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
    hLastProperty->nPromptType = ODBCINST_PROMPTTYPE_TEXTEDIT;
    strncpy( hLastProperty->szName, "Server", INI_MAX_PROPERTY_NAME );
    strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );
    hLastProperty->pszHelp = malloc(strlen(help_strings[0]) + 1);
    strcpy(hLastProperty->pszHelp, help_strings[0]);

    hLastProperty->pNext =
        (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
    hLastProperty = hLastProperty->pNext;
    memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
    hLastProperty->nPromptType = ODBCINST_PROMPTTYPE_TEXTEDIT;
    strncpy( hLastProperty->szName, "Protocol", INI_MAX_PROPERTY_NAME );
    strncpy( hLastProperty->szValue, "TCP/IP", INI_MAX_PROPERTY_VALUE );
    hLastProperty->pszHelp = malloc(strlen(help_strings[1]) + 1);
    strcpy(hLastProperty->pszHelp, help_strings[1]);
    
    hLastProperty->pNext = (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
    hLastProperty = hLastProperty->pNext;
    memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
    hLastProperty->nPromptType = ODBCINST_PROMPTTYPE_TEXTEDIT;
    strncpy( hLastProperty->szName, "Port", INI_MAX_PROPERTY_NAME );
    strncpy( hLastProperty->szValue, "8888", INI_MAX_PROPERTY_VALUE );
    hLastProperty->pszHelp = malloc(strlen(help_strings[2]) + 1);
    strcpy(hLastProperty->pszHelp, help_strings[2]);

    hLastProperty->pNext = (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
    hLastProperty = hLastProperty->pNext;
    memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
    hLastProperty->nPromptType = ODBCINST_PROMPTTYPE_TEXTEDIT;
    strncpy( hLastProperty->szName, "TargetDSN", INI_MAX_PROPERTY_NAME );
    strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );
    hLastProperty->pszHelp = malloc(strlen(help_strings[3]) + 1);
    strcpy(hLastProperty->pszHelp, help_strings[3]);

    hLastProperty->pNext = (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
    hLastProperty = hLastProperty->pNext;
    memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
    hLastProperty->nPromptType = ODBCINST_PROMPTTYPE_TEXTEDIT;
    strncpy( hLastProperty->szName, "LogonUser", INI_MAX_PROPERTY_NAME );
    strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );
    hLastProperty->pszHelp = malloc(strlen(help_strings[4]) + 1);
    strcpy(hLastProperty->pszHelp, help_strings[4]);

    hLastProperty->pNext = (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY) );
    hLastProperty = hLastProperty->pNext;
    memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
    hLastProperty->nPromptType = ODBCINST_PROMPTTYPE_TEXTEDIT;
    strncpy( hLastProperty->szName, "LogonAuth", INI_MAX_PROPERTY_NAME );
    strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );
    hLastProperty->pszHelp = malloc(strlen(help_strings[5]) + 1);
    strcpy(hLastProperty->pszHelp, help_strings[5]);

    hLastProperty->pNext = (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY));
    hLastProperty = hLastProperty->pNext;
    memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
    hLastProperty->nPromptType = ODBCINST_PROMPTTYPE_TEXTEDIT;
    strncpy( hLastProperty->szName, "TargetUser", INI_MAX_PROPERTY_NAME );
    strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );
    hLastProperty->pszHelp = malloc(strlen(help_strings[6]) + 1);
    strcpy(hLastProperty->pszHelp, help_strings[6]);

    hLastProperty->pNext =
        (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY));
    hLastProperty = hLastProperty->pNext;
    memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
    hLastProperty->nPromptType = ODBCINST_PROMPTTYPE_TEXTEDIT;
    strncpy( hLastProperty->szName, "TargetAuth", INI_MAX_PROPERTY_NAME );
    strncpy( hLastProperty->szValue, "", INI_MAX_PROPERTY_VALUE );
    hLastProperty->pszHelp = malloc(strlen(help_strings[7]) + 1);
    strcpy(hLastProperty->pszHelp, help_strings[7]);

    hLastProperty->pNext =
        (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY));
    hLastProperty = hLastProperty->pNext;
    memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
    hLastProperty->nPromptType = ODBCINST_PROMPTTYPE_TEXTEDIT;
    strncpy( hLastProperty->szName, "BlockFetchSize", INI_MAX_PROPERTY_NAME );
    strncpy( hLastProperty->szValue, "0", INI_MAX_PROPERTY_VALUE );
    hLastProperty->pszHelp = malloc(strlen(help_strings[8]) + 1);
    strcpy(hLastProperty->pszHelp, help_strings[8]);

    hLastProperty->pNext =
        (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY));
    hLastProperty = hLastProperty->pNext;
    memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
    hLastProperty->nPromptType = ODBCINST_PROMPTTYPE_TEXTEDIT;
    strncpy( hLastProperty->szName, "Unquote_Catalog_Fns", INI_MAX_PROPERTY_NAME );
    strncpy( hLastProperty->szValue, "0", INI_MAX_PROPERTY_VALUE );
    hLastProperty->pszHelp = malloc(strlen(help_strings[9]) + 1);
    strcpy(hLastProperty->pszHelp, help_strings[9]);

    hLastProperty->pNext =
        (HODBCINSTPROPERTY)malloc( sizeof(ODBCINSTPROPERTY));
    hLastProperty = hLastProperty->pNext;
    memset( hLastProperty, 0, sizeof(ODBCINSTPROPERTY) );
    hLastProperty->nPromptType = ODBCINST_PROMPTTYPE_TEXTEDIT;
    strncpy( hLastProperty->szName, "MetaData_ID_Identifiers", INI_MAX_PROPERTY_NAME );
    strncpy( hLastProperty->szValue, "0", INI_MAX_PROPERTY_VALUE );
    hLastProperty->pszHelp = malloc(strlen(help_strings[10]) + 1);
    strcpy(hLastProperty->pszHelp, help_strings[10]);

    return 1;
}

