#
# This example reads comma separated data from the file perl_data.dat 
# where each record has 4 fields (see below for an example) and inserts
# it into a table called oob_example.
#
use strict;
use DBI;
use DBI qw(:sql_types);

my $sth;
my $sql;
my $dbh = DBI->connect($ENV{DBI_DSN},
		       $ENV{DBI_USER},
		       $ENV{DBI_PASS},
		       {
			   RaiseError => 1,
			   AutoCommit => 0
                           }
		       ) || die "Database connection failed: $DBI::errstr";
$sql = qq{ CREATE TABLE oob_example (id INTEGER NOT NULL, 
				     name VARCHAR(128), 
				     title VARCHAR(128), 
				     phone VARCHAR(8) 
				     ) };
$sth = $dbh->prepare($sql);
$sth->execute;
# Example data file would look like this:
# 0,Larry Wall,Perl Author,555-0101
# 1,Tim Bunce,DBI Author,555-0202
# 2,Randal Schwartz,Guy at Large,555-0303
# 3,Doug MacEachern,Apache Man,555-0404

$sql = qq{ INSERT INTO oob_example VALUES ( ?, ?, ?, ? ) };
$sth = $dbh->prepare( $sql );

my $datafile='perl_data.dat';
$datafile = open(DATA,"<$datafile") || die "Can't open $datafile $!";
while(<DATA>)
{
    my $id;
    my $name;
    my $desc;
    my $tel;

    ($id,$name,$desc,$tel) = ($_ =~ /^(.*),(.*),(.*),(.*)\n/);

    print "Inserting ", $id, " ", $name, " ", $desc, " ", $tel, "\n";
    eval
    {
	$sth->bind_param( 1, $id, SQL_INTEGER );
	$sth->bind_param( 2, $name, SQL_VARCHAR );
	$sth->bind_param( 3, $desc, SQL_VARCHAR );
	$sth->bind_param( 4, $tel, SQL_VARCHAR );
	$sth->execute();
	$dbh->commit();
    };
    if( $@ )
    {
	warn "Database error: $DBI::errstr\n";
	$dbh->rollback(); #just die if rollback is failing
     }
}
$sth->finish();
$dbh->disconnect();
