# ========================================================
#
# Database saved : nuke
# On 03-16-2002 at 10:47 by God !
#
# ========================================================

# --------------------------------------------------------
#
# Table structure for table 'nuke_config'
#

DROP TABLE IF EXISTS
 nuke_config;
CREATE TABLE nuke_config (
   config_name varchar(255) NOT NULL,
   config_value varchar(255) NOT NULL,
   PRIMARY KEY (config_name)
);

#
# Dumping data for table 'nuke_config'
#

INSERT INTO nuke_config VALUES ( 'config_id', '1');
INSERT INTO nuke_config VALUES ( 'board_disable', '0');
INSERT INTO nuke_config VALUES ( 'sitename', 'www.yourdomain.com');
INSERT INTO nuke_config VALUES ( 'site_desc', '');
INSERT INTO nuke_config VALUES ( 'cookie_name', 'phpbb2mysql');
INSERT INTO nuke_config VALUES ( 'cookie_path', '/');
INSERT INTO nuke_config VALUES ( 'cookie_domain', 'www.yourdomain.com');
INSERT INTO nuke_config VALUES ( 'cookie_secure', '0');
INSERT INTO nuke_config VALUES ( 'session_length', '0');
INSERT INTO nuke_config VALUES ( 'allow_html', '1');
INSERT INTO nuke_config VALUES ( 'allow_html_tags', 'b,i,u,pre');
INSERT INTO nuke_config VALUES ( 'allow_bbcode', '1');
INSERT INTO nuke_config VALUES ( 'allow_smilies', '1');
INSERT INTO nuke_config VALUES ( 'allow_sig', '1');
INSERT INTO nuke_config VALUES ( 'allow_namechange', '0');
INSERT INTO nuke_config VALUES ( 'allow_theme_create', '0');
INSERT INTO nuke_config VALUES ( 'allow_avatar_local', '1');
INSERT INTO nuke_config VALUES ( 'allow_avatar_remote', '0');
INSERT INTO nuke_config VALUES ( 'allow_avatar_upload', '0');
INSERT INTO nuke_config VALUES ( 'override_user_style', '1');
INSERT INTO nuke_config VALUES ( 'posts_per_page', '15');
INSERT INTO nuke_config VALUES ( 'topics_per_page', '50');
INSERT INTO nuke_config VALUES ( 'hot_threshold', '25');
INSERT INTO nuke_config VALUES ( 'max_poll_options', '10');
INSERT INTO nuke_config VALUES ( 'max_sig_chars', '255');
INSERT INTO nuke_config VALUES ( 'max_inbox_privmsgs', '50');
INSERT INTO nuke_config VALUES ( 'max_sentbox_privmsgs', '25');
INSERT INTO nuke_config VALUES ( 'max_savebox_privmsgs', '50');
INSERT INTO nuke_config VALUES ( 'board_email_sig', 'Thanks, webmaster@yourdomain.com');
INSERT INTO nuke_config VALUES ( 'board_email', 'webmaster@yourdomain.com');
INSERT INTO nuke_config VALUES ( 'smtp_delivery', '0');
INSERT INTO nuke_config VALUES ( 'smtp_host', '');
INSERT INTO nuke_config VALUES ( 'require_activation', '0');
INSERT INTO nuke_config VALUES ( 'flood_interval', '15');
INSERT INTO nuke_config VALUES ( 'board_email_form', '0');
INSERT INTO nuke_config VALUES ( 'avatar_filesize', '6144');
INSERT INTO nuke_config VALUES ( 'avatar_max_width', '80');
INSERT INTO nuke_config VALUES ( 'avatar_max_height', '80');
INSERT INTO nuke_config VALUES ( 'avatar_path', 'modules/Forums/images/avatars');
INSERT INTO nuke_config VALUES ( 'avatar_gallery_path', 'modules/Forums/images/avatars');
INSERT INTO nuke_config VALUES ( 'smilies_path', 'modules/Forums/images/smiles');
INSERT INTO nuke_config VALUES ( 'default_style', '1');
INSERT INTO nuke_config VALUES ( 'default_dateformat', 'D M d, Y g:i a');
INSERT INTO nuke_config VALUES ( 'board_timezone', '10');
INSERT INTO nuke_config VALUES ( 'prune_enable', '0');
INSERT INTO nuke_config VALUES ( 'privmsg_disable', '0');
INSERT INTO nuke_config VALUES ( 'gzip_compress', '0');
INSERT INTO nuke_config VALUES ( 'coppa_fax', '');
INSERT INTO nuke_config VALUES ( 'coppa_mail', '');
INSERT INTO nuke_config VALUES ( 'board_startdate', '1013908210');
INSERT INTO nuke_config VALUES ( 'default_lang', 'russian');
INSERT INTO nuke_config VALUES ( 'smtp_username','');
INSERT INTO nuke_config VALUES ( 'smtp_password','');
INSERT INTO nuke_config VALUES ( 'record_online_users', '1');
INSERT INTO nuke_config VALUES ( 'record_online_date', '1017995359');
INSERT INTO nuke_config VALUES ( 'server_name', 'server.toms-home.com');
INSERT INTO nuke_config VALUES ( 'server_port', '80');
INSERT INTO nuke_config VALUES ( 'script_path', '/modules/Forums/');
INSERT INTO nuke_config VALUES ( 'version', '.0.0');



# --------------------------------------------------------
#
# Table structure for table 'nuke_auth_access'
#

DROP TABLE IF EXISTS
 nuke_auth_access;
CREATE TABLE nuke_auth_access (
   group_id mediumint(8) DEFAULT '0' NOT NULL,
   forum_id smallint(5) unsigned DEFAULT '0' NOT NULL,
   auth_view tinyint(1) DEFAULT '0' NOT NULL,
   auth_read tinyint(1) DEFAULT '0' NOT NULL,
   auth_post tinyint(1) DEFAULT '0' NOT NULL,
   auth_reply tinyint(1) DEFAULT '0' NOT NULL,
   auth_edit tinyint(1) DEFAULT '0' NOT NULL,
   auth_delete tinyint(1) DEFAULT '0' NOT NULL,
   auth_sticky tinyint(1) DEFAULT '0' NOT NULL,
   auth_announce tinyint(1) DEFAULT '0' NOT NULL,
   auth_vote tinyint(1) DEFAULT '0' NOT NULL,
   auth_pollcreate tinyint(1) DEFAULT '0' NOT NULL,
   auth_attachments tinyint(1) DEFAULT '0' NOT NULL,
   auth_mod tinyint(1) DEFAULT '0' NOT NULL,
   KEY group_id (group_id),
   KEY forum_id (forum_id)
);

#
# Dumping data for table 'nuke_auth_access'
#



# --------------------------------------------------------
#
# Table structure for table 'nuke_banlist'
#

DROP TABLE IF EXISTS
 nuke_banlist;
CREATE TABLE nuke_banlist (
   ban_id mediumint(8) unsigned NOT NULL auto_increment,
   ban_userid mediumint(8) DEFAULT '0' NOT NULL,
   ban_ip varchar(8) NOT NULL,
   ban_email varchar(255),
   PRIMARY KEY (ban_id),
   KEY ban_ip_user_id (ban_ip, ban_userid)
);

#
# Dumping data for table 'nuke_banlist'
#

# --------------------------------------------------------
#
# Table structure for table 'nuke_categories'
#

DROP TABLE IF EXISTS
 nuke_categories;
CREATE TABLE nuke_categories (
   cat_id mediumint(8) unsigned NOT NULL auto_increment,
   cat_title varchar(100),
   cat_order mediumint(8) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (cat_id),
   KEY cat_order (cat_order)
);

#
# Dumping data for table 'nuke_categories'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_disallow'
#

DROP TABLE IF EXISTS
 nuke_disallow;
CREATE TABLE nuke_disallow (
   disallow_id mediumint(8) unsigned NOT NULL auto_increment,
   disallow_username varchar(25),
   PRIMARY KEY (disallow_id)
);

#
# Dumping data for table 'nuke_disallow'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_forum_prune'
#

DROP TABLE IF EXISTS
 nuke_forum_prune;
CREATE TABLE nuke_forum_prune (
   prune_id mediumint(8) unsigned NOT NULL auto_increment,
   forum_id smallint(5) unsigned DEFAULT '0' NOT NULL,
   prune_days tinyint(4) unsigned DEFAULT '0' NOT NULL,
   prune_freq tinyint(4) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (prune_id),
   KEY forum_id (forum_id)
);

#
# Dumping data for table 'nuke_forum_prune'
#

# --------------------------------------------------------
#
# Table structure for table 'nuke_forums'
#

DROP TABLE IF EXISTS
 nuke_forums;
CREATE TABLE nuke_forums (
   forum_id smallint(5) unsigned NOT NULL auto_increment,
   cat_id mediumint(8) unsigned DEFAULT '0' NOT NULL,
   forum_name varchar(150),
   forum_desc text,
   forum_status tinyint(4) DEFAULT '0' NOT NULL,
   forum_order mediumint(8) unsigned DEFAULT '1' NOT NULL,
   forum_posts mediumint(8) unsigned DEFAULT '0' NOT NULL,
   forum_topics mediumint(8) unsigned DEFAULT '0' NOT NULL,
   forum_last_post_id mediumint(8) unsigned DEFAULT '0' NOT NULL,
   prune_next int(11),
   prune_enable tinyint(1) DEFAULT '1' NOT NULL,
   auth_view tinyint(2) DEFAULT '0' NOT NULL,
   auth_read tinyint(2) DEFAULT '0' NOT NULL,
   auth_post tinyint(2) DEFAULT '0' NOT NULL,
   auth_reply tinyint(2) DEFAULT '0' NOT NULL,
   auth_edit tinyint(2) DEFAULT '0' NOT NULL,
   auth_delete tinyint(2) DEFAULT '0' NOT NULL,
   auth_sticky tinyint(2) DEFAULT '0' NOT NULL,
   auth_announce tinyint(2) DEFAULT '0' NOT NULL,
   auth_vote tinyint(2) DEFAULT '0' NOT NULL,
   auth_pollcreate tinyint(2) DEFAULT '0' NOT NULL,
   auth_attachments tinyint(2) DEFAULT '0' NOT NULL,
   PRIMARY KEY (forum_id),
   KEY forums_order (forum_order),
   KEY cat_id (cat_id),
   KEY forum_last_post_id (forum_last_post_id)
);

#
# Dumping data for table 'nuke_forums'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_groups'
#

DROP TABLE IF EXISTS
 nuke_groups;
CREATE TABLE nuke_groups (
   group_id mediumint(8) NOT NULL auto_increment,
   group_type tinyint(4) DEFAULT '1' NOT NULL,
   group_name varchar(40) NOT NULL,
   group_description varchar(255) NOT NULL,
   group_moderator mediumint(8) DEFAULT '0' NOT NULL,
   group_single_user tinyint(1) DEFAULT '1' NOT NULL,
   PRIMARY KEY (group_id),
   KEY group_single_user (group_single_user)
);

#
# Dumping data for table 'nuke_groups'
#

INSERT INTO nuke_groups VALUES ( '1', '1', 'Anonymous', 'Personal User', '0', '1');
INSERT INTO nuke_groups VALUES ( '3', '2', 'Moderators', 'Moderators of this Forum', '5', '0');


# --------------------------------------------------------
#
# Table structure for table 'nuke_posts'
#

DROP TABLE IF EXISTS
 nuke_posts;
CREATE TABLE nuke_posts (
   post_id mediumint(8) unsigned NOT NULL auto_increment,
   topic_id mediumint(8) unsigned DEFAULT '0' NOT NULL,
   forum_id smallint(5) unsigned DEFAULT '0' NOT NULL,
   poster_id mediumint(8) DEFAULT '0' NOT NULL,
   post_time int(11) DEFAULT '0' NOT NULL,
   poster_ip varchar(8) NOT NULL,
   post_username varchar(25),
   enable_bbcode tinyint(1) DEFAULT '1' NOT NULL,
   enable_html tinyint(1) DEFAULT '0' NOT NULL,
   enable_smilies tinyint(1) DEFAULT '1' NOT NULL,
   enable_sig tinyint(1) DEFAULT '1' NOT NULL,
   post_edit_time int(11),
   post_edit_count smallint(5) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (post_id),
   KEY forum_id (forum_id),
   KEY topic_id (topic_id),
   KEY poster_id (poster_id),
   KEY post_time (post_time)
);

#
# Dumping data for table 'nuke_posts'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_posts_text'
#

DROP TABLE IF EXISTS
 nuke_posts_text;
CREATE TABLE nuke_posts_text (
   post_id mediumint(8) unsigned DEFAULT '0' NOT NULL,
   bbcode_uid varchar(10) NOT NULL,
   post_subject varchar(60),
   post_text text,
   PRIMARY KEY (post_id)
);

#
# Dumping data for table 'nuke_posts_text'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_privmsgs'
#

DROP TABLE IF EXISTS
 nuke_privmsgs;
CREATE TABLE nuke_privmsgs (
   privmsgs_id mediumint(8) unsigned NOT NULL auto_increment,
   privmsgs_type tinyint(4) DEFAULT '0' NOT NULL,
   privmsgs_subject varchar(255) DEFAULT '0' NOT NULL,
   privmsgs_from_userid mediumint(8) DEFAULT '0' NOT NULL,
   privmsgs_to_userid mediumint(8) DEFAULT '0' NOT NULL,
   privmsgs_date int(11) DEFAULT '0' NOT NULL,
   privmsgs_ip varchar(8) NOT NULL,
   privmsgs_enable_bbcode tinyint(1) DEFAULT '1' NOT NULL,
   privmsgs_enable_html tinyint(1) DEFAULT '0' NOT NULL,
   privmsgs_enable_smilies tinyint(1) DEFAULT '1' NOT NULL,
   privmsgs_attach_sig tinyint(1) DEFAULT '1' NOT NULL,
   PRIMARY KEY (privmsgs_id),
   KEY privmsgs_from_userid (privmsgs_from_userid),
   KEY privmsgs_to_userid (privmsgs_to_userid)
);

#
# Dumping data for table 'nuke_privmsgs'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_privmsgs_text'
#

DROP TABLE IF EXISTS
 nuke_privmsgs_text;
CREATE TABLE nuke_privmsgs_text (
   privmsgs_text_id mediumint(8) unsigned DEFAULT '0' NOT NULL,
   privmsgs_bbcode_uid varchar(10) DEFAULT '0' NOT NULL,
   privmsgs_text text,
   PRIMARY KEY (privmsgs_text_id)
);

#
# Dumping data for table 'nuke_privmsgs_text'
#

# --------------------------------------------------------
#
# Table structure for table 'nuke_ranks'
#

DROP TABLE IF EXISTS nuke_ranks
;
CREATE TABLE nuke_ranks (
   rank_id smallint(5) unsigned NOT NULL auto_increment,
   rank_title varchar(50) NOT NULL,
   rank_min mediumint(8) DEFAULT '0' NOT NULL,
   rank_max mediumint(8) DEFAULT '0' NOT NULL,
   rank_special tinyint(1) DEFAULT '0',
   rank_image varchar(255),
   PRIMARY KEY (rank_id)
);

#
# Dumping data for table 'nuke_ranks'
#

INSERT INTO nuke_ranks VALUES ( '1', 'Site Admin', '-1', '-1', '1', 'modules/Forums/images/ranks/6stars.gif');
INSERT INTO nuke_ranks VALUES ( '2', 'Newbie', '1', '0', '0', 'modules/Forums/images/ranks/1star.gif');



# --------------------------------------------------------
#
# Table structure for table 'nuke_search_results'
#

DROP TABLE IF EXISTS
 nuke_search_results;
CREATE TABLE nuke_search_results (
   search_id int(11) unsigned DEFAULT '0' NOT NULL,
   session_id varchar(32) NOT NULL,
   search_array text NOT NULL,
   PRIMARY KEY (search_id),
   KEY session_id (session_id)
);

#
# Dumping data for table 'nuke_search_results'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_search_wordlist'
#

DROP TABLE IF EXISTS
 nuke_search_wordlist;
CREATE TABLE nuke_search_wordlist (
   word_text varchar(50) binary NOT NULL,
   word_id mediumint(8) unsigned NOT NULL auto_increment,
   word_common tinyint(1) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (word_text),
   KEY word_id (word_id)
);

#
# Dumping data for table 'nuke_search_wordlist'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_search_wordmatch'
#

DROP TABLE IF EXISTS
 nuke_search_wordmatch;
CREATE TABLE nuke_search_wordmatch (
   post_id mediumint(8) unsigned DEFAULT '0' NOT NULL,
   word_id mediumint(8) unsigned DEFAULT '0' NOT NULL,
   title_match tinyint(1) DEFAULT '0' NOT NULL,
   KEY word_id (word_id)
);

#
# Dumping data for table 'nuke_search_wordmatch'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_sessions'
#

DROP TABLE IF EXISTS
 nuke_sessions;
CREATE TABLE nuke_sessions (
   session_id char(32) NOT NULL,
   session_user_id mediumint(8) DEFAULT '0' NOT NULL,
   session_start int(11) DEFAULT '0' NOT NULL,
   session_time int(11) DEFAULT '0' NOT NULL,
   session_ip char(8) DEFAULT '0' NOT NULL,
   session_page int(11) DEFAULT '0' NOT NULL,
   session_logged_in tinyint(1) DEFAULT '0' NOT NULL,
   PRIMARY KEY (session_id),
   KEY session_user_id (session_user_id),
   KEY session_id_ip_user_id (session_id, session_ip, session_user_id)
);

#
# Dumping data for table 'nuke_sessions'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_smilies'
#

DROP TABLE IF EXISTS
 nuke_smilies;
CREATE TABLE nuke_smilies (
   smilies_id smallint(5) unsigned NOT NULL auto_increment,
   code varchar(50),
   smile_url varchar(100),
   emoticon varchar(75),
   PRIMARY KEY (smilies_id)
);

#
# Dumping data for table 'nuke_smilies'
#

INSERT INTO nuke_smilies VALUES ( '1', ':D', 'icon_biggrin.gif', 'Very Happy');
INSERT INTO nuke_smilies VALUES ( '2', ':-D', 'icon_biggrin.gif', 'Very Happy');
INSERT INTO nuke_smilies VALUES ( '3', ':grin:', 'icon_biggrin.gif', 'Very Happy');
INSERT INTO nuke_smilies VALUES ( '4', ':)', 'icon_smile.gif', 'Smile');
INSERT INTO nuke_smilies VALUES ( '5', ':-)', 'icon_smile.gif', 'Smile');
INSERT INTO nuke_smilies VALUES ( '6', ':smile:', 'icon_smile.gif', 'Smile');
INSERT INTO nuke_smilies VALUES ( '7', ':(', 'icon_sad.gif', 'Sad');
INSERT INTO nuke_smilies VALUES ( '8', ':-(', 'icon_sad.gif', 'Sad');
INSERT INTO nuke_smilies VALUES ( '9', ':sad:', 'icon_sad.gif', 'Sad');
INSERT INTO nuke_smilies VALUES ( '10', ':o', 'icon_surprised.gif', 'Surprised');
INSERT INTO nuke_smilies VALUES ( '11', ':-o', 'icon_surprised.gif', 'Surprised');
INSERT INTO nuke_smilies VALUES ( '12', ':eek:', 'icon_surprised.gif', 'Surprised');
INSERT INTO nuke_smilies VALUES ( '13', '8O', 'icon_eek.gif', 'Shocked');
INSERT INTO nuke_smilies VALUES ( '14', '8-O', 'icon_eek.gif', 'Shocked');
INSERT INTO nuke_smilies VALUES ( '15', ':shock:', 'icon_eek.gif', 'Shocked');
INSERT INTO nuke_smilies VALUES ( '16', ':?', 'icon_confused.gif', 'Confused');
INSERT INTO nuke_smilies VALUES ( '17', ':-?', 'icon_confused.gif', 'Confused');
INSERT INTO nuke_smilies VALUES ( '18', ':???:', 'icon_confused.gif', 'Confused');
INSERT INTO nuke_smilies VALUES ( '19', '8)', 'icon_cool.gif', 'Cool');
INSERT INTO nuke_smilies VALUES ( '20', '8-)', 'icon_cool.gif', 'Cool');
INSERT INTO nuke_smilies VALUES ( '21', ':cool:', 'icon_cool.gif', 'Cool');
INSERT INTO nuke_smilies VALUES ( '22', ':lol:', 'icon_lol.gif', 'Laughing');
INSERT INTO nuke_smilies VALUES ( '23', ':x', 'icon_mad.gif', 'Mad');
INSERT INTO nuke_smilies VALUES ( '24', ':-x', 'icon_mad.gif', 'Mad');
INSERT INTO nuke_smilies VALUES ( '25', ':mad:', 'icon_mad.gif', 'Mad');
INSERT INTO nuke_smilies VALUES ( '26', ':P', 'icon_razz.gif', 'Razz');
INSERT INTO nuke_smilies VALUES ( '27', ':-P', 'icon_razz.gif', 'Razz');
INSERT INTO nuke_smilies VALUES ( '28', ':razz:', 'icon_razz.gif', 'Razz');
INSERT INTO nuke_smilies VALUES ( '29', ':oops:', 'icon_redface.gif', 'Embarassed');
INSERT INTO nuke_smilies VALUES ( '30', ':cry:', 'icon_cry.gif', 'Crying or Very sad');
INSERT INTO nuke_smilies VALUES ( '31', ':evil:', 'icon_evil.gif', 'Evil or Very Mad');
INSERT INTO nuke_smilies VALUES ( '32', ':twisted:', 'icon_twisted.gif', 'Twisted Evil');
INSERT INTO nuke_smilies VALUES ( '33', ':roll:', 'icon_rolleyes.gif', 'Rolling Eyes');
INSERT INTO nuke_smilies VALUES ( '34', ':wink:', 'icon_wink.gif', 'Wink');
INSERT INTO nuke_smilies VALUES ( '35', ';)', 'icon_wink.gif', 'Wink');
INSERT INTO nuke_smilies VALUES ( '36', ';-)', 'icon_wink.gif', 'Wink');
INSERT INTO nuke_smilies VALUES ( '37', ':!:', 'icon_exclaim.gif', 'Exclamation');
INSERT INTO nuke_smilies VALUES ( '38', ':?:', 'icon_question.gif', 'Question');
INSERT INTO nuke_smilies VALUES ( '39', ':idea:', 'icon_idea.gif', 'Idea');
INSERT INTO nuke_smilies VALUES ( '40', ':arrow:', 'icon_arrow.gif', 'Arrow');
INSERT INTO nuke_smilies VALUES ( '41', ':|', 'icon_neutral.gif', 'Neutral');
INSERT INTO nuke_smilies VALUES ( '42', ':-|', 'icon_neutral.gif', 'Neutral');
INSERT INTO nuke_smilies VALUES ( '43', ':neutral:', 'icon_neutral.gif', 'Neutral');
INSERT INTO nuke_smilies VALUES ( '44', ':mrgreen:', 'icon_mrgreen.gif', 'Mr. Green');



# --------------------------------------------------------
#
# Table structure for table 'nuke_themes'
#

DROP TABLE IF EXISTS
 nuke_themes;
CREATE TABLE nuke_themes (
   themes_id mediumint(8) unsigned NOT NULL auto_increment,
   template_name varchar(30) NOT NULL,
   style_name varchar(30) NOT NULL,
   head_stylesheet varchar(100),
   body_background varchar(100),
   body_bgcolor varchar(6),
   body_text varchar(6),
   body_link varchar(6),
   body_vlink varchar(6),
   body_alink varchar(6),
   body_hlink varchar(6),
   tr_color1 varchar(6),
   tr_color2 varchar(6),
   tr_color3 varchar(6),
   tr_class1 varchar(25),
   tr_class2 varchar(25),
   tr_class3 varchar(25),
   th_color1 varchar(6),
   th_color2 varchar(6),
   th_color3 varchar(6),
   th_class1 varchar(25),
   th_class2 varchar(25),
   th_class3 varchar(25),
   td_color1 varchar(6),
   td_color2 varchar(6),
   td_color3 varchar(6),
   td_class1 varchar(25),
   td_class2 varchar(25),
   td_class3 varchar(25),
   fontface1 varchar(50),
   fontface2 varchar(50),
   fontface3 varchar(50),
   fontsize1 tinyint(4),
   fontsize2 tinyint(4),
   fontsize3 tinyint(4),
   fontcolor1 varchar(6),
   fontcolor2 varchar(6),
   fontcolor3 varchar(6),
   span_class1 varchar(25),
   span_class2 varchar(25),
   span_class3 varchar(25),
   img_size_poll smallint(5) unsigned,
   img_size_privmsg smallint(5) unsigned,
   PRIMARY KEY (themes_id)
);

#
# Dumping data for table 'nuke_themes'
#

INSERT INTO nuke_themes (themes_id, template_name, style_name, head_stylesheet, body_background, body_bgcolor, body_text, body_link, body_vlink, body_alink, body_hlink, tr_color1, tr_color2, tr_color3, tr_class1, tr_class2, tr_class3, th_color1, th_color2, th_color3, th_class1, th_class2, th_class3, td_color1, td_color2, td_color3, td_class1, td_class2, td_class3, fontface1, fontface2, fontface3, fontsize1, fontsize2, fontsize3, fontcolor1, fontcolor2, fontcolor3, span_class1, span_class2, span_class3, img_size_poll, img_size_privmsg) VALUES( '1', 'subSilver', 'subSilver', 'subSilver.css','', 'E5E5E5', '000000', '006699', '5493B4','', 'DD6900', 'EFEFEF', 'DEE3E7', 'D1D7DC','','','', '98AAB1', '006699', 'FFFFFF', 'cellpic1.gif', 'cellpic3.gif', 'cellpic2.jpg', 'FAFAFA', 'FFFFFF','', 'row1', 'row2','', 'Verdana, Arial, Helvetica, sans-serif', 'Trebuchet MS', 'Courier, \'Courier New\', sans-serif', '10', '11', '12', '444444', '006600', 'FFA34F','','','', NULL, NULL);

# --------------------------------------------------------
#
# Table structure for table 'nuke_themes_name'
#

DROP TABLE IF EXISTS
 nuke_themes_name;
CREATE TABLE nuke_themes_name (
   themes_id smallint(5) unsigned DEFAULT '0' NOT NULL,
   tr_color1_name char(50),
   tr_color2_name char(50),
   tr_color3_name char(50),
   tr_class1_name char(50),
   tr_class2_name char(50),
   tr_class3_name char(50),
   th_color1_name char(50),
   th_color2_name char(50),
   th_color3_name char(50),
   th_class1_name char(50),
   th_class2_name char(50),
   th_class3_name char(50),
   td_color1_name char(50),
   td_color2_name char(50),
   td_color3_name char(50),
   td_class1_name char(50),
   td_class2_name char(50),
   td_class3_name char(50),
   fontface1_name char(50),
   fontface2_name char(50),
   fontface3_name char(50),
   fontsize1_name char(50),
   fontsize2_name char(50),
   fontsize3_name char(50),
   fontcolor1_name char(50),
   fontcolor2_name char(50),
   fontcolor3_name char(50),
   span_class1_name char(50),
   span_class2_name char(50),
   span_class3_name char(50),
   PRIMARY KEY (themes_id)
);

#
# Dumping data for table 'nuke_themes_name'
#

INSERT INTO nuke_themes_name (themes_id, tr_color1_name, tr_color2_name, tr_color3_name, tr_class1_name, tr_class2_name, tr_class3_name, th_color1_name, th_color2_name, th_color3_name, th_class1_name, th_class2_name, th_class3_name, td_color1_name, td_color2_name, td_color3_name, td_class1_name, td_class2_name, td_class3_name, fontface1_name, fontface2_name, fontface3_name, fontsize1_name, fontsize2_name, fontsize3_name, fontcolor1_name, fontcolor2_name, fontcolor3_name, span_class1_name, span_class2_name, span_class3_name) VALUES( '1', 'The lightest row colour', 'The medium row color', 'The darkest row colour','','','', 'Border round the whole page', 'Outer table border', 'Inner table border', 'Silver gradient picture', 'Blue gradient picture', 'Fade-out gradient on index', 'Background for quote boxes', 'All white areas','', 'Background for topic posts', '2nd background for topic posts','', 'Main fonts', 'Additional topic title font', 'Form fonts', 'Smallest font size', 'Medium font size', 'Normal font size (post body etc)', 'Quote & copyright text', 'Code text colour', 'Main table header text colour','','','');

# --------------------------------------------------------
#
# Table structure for table 'nuke_topics_watch'
#

DROP TABLE IF EXISTS
 nuke_topics_watch;
CREATE TABLE nuke_topics_watch (
   topic_id mediumint(8) unsigned DEFAULT '0' NOT NULL,
   user_id mediumint(8) DEFAULT '0' NOT NULL,
   notify_status tinyint(1) DEFAULT '0' NOT NULL,
   KEY topic_id (topic_id),
   KEY user_id (user_id),
   KEY notify_status (notify_status)
);

#
# Dumping data for table 'nuke_topics_watch'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_topicsbb'
#

DROP TABLE IF EXISTS
 nuke_topicsbb;
CREATE TABLE nuke_topicsbb (
   topic_id mediumint(8) unsigned NOT NULL auto_increment,
   forum_id smallint(8) unsigned DEFAULT '0' NOT NULL,
   topic_title char(60) NOT NULL,
   topic_poster mediumint(8) DEFAULT '0' NOT NULL,
   topic_time int(11) DEFAULT '0' NOT NULL,
   topic_views mediumint(8) unsigned DEFAULT '0' NOT NULL,
   topic_replies mediumint(8) unsigned DEFAULT '0' NOT NULL,
   topic_status tinyint(3) DEFAULT '0' NOT NULL,
   topic_vote tinyint(1) DEFAULT '0' NOT NULL,
   topic_type tinyint(3) DEFAULT '0' NOT NULL,
   topic_last_post_id mediumint(8) unsigned DEFAULT '0' NOT NULL,
   topic_first_post_id mediumint(8) unsigned NOT NULL,
   topic_moved_id mediumint(8) unsigned DEFAULT '0' NOT NULL,
   PRIMARY KEY (topic_id),
   KEY forum_id (forum_id),
   KEY topic_moved_id (topic_moved_id),
   KEY topic_status (topic_status)
,
   KEY topic_type (topic_type)
);

#
# Dumping data for table 'nuke_topicsbb'
#

# --------------------------------------------------------
#
# Table structure for table 'nuke_user_group'
#

DROP TABLE IF EXISTS
 nuke_user_group;
CREATE TABLE nuke_user_group (
   group_id mediumint(8) DEFAULT '0' NOT NULL,
   user_id mediumint(8) DEFAULT '0' NOT NULL,
   user_pending tinyint(1),
   KEY group_id (group_id),
   KEY user_id (user_id)
);

#
# Dumping data for table 'nuke_user_group'
#

INSERT INTO nuke_user_group VALUES ( '1', '-1', '0');
INSERT INTO nuke_user_group VALUES ( '3', '5', '0');


# --------------------------------------------------------
#
# Table structure for table 'nuke_vote_desc'
#

DROP TABLE IF EXISTS
 nuke_vote_desc;
CREATE TABLE nuke_vote_desc (
   vote_id mediumint(8) unsigned NOT NULL auto_increment,
   topic_id mediumint(8) unsigned DEFAULT '0' NOT NULL,
   vote_text text NOT NULL,
   vote_start int(11) DEFAULT '0' NOT NULL,
   vote_length int(11) DEFAULT '0' NOT NULL,
   PRIMARY KEY (vote_id),
   KEY topic_id (topic_id)
);

#
# Dumping data for table 'nuke_vote_desc'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_vote_results'
#

DROP TABLE IF EXISTS
 nuke_vote_results;
CREATE TABLE nuke_vote_results (
   vote_id mediumint(8) unsigned DEFAULT '0' NOT NULL,
   vote_option_id tinyint(4) unsigned DEFAULT '0' NOT NULL,
   vote_option_text varchar(255) NOT NULL,
   vote_result int(11) DEFAULT '0' NOT NULL,
   KEY vote_option_id (vote_option_id),
   KEY vote_id (vote_id)
);

#
# Dumping data for table 'nuke_vote_results'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_vote_voters'
#

DROP TABLE IF EXISTS
 nuke_vote_voters;
CREATE TABLE nuke_vote_voters (
   vote_id mediumint(8) unsigned DEFAULT '0' NOT NULL,
   vote_user_id mediumint(8) DEFAULT '0' NOT NULL,
   vote_user_ip char(8) NOT NULL,
   KEY vote_id (vote_id),
   KEY vote_user_id (vote_user_id),
   KEY vote_user_ip (vote_user_ip)
);

#
# Dumping data for table 'nuke_vote_voters'
#


# --------------------------------------------------------
#
# Table structure for table 'nuke_words'
#

DROP TABLE IF EXISTS
 nuke_words;
CREATE TABLE nuke_words (
   word_id mediumint(8) unsigned NOT NULL auto_increment,
   word char(100) NOT NULL,
   replacement char(100) NOT NULL,
   PRIMARY KEY (word_id)
);

#
# Dumping data for table 'nuke_words'
#

