<?php
/***************************************************************************
 *                                login.php
 *                            -------------------
 *   begin                : Saturday, Feb 13, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: login.php,v 1.47 2002/03/31 00:06:33 psotfx Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *   This file is part of the phpBB2 port to Nuke 5.5 (c) copyright 2002
 *   by Tom Nitzschner (tom@toms-home.com)
 *   http://bbtonuke.sourceforge.net (or http://www.toms-home.com)
 *
 *   As always, make a backup before messing with anything. All code
 *   release by me is considered sample code only. It may be fully
 *   functual, but you use it at your own risk, if you break it,
 *   you get to fix it too. No waranty is given or implied.
 *
 *   Please post all questions/request about this port on http://www.nukeforums.com first,
 *   then on my site. All original header code and copyright messages will be maintained
 *   to give credit where credit is due. If you modify this, the only requirement is
 *   that you also maintain all original copyright messages. All my work is released
 *   under the GNU GENERAL PUBLIC LICENSE. Please see the README for more information.
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

if (!eregi("modules.php", $PHP_SELF)) {
    die ("You can't access this file directly...");
}
$module_name = basename(dirname(__FILE__));
require("modules/".$module_name."/nukebb.php");

//
// Allow people to reach login page if
// board is shut down
//
define("IN_LOGIN", true);

define('IN_PHPBB', true);
//$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

//
// Set page ID for session management
//
$userdata = session_pagestart($user_ip, PAGE_LOGIN, $nukeuser);
init_userprefs($userdata);
//
// End session management
//

$header_location = ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) ) ? 'Refresh: 0; URL=' : 'Location: ';

if( isset($HTTP_POST_VARS['login']) || isset($HTTP_GET_VARS['login']) || isset($HTTP_POST_VARS['logout']) || isset($HTTP_GET_VARS['logout']) )
{
	//
	// This appears to work for IIS5 CGI under Win2K. Uses getenv
	// since this doesn't exist for ISAPI mode and therefore the 
	// normal Location redirector is used in preference
	//
	if( ( isset($HTTP_POST_VARS['login']) || isset($HTTP_GET_VARS['login']) ) && !$userdata['session_logged_in'] )
	{
		$username = isset($HTTP_POST_VARS['username']) ? $HTTP_POST_VARS['username'] : '';
		$password = isset($HTTP_POST_VARS['password']) ? $HTTP_POST_VARS['password'] : '';

		$sql = "SELECT uid, uname, pass, user_active, user_level, storynum, umode, uorder, thold, noscore, ublockon, theme, commentmax
			FROM " . USERS_TABLE . "
			WHERE uname = '" . str_replace("\'", "''", $username) . "'";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Error in obtaining userdata', '', __LINE__, __FILE__, $sql);
		}

		if( $row = $db->sql_fetchrow($result) )
		{
			if( $row['user_level'] != ADMIN && $board_config['board_disable'] )
			{
				header($header_location . append_sid($nuke_file_path."index", true));
			}
			else
			{
				if( md5($password) == $row['pass'] && $row['user_active'] )
				{
					$autologin = ( isset($HTTP_POST_VARS['autologin']) ) ? TRUE : 0;

					$userdata = session_begin($row['uid'], $user_ip, PAGE_INDEX, FALSE, $autologin);

					if( $userdata )
					{
						$redirect = $HTTP_POST_VARS['redirect'];
						if( !empty($redirect) )
						{
							if ( !ereg("modules.php", $redirect) || !ereg("/admin/admin", $redirect) )
							{
								$redirect = $nuke_file_path . $redirect;
							}
							header($header_location . append_sid($redirect, true));
						}
						else
						{
							header($header_location . append_sid($nuke_file_path."index", true));
						}
					}
					else
					{
						message_die(CRITICAL_ERROR, "Couldn't start session : login", "", __LINE__, __FILE__);
					}
					donukecookie($row[uid], $uname, $new_pass, $row[storynum], $row[umode], $row[uorder], $row[thold], $row[noscore], $row[ublockon], $row[theme], $row[commentmax]);

				}
				else
				{
					$redirect = ( !empty($HTTP_POST_VARS['redirect']) ) ? $HTTP_POST_VARS['redirect'] : '';

					$template->assign_vars(array(
						'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid($nuke_file_path."login&redirect=$redirect") . '">')
					);

					$message = $lang['Error_login'] . '<br /><br />' . sprintf($lang['Click_return_login'], '<a href="' . append_sid($nuke_file_path."login&redirect=$redirect") . '">', '</a>') . '<br /><br />' .  sprintf($lang['Click_return_index'], '<a href="' . append_sid($nuke_file_path."index") . '">', '</a>');

					message_die(GENERAL_MESSAGE, $message);
				}
			}
		}
		else
		{
			$redirect = ( !empty($HTTP_POST_VARS['redirect']) ) ? $HTTP_POST_VARS['redirect'] : "";

			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid($nuke_file_path."login&redirect=$redirect") . '">')
			);

			$message = $lang['Error_login'] . '<br /><br />' . sprintf($lang['Click_return_login'], '<a href="' . append_sid($nuke_file_path."login&redirect=$redirect") . '">', '</a>') . '<br /><br />' .  sprintf($lang['Click_return_index'], '<a href="' . append_sid($nuke_file_path."index") . '">', '</a>');

			message_die(GENERAL_MESSAGE, $message);
		}
	}
	else if( ( isset($HTTP_GET_VARS['logout']) || isset($HTTP_POST_VARS['logout']) ) && $userdata['session_logged_in'] )
	{
		if( $userdata['session_logged_in'] )
		{
			session_end($userdata['session_id'], $userdata['uid']);
		}

		if( !empty($HTTP_POST_VARS['redirect']) )
		{
			$redirect = $HTTP_POST_VARS['redirect'];
			if ( !ereg("modules.php", $redirect) || !ereg("/admin/admin", $redirect) )
			{
				$redirect = $nuke_file_path . $redirect;
			}
			header($header_location . append_sid($redirect, true));
		}
		else
		{
			header($header_location . append_sid($nuke_file_path."index", true));
		}
	}
	else
	{
		if( !empty($HTTP_POST_VARS['redirect']) )
		{
			$redirect = $HTTP_POST_VARS['redirect'];
			if ( !ereg("modules.php", $redirect) || !ereg("/admin/admin", $redirect) )
			{
				$redirect = $nuke_file_path . $redirect;
			}
			header($header_location . append_sid($redirect, true));
		}		
		else
		{
			header($header_location . append_sid($nuke_file_path."index", true));
		}
	}
}
else
{
	//
	// Do a full login page dohickey if
	// user not already logged in
	//
	if( !$userdata['session_logged_in'] )
	{
		$page_title = $lang['Login'];
		include($phpbb_root_path . 'includes/page_header.'.$phpEx);

		$template->set_filenames(array(
			'body' => 'login_body.tpl')
		);

		if( isset($HTTP_POST_VARS['redirect']) || isset($HTTP_GET_VARS['redirect']) )
		{
			$forward_to = $HTTP_SERVER_VARS['QUERY_STRING'];

			if( preg_match("/redirect=(.*)$/si", $forward_to, $forward_matches) )
			{
				$forward_to = ( !empty($forward_matches[3]) ) ? $forward_matches[3] : $forward_matches[1];

				$forward_match = explode('&', $forward_to);

				if(count($forward_match) > 1)
				{
					$forward_page = '';

					for($i = 1; $i < count($forward_match); $i++)
					{
						if( !ereg("sid=", $forward_match[$i]) )
						{
							if( $forward_page != '' )
							{
								$forward_page .= '&';
							}
							$forward_page .= $forward_match[$i];
						}
					}

					$forward_page = $forward_match[0] . '&' . $forward_page;
				}
				else
				{
					$forward_page = $forward_match[0];
				}
			}
		}
		else
		{
			$forward_page = '';
		}

		Header("Location: modules.php?name=Your_Account&redirect=$forward_page");
	}
	else
	{
		header($header_location . append_sid($nuke_file_path."index", true));
	}

}

?>
