<?
/***************************************************************************
 *                            mod_table_inst.php
 *                            -------------------
 *   begin                : Sunday, Jan 13, 2002
 *   copyright            : (C) 2002 Meik Sievertsen
 *   email                : acyd.burn@gmx.de
 *
 *   $Id: mod_table_inst.php,v 2.0.8 2002/02/27 meik Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);

$phpbb_root_path='./';
include($phpbb_root_path.'extension.inc');
include($phpbb_root_path.'common.'.$phpEx);	
	
//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_INDEX, $board_config['session_length']);
init_userprefs($userdata);
//
// End session management
//

if( !$userdata['session_logged_in'] )
{
	header("Location: " . append_sid("./login." . $phpEx . "?redirect=mod_table_inst." . $phpEx));
}

if( $userdata['user_level'] != ADMIN )
{
	message_die(GENERAL_MESSAGE, $lang['Not_Authorised']);
}

if ( (!isset($dbms)) || (($dbms != "mysql") && ($dbms != "mysql4") && ($dbms != "mssql") && ($dbms != "mssql-odbc") && ($dbms != "postgres")) )
{
	message_die(GENERAL_MESSAGE, "This Mod does only support MySQL, MSSQL and PostgreSQL.");
}
else if( isset($dbms) )
{
	include($phpbb_root_path.'includes/db.'.$phpEx);
}

//
// Now we are determining if upload files is allowed
//
$is_upload = ( ini_get('file_uploads') == 1 ) ? TRUE : FALSE;
$is_safemode = ( ini_get('safe_mode') == 1 ) ? TRUE : FALSE;

//
// Here we go
//
include($phpbb_root_path.'includes/sql_parse.'.$phpEx);

$available_dbms = array(
	"mysql" => array(
		"SCHEMA" => "attach_mysql", 
		"DELIM" => ";",
		"DELIM_BASIC" => ";",
		"COMMENTS" => "remove_remarks"
	), 
	"mysql4" => array(
		"SCHEMA" => "attach_mysql", 
		"DELIM" => ";", 
		"DELIM_BASIC" => ";",
		"COMMENTS" => "remove_remarks"
	),
	"mssql" => array(
		"SCHEMA" => "attach_mssql", 
		"DELIM" => "GO", 
		"DELIM_BASIC" => ";",
		"COMMENTS" => "remove_comments"
	),
	"mssql-odbc" =>	array(
		"SCHEMA" => "attach_mssql", 
		"DELIM" => "GO",
		"DELIM_BASIC" => ";",
		"COMMENTS" => "remove_comments"
	),
	"postgres" => array(
		"LABEL" => "PostgreSQL 7.x",
		"SCHEMA" => "attach_postgres", 
		"DELIM" => ";", 
		"DELIM_BASIC" => ";",
		"COMMENTS" => "remove_comments"
	)
);

$dbms_schema = 'db/schemas/' . $available_dbms[$dbms]['SCHEMA'] . '_schema.sql';
$dbms_basic = 'db/schemas/' . $available_dbms[$dbms]['SCHEMA'] . '_basic.sql';

$remove_remarks = $available_dbms[$dbms]['COMMENTS'];;
$delimiter = $available_dbms[$dbms]['DELIM']; 
$delimiter_basic = $available_dbms[$dbms]['DELIM_BASIC']; 

if ( !($fp = @fopen($dbms_schema, 'r')) )
{
	message_die(GENERAL_MESSAGE, "Can't open " . $dbms_schema);
}

fclose($fp);

if ( !($fp = @fopen($dbms_basic, 'r')) )
{
	message_die(GENERAL_MESSAGE, "Can't open " . $dbms_basic);
}

fclose($fp);

//
// process db schema
//
$sql_query = @fread(@fopen($dbms_schema, 'r'), @filesize($dbms_schema));
$sql_query = preg_replace('/phpbb_/', $table_prefix, $sql_query);

$sql_query = $remove_remarks($sql_query);
$sql_query = split_sql_file($sql_query, $delimiter);

$sql_count = count($sql_query);

//
// from update_to_rc3.php
//
echo "<html>\n";
echo "<body>\n";
for($i = 0; $i < $sql_count; $i++)
{
	echo "Running :: " . $sql_query[$i];
	flush();

	if ( !($result = $db->sql_query($sql_query[$i])) )
	{
		$errored = true;
		$error = $db->sql_error();
		echo " -> <b>FAILED</b> ---> <u>" . $error['message'] . "</u><br /><br />\n\n";
	}
	else
	{
		echo " -> <b>COMPLETED</b><br /><br />\n\n";
	}
}

//
// process basic informations
//
$sql_query = @fread(@fopen($dbms_basic, 'r'), @filesize($dbms_basic));
$sql_query = preg_replace('/phpbb_/', $table_prefix, $sql_query);

$sql_query = $remove_remarks($sql_query);
$sql_query = split_sql_file($sql_query, $delimiter_basic);

$sql_count = count($sql_query);

//
// from update_to_rc3.php
//
for($i = 0; $i < $sql_count; $i++)
{
	echo "Running :: " . $sql_query[$i];
	flush();

	if ( !($result = $db->sql_query($sql_query[$i])) )
	{
		$errored = true;
		$error = $db->sql_error();
		echo " -> <b>FAILED</b> ---> <u>" . $error['message'] . "</u><br /><br />\n\n";
	}
	else
	{
		echo " -> <b>COMPLETED</b><br /><br />\n\n";
	}
}

$message = "";

if (!$is_upload)
{
	$message .= "<b>NOTE: File Upload is probably not allowed by your ISP, please check this.</b><br />";
}

if ($is_safemode)
{
	$message .= "<b>NOTE: The PHP-Environment is probably in safe mode. Maybe you can't upload files.</b><br />";
}

if ( $errored )
{
	$message .= "<br />Some queries failed. Please contact me via email, pm, at the board or whatever, so we can solve your problems...<br />To Undo the changes to your database please execute mod_table_uninst.php.";
}
else
{
	$message .= "<br />Attachment Mod Tables generated successfully. To Undo the changes to your database please execute mod_table_uninst.php.";
}

echo "\n<br />\n<b>COMPLETE!</b><br />\n";
echo $message . "<br />";
echo "</body>";
echo "</html>";

?>