/*
 Attachment Mod PostgreSQL DB schema - Acyd Burn

*/

CREATE SEQUENCE phpbb_attach_types_id_seq start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;
CREATE SEQUENCE phpbb_attach_typeconfig_id_seq start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;
CREATE SEQUENCE phpbb_attach_extensions_id_seq start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;
CREATE SEQUENCE phpbb_attach_desc_id_seq start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;
CREATE SEQUENCE phpbb_attach_calendar_id_seq start 1 increment 1 maxvalue 2147483647 minvalue 1 cache 1;

/*
	Table structure for table 'phpbb_attach_types'
*/
CREATE TABLE phpbb_attach_types (
  type_id int DEFAULT nextval('phpbb_attach_types_id_seq'::text) NOT NULL,
  type_name char(20) NOT NULL,
  category int2 DEFAULT '0' NOT NULL,
  allow_type int2 DEFAULT '0' NOT NULL,
  download_mode int2 UNSIGNED DEFAULT '1' NOT NULL,
  upload_image varchar(100),
  max_filesize int(20) DEFAULT '0' NOT NULL,
  CONSTRAINT phpbb_attach_types_pkey PRIMARY KEY (type_id)
);

/*
	Table structure for table 'phpbb_attach_typeconfig'
*/
CREATE TABLE phpbb_attach_typeconfig (
  mime_id int DEFAULT nextval('phpbb_attach_typeconfig_id_seq'::text) NOT NULL,
  type_id int DEFAULT '0' NOT NULL,
  type_string varchar(100) NOT NULL,
  explain_mimetype varchar(100),
  CONSTRAINT phpbb_attach_typeconfig_pkey PRIMARY KEY (mime_id)
);
CREATE  INDEX type_id_phpbb_attach_typeconfig_index ON phpbb_attach_typeconfig (type_id);

/*
	Table structure for table 'phpbb_attach_extensions'
*/
CREATE TABLE phpbb_attach_extensions (
  ext_id int DEFAULT nextval('phpbb_attach_extensions_id_seq'::text) NOT NULL,
  extension char(10) NOT NULL, 
  CONSTRAINT phpbb_attach_extensions_pkey PRIMARY KEY (ext_id)
);

/*
	Table structure for table 'phpbb_attach_config'
*/
CREATE TABLE phpbb_attach_config (
   config_name varchar(255) NOT NULL,
   config_value varchar(255) NOT NULL,
   CONSTRAINT phpbb_attach_config_pkey PRIMARY KEY (config_name)
);

/*
	Table structure for table 'phpbb_attach_desc'
*/
CREATE TABLE phpbb_attach_desc (
  attach_id int4 DEFAULT nextval('phpbb_attach_desc_id_seq'::text) NOT NULL,
  post_id int4 DEFAULT '0' NOT NULL,
  attach_filename varchar(255) NOT NULL,
  download_count int4 DEFAULT '0' NOT NULL,
  filename varchar(255) NOT NULL,
  filesize int(20) NOT NULL,
  filetime int(11) DEFAULT '0' NOT NULL,
  comment char(60),
  mimetype char(60),
  CONSTRAINT phpbb_attach_desc_pkey PRIMARY KEY (attach_id)
);
CREATE  INDEX post_id_phpbb_attach_desc_index ON phpbb_attach_desc (post_id);
